<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.ContextSelectQuantity StructType
 * @subpackage Structs
 */
class BSRO_Sales_ContextSelectQuantity extends AnyEntity
{
    /**
     * The ItemsInGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemsInGroup;
    /**
     * The SelectedQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectedQuantity;
    /**
     * The SelectionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectionType;
    /**
     * Constructor method for bSRO.Sales.ContextSelectQuantity
     * @uses BSRO_Sales_ContextSelectQuantity::setItemsInGroup()
     * @uses BSRO_Sales_ContextSelectQuantity::setSelectedQuantity()
     * @uses BSRO_Sales_ContextSelectQuantity::setSelectionType()
     * @param int $itemsInGroup
     * @param int $selectedQuantity
     * @param string $selectionType
     */
    public function __construct($itemsInGroup = null, $selectedQuantity = null, $selectionType = null)
    {
        $this
            ->setItemsInGroup($itemsInGroup)
            ->setSelectedQuantity($selectedQuantity)
            ->setSelectionType($selectionType);
    }
    /**
     * Get ItemsInGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemsInGroup()
    {
        return isset($this->ItemsInGroup) ? $this->ItemsInGroup : null;
    }
    /**
     * Set ItemsInGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemsInGroup
     * @return \patest\StructType\BSRO_Sales_ContextSelectQuantity
     */
    public function setItemsInGroup($itemsInGroup = null)
    {
        // validation for constraint: int
        if (!is_null($itemsInGroup) && !(is_int($itemsInGroup) || ctype_digit($itemsInGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemsInGroup, true), gettype($itemsInGroup)), __LINE__);
        }
        if (is_null($itemsInGroup) || (is_array($itemsInGroup) && empty($itemsInGroup))) {
            unset($this->ItemsInGroup);
        } else {
            $this->ItemsInGroup = $itemsInGroup;
        }
        return $this;
    }
    /**
     * Get SelectedQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectedQuantity()
    {
        return isset($this->SelectedQuantity) ? $this->SelectedQuantity : null;
    }
    /**
     * Set SelectedQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectedQuantity
     * @return \patest\StructType\BSRO_Sales_ContextSelectQuantity
     */
    public function setSelectedQuantity($selectedQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($selectedQuantity) && !(is_int($selectedQuantity) || ctype_digit($selectedQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectedQuantity, true), gettype($selectedQuantity)), __LINE__);
        }
        if (is_null($selectedQuantity) || (is_array($selectedQuantity) && empty($selectedQuantity))) {
            unset($this->SelectedQuantity);
        } else {
            $this->SelectedQuantity = $selectedQuantity;
        }
        return $this;
    }
    /**
     * Get SelectionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectionType()
    {
        return isset($this->SelectionType) ? $this->SelectionType : null;
    }
    /**
     * Set SelectionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SelectionType::valueIsValid()
     * @uses \patest\EnumType\SelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionType
     * @return \patest\StructType\BSRO_Sales_ContextSelectQuantity
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SelectionType::valueIsValid($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SelectionType', is_array($selectionType) ? implode(', ', $selectionType) : var_export($selectionType, true), implode(', ', \patest\EnumType\SelectionType::getValidValues())), __LINE__);
        }
        if (is_null($selectionType) || (is_array($selectionType) && empty($selectionType))) {
            unset($this->SelectionType);
        } else {
            $this->SelectionType = $selectionType;
        }
        return $this;
    }
}
