<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailablePrintOption StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AvailablePrintOption
 * @subpackage Structs
 */
class AvailablePrintOption extends AbstractStructBase
{
    /**
     * The AskUser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AskUser;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentTypeDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeDescription;
    /**
     * The PrintByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PrintByDefault;
    /**
     * The DocumentTypeDetailedDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeDetailedDescription;
    /**
     * Constructor method for AvailablePrintOption
     * @uses AvailablePrintOption::setAskUser()
     * @uses AvailablePrintOption::setDocumentType()
     * @uses AvailablePrintOption::setDocumentTypeDescription()
     * @uses AvailablePrintOption::setPrintByDefault()
     * @uses AvailablePrintOption::setDocumentTypeDetailedDescription()
     * @param bool $askUser
     * @param string $documentType
     * @param string $documentTypeDescription
     * @param bool $printByDefault
     * @param string $documentTypeDetailedDescription
     */
    public function __construct($askUser = null, $documentType = null, $documentTypeDescription = null, $printByDefault = null, $documentTypeDetailedDescription = null)
    {
        $this
            ->setAskUser($askUser)
            ->setDocumentType($documentType)
            ->setDocumentTypeDescription($documentTypeDescription)
            ->setPrintByDefault($printByDefault)
            ->setDocumentTypeDetailedDescription($documentTypeDetailedDescription);
    }
    /**
     * Get AskUser value
     * @return bool|null
     */
    public function getAskUser()
    {
        return $this->AskUser;
    }
    /**
     * Set AskUser value
     * @param bool $askUser
     * @return \patest\StructType\AvailablePrintOption
     */
    public function setAskUser($askUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($askUser) && !is_bool($askUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($askUser, true), gettype($askUser)), __LINE__);
        }
        $this->AskUser = $askUser;
        return $this;
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentType
     * @return \patest\StructType\AvailablePrintOption
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get DocumentTypeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeDescription()
    {
        return isset($this->DocumentTypeDescription) ? $this->DocumentTypeDescription : null;
    }
    /**
     * Set DocumentTypeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeDescription
     * @return \patest\StructType\AvailablePrintOption
     */
    public function setDocumentTypeDescription($documentTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeDescription) && !is_string($documentTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeDescription, true), gettype($documentTypeDescription)), __LINE__);
        }
        if (is_null($documentTypeDescription) || (is_array($documentTypeDescription) && empty($documentTypeDescription))) {
            unset($this->DocumentTypeDescription);
        } else {
            $this->DocumentTypeDescription = $documentTypeDescription;
        }
        return $this;
    }
    /**
     * Get PrintByDefault value
     * @return bool|null
     */
    public function getPrintByDefault()
    {
        return $this->PrintByDefault;
    }
    /**
     * Set PrintByDefault value
     * @param bool $printByDefault
     * @return \patest\StructType\AvailablePrintOption
     */
    public function setPrintByDefault($printByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($printByDefault) && !is_bool($printByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printByDefault, true), gettype($printByDefault)), __LINE__);
        }
        $this->PrintByDefault = $printByDefault;
        return $this;
    }
    /**
     * Get DocumentTypeDetailedDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeDetailedDescription()
    {
        return isset($this->DocumentTypeDetailedDescription) ? $this->DocumentTypeDetailedDescription : null;
    }
    /**
     * Set DocumentTypeDetailedDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeDetailedDescription
     * @return \patest\StructType\AvailablePrintOption
     */
    public function setDocumentTypeDetailedDescription($documentTypeDetailedDescription = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeDetailedDescription) && !is_string($documentTypeDetailedDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeDetailedDescription, true), gettype($documentTypeDetailedDescription)), __LINE__);
        }
        if (is_null($documentTypeDetailedDescription) || (is_array($documentTypeDetailedDescription) && empty($documentTypeDetailedDescription))) {
            unset($this->DocumentTypeDetailedDescription);
        } else {
            $this->DocumentTypeDetailedDescription = $documentTypeDetailedDescription;
        }
        return $this;
    }
}
