<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Authentication.GoogleAuthenticationData StructType
 * @subpackage Structs
 */
class Authentication_GoogleAuthenticationData extends Authentication_ExternalAuthenticationData
{
    /**
     * The AccessToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessToken;
    /**
     * The Expires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Expires;
    /**
     * The RefreshToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefreshToken;
    /**
     * Constructor method for Authentication.GoogleAuthenticationData
     * @uses Authentication_GoogleAuthenticationData::setAccessToken()
     * @uses Authentication_GoogleAuthenticationData::setExpires()
     * @uses Authentication_GoogleAuthenticationData::setRefreshToken()
     * @param string $accessToken
     * @param string $expires
     * @param string $refreshToken
     */
    public function __construct($accessToken = null, $expires = null, $refreshToken = null)
    {
        $this
            ->setAccessToken($accessToken)
            ->setExpires($expires)
            ->setRefreshToken($refreshToken);
    }
    /**
     * Get AccessToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessToken()
    {
        return isset($this->AccessToken) ? $this->AccessToken : null;
    }
    /**
     * Set AccessToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessToken
     * @return \patest\StructType\Authentication_GoogleAuthenticationData
     */
    public function setAccessToken($accessToken = null)
    {
        // validation for constraint: string
        if (!is_null($accessToken) && !is_string($accessToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessToken, true), gettype($accessToken)), __LINE__);
        }
        if (is_null($accessToken) || (is_array($accessToken) && empty($accessToken))) {
            unset($this->AccessToken);
        } else {
            $this->AccessToken = $accessToken;
        }
        return $this;
    }
    /**
     * Get Expires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpires()
    {
        return isset($this->Expires) ? $this->Expires : null;
    }
    /**
     * Set Expires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expires
     * @return \patest\StructType\Authentication_GoogleAuthenticationData
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expires, true), gettype($expires)), __LINE__);
        }
        if (is_null($expires) || (is_array($expires) && empty($expires))) {
            unset($this->Expires);
        } else {
            $this->Expires = $expires;
        }
        return $this;
    }
    /**
     * Get RefreshToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefreshToken()
    {
        return isset($this->RefreshToken) ? $this->RefreshToken : null;
    }
    /**
     * Set RefreshToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refreshToken
     * @return \patest\StructType\Authentication_GoogleAuthenticationData
     */
    public function setRefreshToken($refreshToken = null)
    {
        // validation for constraint: string
        if (!is_null($refreshToken) && !is_string($refreshToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refreshToken, true), gettype($refreshToken)), __LINE__);
        }
        if (is_null($refreshToken) || (is_array($refreshToken) && empty($refreshToken))) {
            unset($this->RefreshToken);
        } else {
            $this->RefreshToken = $refreshToken;
        }
        return $this;
    }
}
