<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreaStatusInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreaStatusInformation
 * @subpackage Structs
 */
class AreaStatusInformation extends AbstractStructBase
{
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse
     */
    public $Seats;
    /**
     * The Capacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CapacityCounters
     */
    public $Capacity;
    /**
     * The BulkSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse
     */
    public $BulkSeats;
    /**
     * The GaPriceLevel
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GaPriceLevel;
    /**
     * The ApplicationChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ApplicationChannels;
    /**
     * The RestrictionCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatRestrictionsInfo
     */
    public $RestrictionCombinations;
    /**
     * The SaleModes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfNullableOfguid
     */
    public $SaleModes;
    /**
     * Constructor method for AreaStatusInformation
     * @uses AreaStatusInformation::setSeats()
     * @uses AreaStatusInformation::setCapacity()
     * @uses AreaStatusInformation::setBulkSeats()
     * @uses AreaStatusInformation::setGaPriceLevel()
     * @uses AreaStatusInformation::setApplicationChannels()
     * @uses AreaStatusInformation::setRestrictionCombinations()
     * @uses AreaStatusInformation::setSaleModes()
     * @param \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $seats
     * @param \patest\StructType\CapacityCounters $capacity
     * @param \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $bulkSeats
     * @param string $gaPriceLevel
     * @param \patest\ArrayType\ArrayOfstring $applicationChannels
     * @param \patest\ArrayType\ArrayOfSeatRestrictionsInfo $restrictionCombinations
     * @param \patest\ArrayType\ArrayOfNullableOfguid $saleModes
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $seats = null, \patest\StructType\CapacityCounters $capacity = null, \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $bulkSeats = null, $gaPriceLevel = null, \patest\ArrayType\ArrayOfstring $applicationChannels = null, \patest\ArrayType\ArrayOfSeatRestrictionsInfo $restrictionCombinations = null, \patest\ArrayType\ArrayOfNullableOfguid $saleModes = null)
    {
        $this
            ->setSeats($seats)
            ->setCapacity($capacity)
            ->setBulkSeats($bulkSeats)
            ->setGaPriceLevel($gaPriceLevel)
            ->setApplicationChannels($applicationChannels)
            ->setRestrictionCombinations($restrictionCombinations)
            ->setSaleModes($saleModes);
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $seats
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setSeats(\patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $seats = null)
    {
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CapacityCounters|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CapacityCounters $capacity
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setCapacity(\patest\StructType\CapacityCounters $capacity = null)
    {
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get BulkSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse|null
     */
    public function getBulkSeats()
    {
        return isset($this->BulkSeats) ? $this->BulkSeats : null;
    }
    /**
     * Set BulkSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $bulkSeats
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setBulkSeats(\patest\ArrayType\ArrayOfKeyValueOfintSeatStatusInformationvEzo7Bse $bulkSeats = null)
    {
        if (is_null($bulkSeats) || (is_array($bulkSeats) && empty($bulkSeats))) {
            unset($this->BulkSeats);
        } else {
            $this->BulkSeats = $bulkSeats;
        }
        return $this;
    }
    /**
     * Get GaPriceLevel value
     * @return string|null
     */
    public function getGaPriceLevel()
    {
        return $this->GaPriceLevel;
    }
    /**
     * Set GaPriceLevel value
     * @param string $gaPriceLevel
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setGaPriceLevel($gaPriceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($gaPriceLevel) && !is_string($gaPriceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gaPriceLevel, true), gettype($gaPriceLevel)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gaPriceLevel) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gaPriceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gaPriceLevel, true)), __LINE__);
        }
        $this->GaPriceLevel = $gaPriceLevel;
        return $this;
    }
    /**
     * Get ApplicationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getApplicationChannels()
    {
        return isset($this->ApplicationChannels) ? $this->ApplicationChannels : null;
    }
    /**
     * Set ApplicationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $applicationChannels
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setApplicationChannels(\patest\ArrayType\ArrayOfstring $applicationChannels = null)
    {
        if (is_null($applicationChannels) || (is_array($applicationChannels) && empty($applicationChannels))) {
            unset($this->ApplicationChannels);
        } else {
            $this->ApplicationChannels = $applicationChannels;
        }
        return $this;
    }
    /**
     * Get RestrictionCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatRestrictionsInfo|null
     */
    public function getRestrictionCombinations()
    {
        return isset($this->RestrictionCombinations) ? $this->RestrictionCombinations : null;
    }
    /**
     * Set RestrictionCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatRestrictionsInfo $restrictionCombinations
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setRestrictionCombinations(\patest\ArrayType\ArrayOfSeatRestrictionsInfo $restrictionCombinations = null)
    {
        if (is_null($restrictionCombinations) || (is_array($restrictionCombinations) && empty($restrictionCombinations))) {
            unset($this->RestrictionCombinations);
        } else {
            $this->RestrictionCombinations = $restrictionCombinations;
        }
        return $this;
    }
    /**
     * Get SaleModes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfNullableOfguid|null
     */
    public function getSaleModes()
    {
        return isset($this->SaleModes) ? $this->SaleModes : null;
    }
    /**
     * Set SaleModes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfNullableOfguid $saleModes
     * @return \patest\StructType\AreaStatusInformation
     */
    public function setSaleModes(\patest\ArrayType\ArrayOfNullableOfguid $saleModes = null)
    {
        if (is_null($saleModes) || (is_array($saleModes) && empty($saleModes))) {
            unset($this->SaleModes);
        } else {
            $this->SaleModes = $saleModes;
        }
        return $this;
    }
}
