<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreaMapDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AreaMapDesign
 * @subpackage Structs
 */
class AreaMapDesign extends AbstractStructBase
{
    /**
     * The AreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapGuid;
    /**
     * The DescriptionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DescriptionLevel;
    /**
     * The GASettings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GeneralAdmissionSettings
     */
    public $GASettings;
    /**
     * The GateCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1
     */
    public $GateCombinations;
    /**
     * The IncludedInMultipleVersions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludedInMultipleVersions;
    /**
     * The MaxSeatPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeatPriority;
    /**
     * The MinSeatPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeatPriority;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumberOfSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfSeats;
    /**
     * The ParentAreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentAreaGuid;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatingType;
    /**
     * The Sectors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSectorDesign
     */
    public $Sectors;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TurnstileCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1
     */
    public $TurnstileCombinations;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceLevelIds;
    /**
     * Constructor method for AreaMapDesign
     * @uses AreaMapDesign::setAreaMapGuid()
     * @uses AreaMapDesign::setDescriptionLevel()
     * @uses AreaMapDesign::setGASettings()
     * @uses AreaMapDesign::setGateCombinations()
     * @uses AreaMapDesign::setIncludedInMultipleVersions()
     * @uses AreaMapDesign::setMaxSeatPriority()
     * @uses AreaMapDesign::setMinSeatPriority()
     * @uses AreaMapDesign::setName()
     * @uses AreaMapDesign::setNumberOfSeats()
     * @uses AreaMapDesign::setParentAreaGuid()
     * @uses AreaMapDesign::setSeatingType()
     * @uses AreaMapDesign::setSectors()
     * @uses AreaMapDesign::setStatus()
     * @uses AreaMapDesign::setTurnstileCombinations()
     * @uses AreaMapDesign::setPriceLevelIds()
     * @param string $areaMapGuid
     * @param string $descriptionLevel
     * @param \patest\StructType\GeneralAdmissionSettings $gASettings
     * @param \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $gateCombinations
     * @param bool $includedInMultipleVersions
     * @param int $maxSeatPriority
     * @param int $minSeatPriority
     * @param \patest\StructType\GlobalString $name
     * @param int $numberOfSeats
     * @param string $parentAreaGuid
     * @param string $seatingType
     * @param \patest\ArrayType\ArrayOfSectorDesign $sectors
     * @param string $status
     * @param \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $turnstileCombinations
     * @param \patest\ArrayType\ArrayOfguid $priceLevelIds
     */
    public function __construct($areaMapGuid = null, $descriptionLevel = null, \patest\StructType\GeneralAdmissionSettings $gASettings = null, \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $gateCombinations = null, $includedInMultipleVersions = null, $maxSeatPriority = null, $minSeatPriority = null, \patest\StructType\GlobalString $name = null, $numberOfSeats = null, $parentAreaGuid = null, $seatingType = null, \patest\ArrayType\ArrayOfSectorDesign $sectors = null, $status = null, \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $turnstileCombinations = null, \patest\ArrayType\ArrayOfguid $priceLevelIds = null)
    {
        $this
            ->setAreaMapGuid($areaMapGuid)
            ->setDescriptionLevel($descriptionLevel)
            ->setGASettings($gASettings)
            ->setGateCombinations($gateCombinations)
            ->setIncludedInMultipleVersions($includedInMultipleVersions)
            ->setMaxSeatPriority($maxSeatPriority)
            ->setMinSeatPriority($minSeatPriority)
            ->setName($name)
            ->setNumberOfSeats($numberOfSeats)
            ->setParentAreaGuid($parentAreaGuid)
            ->setSeatingType($seatingType)
            ->setSectors($sectors)
            ->setStatus($status)
            ->setTurnstileCombinations($turnstileCombinations)
            ->setPriceLevelIds($priceLevelIds);
    }
    /**
     * Get AreaMapGuid value
     * @return string|null
     */
    public function getAreaMapGuid()
    {
        return $this->AreaMapGuid;
    }
    /**
     * Set AreaMapGuid value
     * @param string $areaMapGuid
     * @return \patest\StructType\AreaMapDesign
     */
    public function setAreaMapGuid($areaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapGuid) && !is_string($areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapGuid, true), gettype($areaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapGuid, true)), __LINE__);
        }
        $this->AreaMapGuid = $areaMapGuid;
        return $this;
    }
    /**
     * Get DescriptionLevel value
     * @return string|null
     */
    public function getDescriptionLevel()
    {
        return $this->DescriptionLevel;
    }
    /**
     * Set DescriptionLevel value
     * @uses \patest\EnumType\DescriptionLevel::valueIsValid()
     * @uses \patest\EnumType\DescriptionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $descriptionLevel
     * @return \patest\StructType\AreaMapDesign
     */
    public function setDescriptionLevel($descriptionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DescriptionLevel::valueIsValid($descriptionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DescriptionLevel', is_array($descriptionLevel) ? implode(', ', $descriptionLevel) : var_export($descriptionLevel, true), implode(', ', \patest\EnumType\DescriptionLevel::getValidValues())), __LINE__);
        }
        $this->DescriptionLevel = $descriptionLevel;
        return $this;
    }
    /**
     * Get GASettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GeneralAdmissionSettings|null
     */
    public function getGASettings()
    {
        return isset($this->GASettings) ? $this->GASettings : null;
    }
    /**
     * Set GASettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GeneralAdmissionSettings $gASettings
     * @return \patest\StructType\AreaMapDesign
     */
    public function setGASettings(\patest\StructType\GeneralAdmissionSettings $gASettings = null)
    {
        if (is_null($gASettings) || (is_array($gASettings) && empty($gASettings))) {
            unset($this->GASettings);
        } else {
            $this->GASettings = $gASettings;
        }
        return $this;
    }
    /**
     * Get GateCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1|null
     */
    public function getGateCombinations()
    {
        return isset($this->GateCombinations) ? $this->GateCombinations : null;
    }
    /**
     * Set GateCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $gateCombinations
     * @return \patest\StructType\AreaMapDesign
     */
    public function setGateCombinations(\patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $gateCombinations = null)
    {
        if (is_null($gateCombinations) || (is_array($gateCombinations) && empty($gateCombinations))) {
            unset($this->GateCombinations);
        } else {
            $this->GateCombinations = $gateCombinations;
        }
        return $this;
    }
    /**
     * Get IncludedInMultipleVersions value
     * @return bool|null
     */
    public function getIncludedInMultipleVersions()
    {
        return $this->IncludedInMultipleVersions;
    }
    /**
     * Set IncludedInMultipleVersions value
     * @param bool $includedInMultipleVersions
     * @return \patest\StructType\AreaMapDesign
     */
    public function setIncludedInMultipleVersions($includedInMultipleVersions = null)
    {
        // validation for constraint: boolean
        if (!is_null($includedInMultipleVersions) && !is_bool($includedInMultipleVersions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includedInMultipleVersions, true), gettype($includedInMultipleVersions)), __LINE__);
        }
        $this->IncludedInMultipleVersions = $includedInMultipleVersions;
        return $this;
    }
    /**
     * Get MaxSeatPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeatPriority()
    {
        return isset($this->MaxSeatPriority) ? $this->MaxSeatPriority : null;
    }
    /**
     * Set MaxSeatPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeatPriority
     * @return \patest\StructType\AreaMapDesign
     */
    public function setMaxSeatPriority($maxSeatPriority = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeatPriority) && !(is_int($maxSeatPriority) || ctype_digit($maxSeatPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeatPriority, true), gettype($maxSeatPriority)), __LINE__);
        }
        if (is_null($maxSeatPriority) || (is_array($maxSeatPriority) && empty($maxSeatPriority))) {
            unset($this->MaxSeatPriority);
        } else {
            $this->MaxSeatPriority = $maxSeatPriority;
        }
        return $this;
    }
    /**
     * Get MinSeatPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeatPriority()
    {
        return isset($this->MinSeatPriority) ? $this->MinSeatPriority : null;
    }
    /**
     * Set MinSeatPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeatPriority
     * @return \patest\StructType\AreaMapDesign
     */
    public function setMinSeatPriority($minSeatPriority = null)
    {
        // validation for constraint: int
        if (!is_null($minSeatPriority) && !(is_int($minSeatPriority) || ctype_digit($minSeatPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeatPriority, true), gettype($minSeatPriority)), __LINE__);
        }
        if (is_null($minSeatPriority) || (is_array($minSeatPriority) && empty($minSeatPriority))) {
            unset($this->MinSeatPriority);
        } else {
            $this->MinSeatPriority = $minSeatPriority;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\AreaMapDesign
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfSeats value
     * @return int|null
     */
    public function getNumberOfSeats()
    {
        return $this->NumberOfSeats;
    }
    /**
     * Set NumberOfSeats value
     * @param int $numberOfSeats
     * @return \patest\StructType\AreaMapDesign
     */
    public function setNumberOfSeats($numberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSeats) && !(is_int($numberOfSeats) || ctype_digit($numberOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSeats, true), gettype($numberOfSeats)), __LINE__);
        }
        $this->NumberOfSeats = $numberOfSeats;
        return $this;
    }
    /**
     * Get ParentAreaGuid value
     * @return string|null
     */
    public function getParentAreaGuid()
    {
        return $this->ParentAreaGuid;
    }
    /**
     * Set ParentAreaGuid value
     * @param string $parentAreaGuid
     * @return \patest\StructType\AreaMapDesign
     */
    public function setParentAreaGuid($parentAreaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentAreaGuid) && !is_string($parentAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentAreaGuid, true), gettype($parentAreaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentAreaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentAreaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentAreaGuid, true)), __LINE__);
        }
        $this->ParentAreaGuid = $parentAreaGuid;
        return $this;
    }
    /**
     * Get SeatingType value
     * @return string|null
     */
    public function getSeatingType()
    {
        return $this->SeatingType;
    }
    /**
     * Set SeatingType value
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\AreaMapDesign
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        $this->SeatingType = $seatingType;
        return $this;
    }
    /**
     * Get Sectors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSectorDesign|null
     */
    public function getSectors()
    {
        return isset($this->Sectors) ? $this->Sectors : null;
    }
    /**
     * Set Sectors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSectorDesign $sectors
     * @return \patest\StructType\AreaMapDesign
     */
    public function setSectors(\patest\ArrayType\ArrayOfSectorDesign $sectors = null)
    {
        if (is_null($sectors) || (is_array($sectors) && empty($sectors))) {
            unset($this->Sectors);
        } else {
            $this->Sectors = $sectors;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \patest\EnumType\AreaMapStatus::valueIsValid()
     * @uses \patest\EnumType\AreaMapStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\AreaMapDesign
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaMapStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaMapStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\AreaMapStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TurnstileCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1|null
     */
    public function getTurnstileCombinations()
    {
        return isset($this->TurnstileCombinations) ? $this->TurnstileCombinations : null;
    }
    /**
     * Set TurnstileCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $turnstileCombinations
     * @return \patest\StructType\AreaMapDesign
     */
    public function setTurnstileCombinations(\patest\ArrayType\ArrayOfKeyValueOfintArrayOfguidty7Ep6D1 $turnstileCombinations = null)
    {
        if (is_null($turnstileCombinations) || (is_array($turnstileCombinations) && empty($turnstileCombinations))) {
            unset($this->TurnstileCombinations);
        } else {
            $this->TurnstileCombinations = $turnstileCombinations;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceLevelIds
     * @return \patest\StructType\AreaMapDesign
     */
    public function setPriceLevelIds(\patest\ArrayType\ArrayOfguid $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
}
