<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.EntityChangesJournal StructType
 * @subpackage Structs
 */
class Any_EntityChangesJournal extends PersistableEntity
{
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The ContainingEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContainingEntityId;
    /**
     * The CorrelationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CorrelationId;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityTypeName;
    /**
     * The ErrorDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorDescription;
    /**
     * The EventDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDescription;
    /**
     * The EventSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventSystemName;
    /**
     * The EventTypeEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventTypeEnum;
    /**
     * The ImportanceEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImportanceEnum;
    /**
     * The JournalSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JournalSystemName;
    /**
     * The NewValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldValue;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PropertyCaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyCaptionId;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * The PropertySystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertySystemName;
    /**
     * Constructor method for Any.EntityChangesJournal
     * @uses Any_EntityChangesJournal::setConnectionAuditId()
     * @uses Any_EntityChangesJournal::setContainingEntityId()
     * @uses Any_EntityChangesJournal::setCorrelationId()
     * @uses Any_EntityChangesJournal::setDateTime()
     * @uses Any_EntityChangesJournal::setEntityId()
     * @uses Any_EntityChangesJournal::setEntityTypeName()
     * @uses Any_EntityChangesJournal::setErrorDescription()
     * @uses Any_EntityChangesJournal::setEventDescription()
     * @uses Any_EntityChangesJournal::setEventSystemName()
     * @uses Any_EntityChangesJournal::setEventTypeEnum()
     * @uses Any_EntityChangesJournal::setImportanceEnum()
     * @uses Any_EntityChangesJournal::setJournalSystemName()
     * @uses Any_EntityChangesJournal::setNewValue()
     * @uses Any_EntityChangesJournal::setOldValue()
     * @uses Any_EntityChangesJournal::setOrganizationUnitId()
     * @uses Any_EntityChangesJournal::setPropertyCaptionId()
     * @uses Any_EntityChangesJournal::setPropertyName()
     * @uses Any_EntityChangesJournal::setPropertySystemName()
     * @param int $connectionAuditId
     * @param string $containingEntityId
     * @param string $correlationId
     * @param string $dateTime
     * @param string $entityId
     * @param string $entityTypeName
     * @param string $errorDescription
     * @param string $eventDescription
     * @param string $eventSystemName
     * @param int $eventTypeEnum
     * @param int $importanceEnum
     * @param string $journalSystemName
     * @param string $newValue
     * @param string $oldValue
     * @param string $organizationUnitId
     * @param string $propertyCaptionId
     * @param string $propertyName
     * @param string $propertySystemName
     */
    public function __construct($connectionAuditId = null, $containingEntityId = null, $correlationId = null, $dateTime = null, $entityId = null, $entityTypeName = null, $errorDescription = null, $eventDescription = null, $eventSystemName = null, $eventTypeEnum = null, $importanceEnum = null, $journalSystemName = null, $newValue = null, $oldValue = null, $organizationUnitId = null, $propertyCaptionId = null, $propertyName = null, $propertySystemName = null)
    {
        $this
            ->setConnectionAuditId($connectionAuditId)
            ->setContainingEntityId($containingEntityId)
            ->setCorrelationId($correlationId)
            ->setDateTime($dateTime)
            ->setEntityId($entityId)
            ->setEntityTypeName($entityTypeName)
            ->setErrorDescription($errorDescription)
            ->setEventDescription($eventDescription)
            ->setEventSystemName($eventSystemName)
            ->setEventTypeEnum($eventTypeEnum)
            ->setImportanceEnum($importanceEnum)
            ->setJournalSystemName($journalSystemName)
            ->setNewValue($newValue)
            ->setOldValue($oldValue)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPropertyCaptionId($propertyCaptionId)
            ->setPropertyName($propertyName)
            ->setPropertySystemName($propertySystemName);
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get ContainingEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContainingEntityId()
    {
        return isset($this->ContainingEntityId) ? $this->ContainingEntityId : null;
    }
    /**
     * Set ContainingEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $containingEntityId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setContainingEntityId($containingEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($containingEntityId) && !is_string($containingEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containingEntityId, true), gettype($containingEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($containingEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $containingEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($containingEntityId, true)), __LINE__);
        }
        if (is_null($containingEntityId) || (is_array($containingEntityId) && empty($containingEntityId))) {
            unset($this->ContainingEntityId);
        } else {
            $this->ContainingEntityId = $containingEntityId;
        }
        return $this;
    }
    /**
     * Get CorrelationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCorrelationId()
    {
        return isset($this->CorrelationId) ? $this->CorrelationId : null;
    }
    /**
     * Set CorrelationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $correlationId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setCorrelationId($correlationId = null)
    {
        // validation for constraint: string
        if (!is_null($correlationId) && !is_string($correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correlationId, true), gettype($correlationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($correlationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $correlationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($correlationId, true)), __LINE__);
        }
        if (is_null($correlationId) || (is_array($correlationId) && empty($correlationId))) {
            unset($this->CorrelationId);
        } else {
            $this->CorrelationId = $correlationId;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityTypeName()
    {
        return isset($this->EntityTypeName) ? $this->EntityTypeName : null;
    }
    /**
     * Set EntityTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityTypeName
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setEntityTypeName($entityTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeName) && !is_string($entityTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeName, true), gettype($entityTypeName)), __LINE__);
        }
        if (is_null($entityTypeName) || (is_array($entityTypeName) && empty($entityTypeName))) {
            unset($this->EntityTypeName);
        } else {
            $this->EntityTypeName = $entityTypeName;
        }
        return $this;
    }
    /**
     * Get ErrorDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorDescription()
    {
        return isset($this->ErrorDescription) ? $this->ErrorDescription : null;
    }
    /**
     * Set ErrorDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorDescription
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorDescription, true), gettype($errorDescription)), __LINE__);
        }
        if (is_null($errorDescription) || (is_array($errorDescription) && empty($errorDescription))) {
            unset($this->ErrorDescription);
        } else {
            $this->ErrorDescription = $errorDescription;
        }
        return $this;
    }
    /**
     * Get EventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDescription()
    {
        return isset($this->EventDescription) ? $this->EventDescription : null;
    }
    /**
     * Set EventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDescription
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setEventDescription($eventDescription = null)
    {
        // validation for constraint: string
        if (!is_null($eventDescription) && !is_string($eventDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDescription, true), gettype($eventDescription)), __LINE__);
        }
        if (is_null($eventDescription) || (is_array($eventDescription) && empty($eventDescription))) {
            unset($this->EventDescription);
        } else {
            $this->EventDescription = $eventDescription;
        }
        return $this;
    }
    /**
     * Get EventSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSystemName()
    {
        return isset($this->EventSystemName) ? $this->EventSystemName : null;
    }
    /**
     * Set EventSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventSystemName
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setEventSystemName($eventSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($eventSystemName) && !is_string($eventSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSystemName, true), gettype($eventSystemName)), __LINE__);
        }
        if (is_null($eventSystemName) || (is_array($eventSystemName) && empty($eventSystemName))) {
            unset($this->EventSystemName);
        } else {
            $this->EventSystemName = $eventSystemName;
        }
        return $this;
    }
    /**
     * Get EventTypeEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventTypeEnum()
    {
        return isset($this->EventTypeEnum) ? $this->EventTypeEnum : null;
    }
    /**
     * Set EventTypeEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventTypeEnum
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setEventTypeEnum($eventTypeEnum = null)
    {
        // validation for constraint: int
        if (!is_null($eventTypeEnum) && !(is_int($eventTypeEnum) || ctype_digit($eventTypeEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventTypeEnum, true), gettype($eventTypeEnum)), __LINE__);
        }
        if (is_null($eventTypeEnum) || (is_array($eventTypeEnum) && empty($eventTypeEnum))) {
            unset($this->EventTypeEnum);
        } else {
            $this->EventTypeEnum = $eventTypeEnum;
        }
        return $this;
    }
    /**
     * Get ImportanceEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImportanceEnum()
    {
        return isset($this->ImportanceEnum) ? $this->ImportanceEnum : null;
    }
    /**
     * Set ImportanceEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $importanceEnum
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setImportanceEnum($importanceEnum = null)
    {
        // validation for constraint: int
        if (!is_null($importanceEnum) && !(is_int($importanceEnum) || ctype_digit($importanceEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($importanceEnum, true), gettype($importanceEnum)), __LINE__);
        }
        if (is_null($importanceEnum) || (is_array($importanceEnum) && empty($importanceEnum))) {
            unset($this->ImportanceEnum);
        } else {
            $this->ImportanceEnum = $importanceEnum;
        }
        return $this;
    }
    /**
     * Get JournalSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJournalSystemName()
    {
        return isset($this->JournalSystemName) ? $this->JournalSystemName : null;
    }
    /**
     * Set JournalSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journalSystemName
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setJournalSystemName($journalSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($journalSystemName) && !is_string($journalSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalSystemName, true), gettype($journalSystemName)), __LINE__);
        }
        if (is_null($journalSystemName) || (is_array($journalSystemName) && empty($journalSystemName))) {
            unset($this->JournalSystemName);
        } else {
            $this->JournalSystemName = $journalSystemName;
        }
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newValue
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldValue
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldValue, true), gettype($oldValue)), __LINE__);
        }
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PropertyCaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyCaptionId()
    {
        return isset($this->PropertyCaptionId) ? $this->PropertyCaptionId : null;
    }
    /**
     * Set PropertyCaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyCaptionId
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setPropertyCaptionId($propertyCaptionId = null)
    {
        // validation for constraint: string
        if (!is_null($propertyCaptionId) && !is_string($propertyCaptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyCaptionId, true), gettype($propertyCaptionId)), __LINE__);
        }
        if (is_null($propertyCaptionId) || (is_array($propertyCaptionId) && empty($propertyCaptionId))) {
            unset($this->PropertyCaptionId);
        } else {
            $this->PropertyCaptionId = $propertyCaptionId;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Get PropertySystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertySystemName()
    {
        return isset($this->PropertySystemName) ? $this->PropertySystemName : null;
    }
    /**
     * Set PropertySystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertySystemName
     * @return \patest\StructType\Any_EntityChangesJournal
     */
    public function setPropertySystemName($propertySystemName = null)
    {
        // validation for constraint: string
        if (!is_null($propertySystemName) && !is_string($propertySystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertySystemName, true), gettype($propertySystemName)), __LINE__);
        }
        if (is_null($propertySystemName) || (is_array($propertySystemName) && empty($propertySystemName))) {
            unset($this->PropertySystemName);
        } else {
            $this->PropertySystemName = $propertySystemName;
        }
        return $this;
    }
}
