<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.EntityChangeJournalEntry StructType
 * @subpackage Structs
 */
class Any_EntityChangeJournalEntry extends Foundation_JournalEntry
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Activity;
    /**
     * The ContainingEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContainingEntityId;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityTypeName;
    /**
     * The NewValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldValue;
    /**
     * The PropertyCaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyCaptionId;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * The PropertySystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertySystemName;
    /**
     * Constructor method for Any.EntityChangeJournalEntry
     * @uses Any_EntityChangeJournalEntry::setActivity()
     * @uses Any_EntityChangeJournalEntry::setContainingEntityId()
     * @uses Any_EntityChangeJournalEntry::setEntityId()
     * @uses Any_EntityChangeJournalEntry::setEntityTypeName()
     * @uses Any_EntityChangeJournalEntry::setNewValue()
     * @uses Any_EntityChangeJournalEntry::setOldValue()
     * @uses Any_EntityChangeJournalEntry::setPropertyCaptionId()
     * @uses Any_EntityChangeJournalEntry::setPropertyName()
     * @uses Any_EntityChangeJournalEntry::setPropertySystemName()
     * @param string $activity
     * @param string $containingEntityId
     * @param string $entityId
     * @param string $entityTypeName
     * @param string $newValue
     * @param string $oldValue
     * @param string $propertyCaptionId
     * @param string $propertyName
     * @param string $propertySystemName
     */
    public function __construct($activity = null, $containingEntityId = null, $entityId = null, $entityTypeName = null, $newValue = null, $oldValue = null, $propertyCaptionId = null, $propertyName = null, $propertySystemName = null)
    {
        $this
            ->setActivity($activity)
            ->setContainingEntityId($containingEntityId)
            ->setEntityId($entityId)
            ->setEntityTypeName($entityTypeName)
            ->setNewValue($newValue)
            ->setOldValue($oldValue)
            ->setPropertyCaptionId($propertyCaptionId)
            ->setPropertyName($propertyName)
            ->setPropertySystemName($propertySystemName);
    }
    /**
     * Get Activity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivity()
    {
        return isset($this->Activity) ? $this->Activity : null;
    }
    /**
     * Set Activity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activity
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: string
        if (!is_null($activity) && !is_string($activity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        if (is_null($activity) || (is_array($activity) && empty($activity))) {
            unset($this->Activity);
        } else {
            $this->Activity = $activity;
        }
        return $this;
    }
    /**
     * Get ContainingEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContainingEntityId()
    {
        return isset($this->ContainingEntityId) ? $this->ContainingEntityId : null;
    }
    /**
     * Set ContainingEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $containingEntityId
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setContainingEntityId($containingEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($containingEntityId) && !is_string($containingEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($containingEntityId, true), gettype($containingEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($containingEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $containingEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($containingEntityId, true)), __LINE__);
        }
        if (is_null($containingEntityId) || (is_array($containingEntityId) && empty($containingEntityId))) {
            unset($this->ContainingEntityId);
        } else {
            $this->ContainingEntityId = $containingEntityId;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityTypeName()
    {
        return isset($this->EntityTypeName) ? $this->EntityTypeName : null;
    }
    /**
     * Set EntityTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityTypeName
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setEntityTypeName($entityTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($entityTypeName) && !is_string($entityTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityTypeName, true), gettype($entityTypeName)), __LINE__);
        }
        if (is_null($entityTypeName) || (is_array($entityTypeName) && empty($entityTypeName))) {
            unset($this->EntityTypeName);
        } else {
            $this->EntityTypeName = $entityTypeName;
        }
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newValue
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldValue
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldValue, true), gettype($oldValue)), __LINE__);
        }
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Get PropertyCaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyCaptionId()
    {
        return isset($this->PropertyCaptionId) ? $this->PropertyCaptionId : null;
    }
    /**
     * Set PropertyCaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyCaptionId
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setPropertyCaptionId($propertyCaptionId = null)
    {
        // validation for constraint: string
        if (!is_null($propertyCaptionId) && !is_string($propertyCaptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyCaptionId, true), gettype($propertyCaptionId)), __LINE__);
        }
        if (is_null($propertyCaptionId) || (is_array($propertyCaptionId) && empty($propertyCaptionId))) {
            unset($this->PropertyCaptionId);
        } else {
            $this->PropertyCaptionId = $propertyCaptionId;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Get PropertySystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertySystemName()
    {
        return isset($this->PropertySystemName) ? $this->PropertySystemName : null;
    }
    /**
     * Set PropertySystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertySystemName
     * @return \patest\StructType\Any_EntityChangeJournalEntry
     */
    public function setPropertySystemName($propertySystemName = null)
    {
        // validation for constraint: string
        if (!is_null($propertySystemName) && !is_string($propertySystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertySystemName, true), gettype($propertySystemName)), __LINE__);
        }
        if (is_null($propertySystemName) || (is_array($propertySystemName) && empty($propertySystemName))) {
            unset($this->PropertySystemName);
        } else {
            $this->PropertySystemName = $propertySystemName;
        }
        return $this;
    }
}
