<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.BaseBatchOperationsLog StructType
 * @subpackage Structs
 */
class Any_BaseBatchOperationsLog extends AnyEntity
{
    /**
     * The BatchLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchLocalId;
    /**
     * The BatchOperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchOperationId;
    /**
     * The BatchResultsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchResultsNumber;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Errors;
    /**
     * The IsMassEnrollmentUndone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMassEnrollmentUndone;
    /**
     * The RecordsProcessed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecordsProcessed;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $User;
    /**
     * Constructor method for Any.BaseBatchOperationsLog
     * @uses Any_BaseBatchOperationsLog::setBatchLocalId()
     * @uses Any_BaseBatchOperationsLog::setBatchOperationId()
     * @uses Any_BaseBatchOperationsLog::setBatchResultsNumber()
     * @uses Any_BaseBatchOperationsLog::setClientTypes()
     * @uses Any_BaseBatchOperationsLog::setDate()
     * @uses Any_BaseBatchOperationsLog::setErrors()
     * @uses Any_BaseBatchOperationsLog::setIsMassEnrollmentUndone()
     * @uses Any_BaseBatchOperationsLog::setRecordsProcessed()
     * @uses Any_BaseBatchOperationsLog::setUser()
     * @param int $batchLocalId
     * @param string $batchOperationId
     * @param int $batchResultsNumber
     * @param string $clientTypes
     * @param string $date
     * @param int $errors
     * @param bool $isMassEnrollmentUndone
     * @param int $recordsProcessed
     * @param string $user
     */
    public function __construct($batchLocalId = null, $batchOperationId = null, $batchResultsNumber = null, $clientTypes = null, $date = null, $errors = null, $isMassEnrollmentUndone = null, $recordsProcessed = null, $user = null)
    {
        $this
            ->setBatchLocalId($batchLocalId)
            ->setBatchOperationId($batchOperationId)
            ->setBatchResultsNumber($batchResultsNumber)
            ->setClientTypes($clientTypes)
            ->setDate($date)
            ->setErrors($errors)
            ->setIsMassEnrollmentUndone($isMassEnrollmentUndone)
            ->setRecordsProcessed($recordsProcessed)
            ->setUser($user);
    }
    /**
     * Get BatchLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchLocalId()
    {
        return isset($this->BatchLocalId) ? $this->BatchLocalId : null;
    }
    /**
     * Set BatchLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchLocalId
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setBatchLocalId($batchLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($batchLocalId) && !(is_int($batchLocalId) || ctype_digit($batchLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchLocalId, true), gettype($batchLocalId)), __LINE__);
        }
        if (is_null($batchLocalId) || (is_array($batchLocalId) && empty($batchLocalId))) {
            unset($this->BatchLocalId);
        } else {
            $this->BatchLocalId = $batchLocalId;
        }
        return $this;
    }
    /**
     * Get BatchOperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchOperationId()
    {
        return isset($this->BatchOperationId) ? $this->BatchOperationId : null;
    }
    /**
     * Set BatchOperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchOperationId
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setBatchOperationId($batchOperationId = null)
    {
        // validation for constraint: string
        if (!is_null($batchOperationId) && !is_string($batchOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchOperationId, true), gettype($batchOperationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchOperationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchOperationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchOperationId, true)), __LINE__);
        }
        if (is_null($batchOperationId) || (is_array($batchOperationId) && empty($batchOperationId))) {
            unset($this->BatchOperationId);
        } else {
            $this->BatchOperationId = $batchOperationId;
        }
        return $this;
    }
    /**
     * Get BatchResultsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchResultsNumber()
    {
        return isset($this->BatchResultsNumber) ? $this->BatchResultsNumber : null;
    }
    /**
     * Set BatchResultsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchResultsNumber
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setBatchResultsNumber($batchResultsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($batchResultsNumber) && !(is_int($batchResultsNumber) || ctype_digit($batchResultsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchResultsNumber, true), gettype($batchResultsNumber)), __LINE__);
        }
        if (is_null($batchResultsNumber) || (is_array($batchResultsNumber) && empty($batchResultsNumber))) {
            unset($this->BatchResultsNumber);
        } else {
            $this->BatchResultsNumber = $batchResultsNumber;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $errors
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setErrors($errors = null)
    {
        // validation for constraint: int
        if (!is_null($errors) && !(is_int($errors) || ctype_digit($errors))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errors, true), gettype($errors)), __LINE__);
        }
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get IsMassEnrollmentUndone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMassEnrollmentUndone()
    {
        return isset($this->IsMassEnrollmentUndone) ? $this->IsMassEnrollmentUndone : null;
    }
    /**
     * Set IsMassEnrollmentUndone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMassEnrollmentUndone
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setIsMassEnrollmentUndone($isMassEnrollmentUndone = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMassEnrollmentUndone) && !is_bool($isMassEnrollmentUndone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMassEnrollmentUndone, true), gettype($isMassEnrollmentUndone)), __LINE__);
        }
        if (is_null($isMassEnrollmentUndone) || (is_array($isMassEnrollmentUndone) && empty($isMassEnrollmentUndone))) {
            unset($this->IsMassEnrollmentUndone);
        } else {
            $this->IsMassEnrollmentUndone = $isMassEnrollmentUndone;
        }
        return $this;
    }
    /**
     * Get RecordsProcessed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecordsProcessed()
    {
        return isset($this->RecordsProcessed) ? $this->RecordsProcessed : null;
    }
    /**
     * Set RecordsProcessed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recordsProcessed
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setRecordsProcessed($recordsProcessed = null)
    {
        // validation for constraint: int
        if (!is_null($recordsProcessed) && !(is_int($recordsProcessed) || ctype_digit($recordsProcessed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsProcessed, true), gettype($recordsProcessed)), __LINE__);
        }
        if (is_null($recordsProcessed) || (is_array($recordsProcessed) && empty($recordsProcessed))) {
            unset($this->RecordsProcessed);
        } else {
            $this->RecordsProcessed = $recordsProcessed;
        }
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \patest\StructType\Any_BaseBatchOperationsLog
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($user) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($user, true)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
}
