<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.Attachment StructType
 * @subpackage Structs
 */
class Any_Attachment extends PersistableEntity
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The CompressedSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CompressedSize;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The Extension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Extension;
    /**
     * The ExtraReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraReferenceId;
    /**
     * The LinkUrlOrPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkUrlOrPath;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RelatedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedEntityId;
    /**
     * The RelatedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityName;
    /**
     * The Size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Size;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The WasSavedCompressed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasSavedCompressed;
    /**
     * Constructor method for Any.Attachment
     * @uses Any_Attachment::setComment()
     * @uses Any_Attachment::setCompressedSize()
     * @uses Any_Attachment::setCreationDate()
     * @uses Any_Attachment::setData()
     * @uses Any_Attachment::setExtension()
     * @uses Any_Attachment::setExtraReferenceId()
     * @uses Any_Attachment::setLinkUrlOrPath()
     * @uses Any_Attachment::setName()
     * @uses Any_Attachment::setRelatedEntityId()
     * @uses Any_Attachment::setRelatedEntityName()
     * @uses Any_Attachment::setSize()
     * @uses Any_Attachment::setUserId()
     * @uses Any_Attachment::setWasSavedCompressed()
     * @param \patest\StructType\GlobalString $comment
     * @param int $compressedSize
     * @param string $creationDate
     * @param string $data
     * @param string $extension
     * @param string $extraReferenceId
     * @param string $linkUrlOrPath
     * @param string $name
     * @param string $relatedEntityId
     * @param string $relatedEntityName
     * @param int $size
     * @param string $userId
     * @param bool $wasSavedCompressed
     */
    public function __construct(\patest\StructType\GlobalString $comment = null, $compressedSize = null, $creationDate = null, $data = null, $extension = null, $extraReferenceId = null, $linkUrlOrPath = null, $name = null, $relatedEntityId = null, $relatedEntityName = null, $size = null, $userId = null, $wasSavedCompressed = null)
    {
        $this
            ->setComment($comment)
            ->setCompressedSize($compressedSize)
            ->setCreationDate($creationDate)
            ->setData($data)
            ->setExtension($extension)
            ->setExtraReferenceId($extraReferenceId)
            ->setLinkUrlOrPath($linkUrlOrPath)
            ->setName($name)
            ->setRelatedEntityId($relatedEntityId)
            ->setRelatedEntityName($relatedEntityName)
            ->setSize($size)
            ->setUserId($userId)
            ->setWasSavedCompressed($wasSavedCompressed);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\Any_Attachment
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get CompressedSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCompressedSize()
    {
        return isset($this->CompressedSize) ? $this->CompressedSize : null;
    }
    /**
     * Set CompressedSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $compressedSize
     * @return \patest\StructType\Any_Attachment
     */
    public function setCompressedSize($compressedSize = null)
    {
        // validation for constraint: int
        if (!is_null($compressedSize) && !(is_int($compressedSize) || ctype_digit($compressedSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($compressedSize, true), gettype($compressedSize)), __LINE__);
        }
        if (is_null($compressedSize) || (is_array($compressedSize) && empty($compressedSize))) {
            unset($this->CompressedSize);
        } else {
            $this->CompressedSize = $compressedSize;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Any_Attachment
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \patest\StructType\Any_Attachment
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get Extension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtension()
    {
        return isset($this->Extension) ? $this->Extension : null;
    }
    /**
     * Set Extension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extension
     * @return \patest\StructType\Any_Attachment
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        if (is_null($extension) || (is_array($extension) && empty($extension))) {
            unset($this->Extension);
        } else {
            $this->Extension = $extension;
        }
        return $this;
    }
    /**
     * Get ExtraReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraReferenceId()
    {
        return isset($this->ExtraReferenceId) ? $this->ExtraReferenceId : null;
    }
    /**
     * Set ExtraReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraReferenceId
     * @return \patest\StructType\Any_Attachment
     */
    public function setExtraReferenceId($extraReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($extraReferenceId) && !is_string($extraReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraReferenceId, true), gettype($extraReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraReferenceId, true)), __LINE__);
        }
        if (is_null($extraReferenceId) || (is_array($extraReferenceId) && empty($extraReferenceId))) {
            unset($this->ExtraReferenceId);
        } else {
            $this->ExtraReferenceId = $extraReferenceId;
        }
        return $this;
    }
    /**
     * Get LinkUrlOrPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkUrlOrPath()
    {
        return isset($this->LinkUrlOrPath) ? $this->LinkUrlOrPath : null;
    }
    /**
     * Set LinkUrlOrPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkUrlOrPath
     * @return \patest\StructType\Any_Attachment
     */
    public function setLinkUrlOrPath($linkUrlOrPath = null)
    {
        // validation for constraint: string
        if (!is_null($linkUrlOrPath) && !is_string($linkUrlOrPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkUrlOrPath, true), gettype($linkUrlOrPath)), __LINE__);
        }
        if (is_null($linkUrlOrPath) || (is_array($linkUrlOrPath) && empty($linkUrlOrPath))) {
            unset($this->LinkUrlOrPath);
        } else {
            $this->LinkUrlOrPath = $linkUrlOrPath;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Any_Attachment
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RelatedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityId()
    {
        return isset($this->RelatedEntityId) ? $this->RelatedEntityId : null;
    }
    /**
     * Set RelatedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityId
     * @return \patest\StructType\Any_Attachment
     */
    public function setRelatedEntityId($relatedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityId) && !is_string($relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityId, true), gettype($relatedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedEntityId, true)), __LINE__);
        }
        if (is_null($relatedEntityId) || (is_array($relatedEntityId) && empty($relatedEntityId))) {
            unset($this->RelatedEntityId);
        } else {
            $this->RelatedEntityId = $relatedEntityId;
        }
        return $this;
    }
    /**
     * Get RelatedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityName()
    {
        return isset($this->RelatedEntityName) ? $this->RelatedEntityName : null;
    }
    /**
     * Set RelatedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityName
     * @return \patest\StructType\Any_Attachment
     */
    public function setRelatedEntityName($relatedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityName) && !is_string($relatedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityName, true), gettype($relatedEntityName)), __LINE__);
        }
        if (is_null($relatedEntityName) || (is_array($relatedEntityName) && empty($relatedEntityName))) {
            unset($this->RelatedEntityName);
        } else {
            $this->RelatedEntityName = $relatedEntityName;
        }
        return $this;
    }
    /**
     * Get Size value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSize()
    {
        return isset($this->Size) ? $this->Size : null;
    }
    /**
     * Set Size value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $size
     * @return \patest\StructType\Any_Attachment
     */
    public function setSize($size = null)
    {
        // validation for constraint: int
        if (!is_null($size) && !(is_int($size) || ctype_digit($size))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($size, true), gettype($size)), __LINE__);
        }
        if (is_null($size) || (is_array($size) && empty($size))) {
            unset($this->Size);
        } else {
            $this->Size = $size;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Any_Attachment
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get WasSavedCompressed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasSavedCompressed()
    {
        return isset($this->WasSavedCompressed) ? $this->WasSavedCompressed : null;
    }
    /**
     * Set WasSavedCompressed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasSavedCompressed
     * @return \patest\StructType\Any_Attachment
     */
    public function setWasSavedCompressed($wasSavedCompressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasSavedCompressed) && !is_bool($wasSavedCompressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasSavedCompressed, true), gettype($wasSavedCompressed)), __LINE__);
        }
        if (is_null($wasSavedCompressed) || (is_array($wasSavedCompressed) && empty($wasSavedCompressed))) {
            unset($this->WasSavedCompressed);
        } else {
            $this->WasSavedCompressed = $wasSavedCompressed;
        }
        return $this;
    }
}
