<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdvancedTicketCatchInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdvancedTicketCatchInfo
 * @subpackage Structs
 */
class AdvancedTicketCatchInfo extends AbstractStructBase
{
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * Constructor method for AdvancedTicketCatchInfo
     * @uses AdvancedTicketCatchInfo::setSubscriberTicketType()
     * @uses AdvancedTicketCatchInfo::setSubscriptionInstanceId()
     * @param string $subscriberTicketType
     * @param string $subscriptionInstanceId
     */
    public function __construct($subscriberTicketType = null, $subscriptionInstanceId = null)
    {
        $this
            ->setSubscriberTicketType($subscriberTicketType)
            ->setSubscriptionInstanceId($subscriptionInstanceId);
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\AdvancedTicketCatchInfo
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\AdvancedTicketCatchInfo
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
}
