<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddTicketsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddTicketsToBasket-Request
 * @subpackage Structs
 */
class AddTicketsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The DeliveredByItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveredByItemId;
    /**
     * The ECardIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfNullableOfguid
     */
    public $ECardIds;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The IsConvertPricingErrorsIntoIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertPricingErrorsIntoIncomplete;
    /**
     * The SeatsToCatch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCatchSeatRequest
     */
    public $SeatsToCatch;
    /**
     * The SubscriptionInstanceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $SubscriptionInstanceIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The IsReplaceExistingTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReplaceExistingTickets;
    /**
     * The TicketItemIdsToDiscard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $TicketItemIdsToDiscard;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrderIdentity
     */
    public $OrderIdentity;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The AccessCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCodeId;
    /**
     * Constructor method for AddTicketsToBasket-Request
     * @uses AddTicketsToBasket_Request::setDeliveredByItemId()
     * @uses AddTicketsToBasket_Request::setECardIds()
     * @uses AddTicketsToBasket_Request::setEventGuid()
     * @uses AddTicketsToBasket_Request::setIsConvertPricingErrorsIntoIncomplete()
     * @uses AddTicketsToBasket_Request::setSeatsToCatch()
     * @uses AddTicketsToBasket_Request::setSubscriptionInstanceIds()
     * @uses AddTicketsToBasket_Request::setTransactionGuid()
     * @uses AddTicketsToBasket_Request::setTransactionSnapshotType()
     * @uses AddTicketsToBasket_Request::setIsReplaceExistingTickets()
     * @uses AddTicketsToBasket_Request::setTicketItemIdsToDiscard()
     * @uses AddTicketsToBasket_Request::setOrderIdentity()
     * @uses AddTicketsToBasket_Request::setEffectiveAvailabilityFilter()
     * @uses AddTicketsToBasket_Request::setCouponIdentity()
     * @uses AddTicketsToBasket_Request::setAccessCodeId()
     * @param int $deliveredByItemId
     * @param \patest\ArrayType\ArrayOfNullableOfguid $eCardIds
     * @param string $eventGuid
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $isReplaceExistingTickets
     * @param \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param string $accessCodeId
     */
    public function __construct($deliveredByItemId = null, \patest\ArrayType\ArrayOfNullableOfguid $eCardIds = null, $eventGuid = null, $isConvertPricingErrorsIntoIncomplete = null, \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null, \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null, $transactionGuid = null, $transactionSnapshotType = null, $isReplaceExistingTickets = null, \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard = null, \patest\StructType\OrderIdentity $orderIdentity = null, \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, \patest\StructType\CouponIdentity $couponIdentity = null, $accessCodeId = null)
    {
        $this
            ->setDeliveredByItemId($deliveredByItemId)
            ->setECardIds($eCardIds)
            ->setEventGuid($eventGuid)
            ->setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete)
            ->setSeatsToCatch($seatsToCatch)
            ->setSubscriptionInstanceIds($subscriptionInstanceIds)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setIsReplaceExistingTickets($isReplaceExistingTickets)
            ->setTicketItemIdsToDiscard($ticketItemIdsToDiscard)
            ->setOrderIdentity($orderIdentity)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setCouponIdentity($couponIdentity)
            ->setAccessCodeId($accessCodeId);
    }
    /**
     * Get DeliveredByItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveredByItemId()
    {
        return isset($this->DeliveredByItemId) ? $this->DeliveredByItemId : null;
    }
    /**
     * Set DeliveredByItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveredByItemId
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setDeliveredByItemId($deliveredByItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredByItemId) && !(is_int($deliveredByItemId) || ctype_digit($deliveredByItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredByItemId, true), gettype($deliveredByItemId)), __LINE__);
        }
        if (is_null($deliveredByItemId) || (is_array($deliveredByItemId) && empty($deliveredByItemId))) {
            unset($this->DeliveredByItemId);
        } else {
            $this->DeliveredByItemId = $deliveredByItemId;
        }
        return $this;
    }
    /**
     * Get ECardIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfNullableOfguid|null
     */
    public function getECardIds()
    {
        return isset($this->ECardIds) ? $this->ECardIds : null;
    }
    /**
     * Set ECardIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfNullableOfguid $eCardIds
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setECardIds(\patest\ArrayType\ArrayOfNullableOfguid $eCardIds = null)
    {
        if (is_null($eCardIds) || (is_array($eCardIds) && empty($eCardIds))) {
            unset($this->ECardIds);
        } else {
            $this->ECardIds = $eCardIds;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * @return string|null
     */
    public function getEventGuid()
    {
        return $this->EventGuid;
    }
    /**
     * Set EventGuid value
     * @param string $eventGuid
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        $this->EventGuid = $eventGuid;
        return $this;
    }
    /**
     * Get IsConvertPricingErrorsIntoIncomplete value
     * @return bool|null
     */
    public function getIsConvertPricingErrorsIntoIncomplete()
    {
        return $this->IsConvertPricingErrorsIntoIncomplete;
    }
    /**
     * Set IsConvertPricingErrorsIntoIncomplete value
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertPricingErrorsIntoIncomplete) && !is_bool($isConvertPricingErrorsIntoIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertPricingErrorsIntoIncomplete, true), gettype($isConvertPricingErrorsIntoIncomplete)), __LINE__);
        }
        $this->IsConvertPricingErrorsIntoIncomplete = $isConvertPricingErrorsIntoIncomplete;
        return $this;
    }
    /**
     * Get SeatsToCatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCatchSeatRequest|null
     */
    public function getSeatsToCatch()
    {
        return isset($this->SeatsToCatch) ? $this->SeatsToCatch : null;
    }
    /**
     * Set SeatsToCatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setSeatsToCatch(\patest\ArrayType\ArrayOfCatchSeatRequest $seatsToCatch = null)
    {
        if (is_null($seatsToCatch) || (is_array($seatsToCatch) && empty($seatsToCatch))) {
            unset($this->SeatsToCatch);
        } else {
            $this->SeatsToCatch = $seatsToCatch;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getSubscriptionInstanceIds()
    {
        return isset($this->SubscriptionInstanceIds) ? $this->SubscriptionInstanceIds : null;
    }
    /**
     * Set SubscriptionInstanceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $subscriptionInstanceIds
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setSubscriptionInstanceIds(\patest\ArrayType\ArrayOfguid $subscriptionInstanceIds = null)
    {
        if (is_null($subscriptionInstanceIds) || (is_array($subscriptionInstanceIds) && empty($subscriptionInstanceIds))) {
            unset($this->SubscriptionInstanceIds);
        } else {
            $this->SubscriptionInstanceIds = $subscriptionInstanceIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get IsReplaceExistingTickets value
     * @return bool|null
     */
    public function getIsReplaceExistingTickets()
    {
        return $this->IsReplaceExistingTickets;
    }
    /**
     * Set IsReplaceExistingTickets value
     * @param bool $isReplaceExistingTickets
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setIsReplaceExistingTickets($isReplaceExistingTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceExistingTickets) && !is_bool($isReplaceExistingTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceExistingTickets, true), gettype($isReplaceExistingTickets)), __LINE__);
        }
        $this->IsReplaceExistingTickets = $isReplaceExistingTickets;
        return $this;
    }
    /**
     * Get TicketItemIdsToDiscard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getTicketItemIdsToDiscard()
    {
        return isset($this->TicketItemIdsToDiscard) ? $this->TicketItemIdsToDiscard : null;
    }
    /**
     * Set TicketItemIdsToDiscard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setTicketItemIdsToDiscard(\patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard = null)
    {
        if (is_null($ticketItemIdsToDiscard) || (is_array($ticketItemIdsToDiscard) && empty($ticketItemIdsToDiscard))) {
            unset($this->TicketItemIdsToDiscard);
        } else {
            $this->TicketItemIdsToDiscard = $ticketItemIdsToDiscard;
        }
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrderIdentity|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setOrderIdentity(\patest\StructType\OrderIdentity $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get AccessCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeId()
    {
        return isset($this->AccessCodeId) ? $this->AccessCodeId : null;
    }
    /**
     * Set AccessCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeId
     * @return \patest\StructType\AddTicketsToBasket_Request
     */
    public function setAccessCodeId($accessCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeId) && !is_string($accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeId, true), gettype($accessCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCodeId, true)), __LINE__);
        }
        if (is_null($accessCodeId) || (is_array($accessCodeId) && empty($accessCodeId))) {
            unset($this->AccessCodeId);
        } else {
            $this->AccessCodeId = $accessCodeId;
        }
        return $this;
    }
}
