<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPromptExtraProductsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddPromptExtraProductsToBasket-Request
 * @subpackage Structs
 */
class AddPromptExtraProductsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The LinkingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\LinkingProductDetails
     */
    public $LinkingDetails;
    /**
     * The OriginativeItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $OriginativeItemIds;
    /**
     * The PromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromptId;
    /**
     * The RequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase
     */
    public $RequestDetails;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddPromptExtraProductsToBasket-Request
     * @uses AddPromptExtraProductsToBasket_Request::setLinkingDetails()
     * @uses AddPromptExtraProductsToBasket_Request::setOriginativeItemIds()
     * @uses AddPromptExtraProductsToBasket_Request::setPromptId()
     * @uses AddPromptExtraProductsToBasket_Request::setRequestDetails()
     * @uses AddPromptExtraProductsToBasket_Request::setTransactionGuid()
     * @uses AddPromptExtraProductsToBasket_Request::setTransactionSnapshotType()
     * @param \patest\StructType\LinkingProductDetails $linkingDetails
     * @param \patest\ArrayType\ArrayOfint $originativeItemIds
     * @param string $promptId
     * @param \patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase $requestDetails
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\StructType\LinkingProductDetails $linkingDetails = null, \patest\ArrayType\ArrayOfint $originativeItemIds = null, $promptId = null, \patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase $requestDetails = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setLinkingDetails($linkingDetails)
            ->setOriginativeItemIds($originativeItemIds)
            ->setPromptId($promptId)
            ->setRequestDetails($requestDetails)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get LinkingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\LinkingProductDetails|null
     */
    public function getLinkingDetails()
    {
        return isset($this->LinkingDetails) ? $this->LinkingDetails : null;
    }
    /**
     * Set LinkingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\LinkingProductDetails $linkingDetails
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setLinkingDetails(\patest\StructType\LinkingProductDetails $linkingDetails = null)
    {
        if (is_null($linkingDetails) || (is_array($linkingDetails) && empty($linkingDetails))) {
            unset($this->LinkingDetails);
        } else {
            $this->LinkingDetails = $linkingDetails;
        }
        return $this;
    }
    /**
     * Get OriginativeItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getOriginativeItemIds()
    {
        return isset($this->OriginativeItemIds) ? $this->OriginativeItemIds : null;
    }
    /**
     * Set OriginativeItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $originativeItemIds
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setOriginativeItemIds(\patest\ArrayType\ArrayOfint $originativeItemIds = null)
    {
        if (is_null($originativeItemIds) || (is_array($originativeItemIds) && empty($originativeItemIds))) {
            unset($this->OriginativeItemIds);
        } else {
            $this->OriginativeItemIds = $originativeItemIds;
        }
        return $this;
    }
    /**
     * Get PromptId value
     * @return string|null
     */
    public function getPromptId()
    {
        return $this->PromptId;
    }
    /**
     * Set PromptId value
     * @param string $promptId
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setPromptId($promptId = null)
    {
        // validation for constraint: string
        if (!is_null($promptId) && !is_string($promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promptId, true), gettype($promptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promptId, true)), __LINE__);
        }
        $this->PromptId = $promptId;
        return $this;
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase $requestDetails
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setRequestDetails(\patest\ArrayType\ArrayOfSales_ExtraProductElementRequestBase $requestDetails = null)
    {
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddPromptExtraProductsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
