<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddProductsToBasketResponseItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddProductsToBasketResponseItem
 * @subpackage Structs
 */
class AddProductsToBasketResponseItem extends AbstractStructBase
{
    /**
     * The ExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ExtraData;
    /**
     * The FailureInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\FailureInformation
     */
    public $FailureInfo;
    /**
     * The IsSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSucceeded;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for AddProductsToBasketResponseItem
     * @uses AddProductsToBasketResponseItem::setExtraData()
     * @uses AddProductsToBasketResponseItem::setFailureInfo()
     * @uses AddProductsToBasketResponseItem::setIsSucceeded()
     * @uses AddProductsToBasketResponseItem::setItemId()
     * @uses AddProductsToBasketResponseItem::setReferenceId()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @param \patest\StructType\FailureInformation $failureInfo
     * @param bool $isSucceeded
     * @param int $itemId
     * @param string $referenceId
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null, \patest\StructType\FailureInformation $failureInfo = null, $isSucceeded = null, $itemId = null, $referenceId = null)
    {
        $this
            ->setExtraData($extraData)
            ->setFailureInfo($failureInfo)
            ->setIsSucceeded($isSucceeded)
            ->setItemId($itemId)
            ->setReferenceId($referenceId);
    }
    /**
     * Get ExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getExtraData()
    {
        return isset($this->ExtraData) ? $this->ExtraData : null;
    }
    /**
     * Set ExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData
     * @return \patest\StructType\AddProductsToBasketResponseItem
     */
    public function setExtraData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $extraData = null)
    {
        if (is_null($extraData) || (is_array($extraData) && empty($extraData))) {
            unset($this->ExtraData);
        } else {
            $this->ExtraData = $extraData;
        }
        return $this;
    }
    /**
     * Get FailureInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\FailureInformation|null
     */
    public function getFailureInfo()
    {
        return isset($this->FailureInfo) ? $this->FailureInfo : null;
    }
    /**
     * Set FailureInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\FailureInformation $failureInfo
     * @return \patest\StructType\AddProductsToBasketResponseItem
     */
    public function setFailureInfo(\patest\StructType\FailureInformation $failureInfo = null)
    {
        if (is_null($failureInfo) || (is_array($failureInfo) && empty($failureInfo))) {
            unset($this->FailureInfo);
        } else {
            $this->FailureInfo = $failureInfo;
        }
        return $this;
    }
    /**
     * Get IsSucceeded value
     * @return bool|null
     */
    public function getIsSucceeded()
    {
        return $this->IsSucceeded;
    }
    /**
     * Set IsSucceeded value
     * @param bool $isSucceeded
     * @return \patest\StructType\AddProductsToBasketResponseItem
     */
    public function setIsSucceeded($isSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSucceeded) && !is_bool($isSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSucceeded, true), gettype($isSucceeded)), __LINE__);
        }
        $this->IsSucceeded = $isSucceeded;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\AddProductsToBasketResponseItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\AddProductsToBasketResponseItem
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
}
