<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddPaymentToBasket-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddPaymentToBasket-Response
 * @subpackage Structs
 */
class AddPaymentToBasket_Response extends ExtensibleDataContract
{
    /**
     * The InsertedItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsertedItemId;
    /**
     * The InsertionGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InsertionGroup;
    /**
     * The ResumeRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResumeRequired;
    /**
     * The TotalPriceDelta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $TotalPriceDelta;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * The ActuallyPaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ActuallyPaidAmount;
    /**
     * The RequiredUserInteraction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\UserInteractionDetails
     */
    public $RequiredUserInteraction;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCodeDescription
     */
    public $Warnings;
    /**
     * Constructor method for AddPaymentToBasket-Response
     * @uses AddPaymentToBasket_Response::setInsertedItemId()
     * @uses AddPaymentToBasket_Response::setInsertionGroup()
     * @uses AddPaymentToBasket_Response::setResumeRequired()
     * @uses AddPaymentToBasket_Response::setTotalPriceDelta()
     * @uses AddPaymentToBasket_Response::setTransactionSnapshot()
     * @uses AddPaymentToBasket_Response::setActuallyPaidAmount()
     * @uses AddPaymentToBasket_Response::setRequiredUserInteraction()
     * @uses AddPaymentToBasket_Response::setWarnings()
     * @param int $insertedItemId
     * @param int $insertionGroup
     * @param bool $resumeRequired
     * @param \patest\StructType\Money $totalPriceDelta
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @param \patest\StructType\Money $actuallyPaidAmount
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteraction
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     */
    public function __construct($insertedItemId = null, $insertionGroup = null, $resumeRequired = null, \patest\StructType\Money $totalPriceDelta = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null, \patest\StructType\Money $actuallyPaidAmount = null, \patest\StructType\UserInteractionDetails $requiredUserInteraction = null, \patest\ArrayType\ArrayOfCodeDescription $warnings = null)
    {
        $this
            ->setInsertedItemId($insertedItemId)
            ->setInsertionGroup($insertionGroup)
            ->setResumeRequired($resumeRequired)
            ->setTotalPriceDelta($totalPriceDelta)
            ->setTransactionSnapshot($transactionSnapshot)
            ->setActuallyPaidAmount($actuallyPaidAmount)
            ->setRequiredUserInteraction($requiredUserInteraction)
            ->setWarnings($warnings);
    }
    /**
     * Get InsertedItemId value
     * @return int|null
     */
    public function getInsertedItemId()
    {
        return $this->InsertedItemId;
    }
    /**
     * Set InsertedItemId value
     * @param int $insertedItemId
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setInsertedItemId($insertedItemId = null)
    {
        // validation for constraint: int
        if (!is_null($insertedItemId) && !(is_int($insertedItemId) || ctype_digit($insertedItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insertedItemId, true), gettype($insertedItemId)), __LINE__);
        }
        $this->InsertedItemId = $insertedItemId;
        return $this;
    }
    /**
     * Get InsertionGroup value
     * @return int|null
     */
    public function getInsertionGroup()
    {
        return $this->InsertionGroup;
    }
    /**
     * Set InsertionGroup value
     * @param int $insertionGroup
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setInsertionGroup($insertionGroup = null)
    {
        // validation for constraint: int
        if (!is_null($insertionGroup) && !(is_int($insertionGroup) || ctype_digit($insertionGroup))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($insertionGroup, true), gettype($insertionGroup)), __LINE__);
        }
        $this->InsertionGroup = $insertionGroup;
        return $this;
    }
    /**
     * Get ResumeRequired value
     * @return bool|null
     */
    public function getResumeRequired()
    {
        return $this->ResumeRequired;
    }
    /**
     * Set ResumeRequired value
     * @param bool $resumeRequired
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setResumeRequired($resumeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($resumeRequired) && !is_bool($resumeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resumeRequired, true), gettype($resumeRequired)), __LINE__);
        }
        $this->ResumeRequired = $resumeRequired;
        return $this;
    }
    /**
     * Get TotalPriceDelta value
     * @return \patest\StructType\Money|null
     */
    public function getTotalPriceDelta()
    {
        return $this->TotalPriceDelta;
    }
    /**
     * Set TotalPriceDelta value
     * @param \patest\StructType\Money $totalPriceDelta
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setTotalPriceDelta(\patest\StructType\Money $totalPriceDelta = null)
    {
        $this->TotalPriceDelta = $totalPriceDelta;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
    /**
     * Get ActuallyPaidAmount value
     * @return \patest\StructType\Money|null
     */
    public function getActuallyPaidAmount()
    {
        return $this->ActuallyPaidAmount;
    }
    /**
     * Set ActuallyPaidAmount value
     * @param \patest\StructType\Money $actuallyPaidAmount
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setActuallyPaidAmount(\patest\StructType\Money $actuallyPaidAmount = null)
    {
        $this->ActuallyPaidAmount = $actuallyPaidAmount;
        return $this;
    }
    /**
     * Get RequiredUserInteraction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\UserInteractionDetails|null
     */
    public function getRequiredUserInteraction()
    {
        return isset($this->RequiredUserInteraction) ? $this->RequiredUserInteraction : null;
    }
    /**
     * Set RequiredUserInteraction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\UserInteractionDetails $requiredUserInteraction
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setRequiredUserInteraction(\patest\StructType\UserInteractionDetails $requiredUserInteraction = null)
    {
        if (is_null($requiredUserInteraction) || (is_array($requiredUserInteraction) && empty($requiredUserInteraction))) {
            unset($this->RequiredUserInteraction);
        } else {
            $this->RequiredUserInteraction = $requiredUserInteraction;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCodeDescription|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     * @return \patest\StructType\AddPaymentToBasket_Response
     */
    public function setWarnings(\patest\ArrayType\ArrayOfCodeDescription $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
