<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMultipleUnpayItemsToBasketRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddMultipleUnpayItemsToBasketRequest
 * @subpackage Structs
 */
class AddMultipleUnpayItemsToBasketRequest extends AbstractStructBase
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest
     */
    public $Items;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddMultipleUnpayItemsToBasketRequest
     * @uses AddMultipleUnpayItemsToBasketRequest::setItems()
     * @uses AddMultipleUnpayItemsToBasketRequest::setTransactionSnapshotType()
     * @param \patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest $items
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest $items = null, $transactionSnapshotType = null)
    {
        $this
            ->setItems($items)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest $items
     * @return \patest\StructType\AddMultipleUnpayItemsToBasketRequest
     */
    public function setItems(\patest\ArrayType\ArrayOfAddUnpayItemToBasketRequest $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddMultipleUnpayItemsToBasketRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
