<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMultiEventTicketsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddMultiEventTicketsToBasket-Request
 * @subpackage Structs
 */
class AddMultiEventTicketsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The IsConvertPricingErrorsIntoIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertPricingErrorsIntoIncomplete;
    /**
     * The IsReplaceExistingTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReplaceExistingTickets;
    /**
     * The IsSilentErrorMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSilentErrorMode;
    /**
     * The SeatsToCatchPerEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCatchSeatsPerEventRequest
     */
    public $SeatsToCatchPerEvent;
    /**
     * The TicketItemIdsToDiscard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $TicketItemIdsToDiscard;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddMultiEventTicketsToBasket-Request
     * @uses AddMultiEventTicketsToBasket_Request::setIsConvertPricingErrorsIntoIncomplete()
     * @uses AddMultiEventTicketsToBasket_Request::setIsReplaceExistingTickets()
     * @uses AddMultiEventTicketsToBasket_Request::setIsSilentErrorMode()
     * @uses AddMultiEventTicketsToBasket_Request::setSeatsToCatchPerEvent()
     * @uses AddMultiEventTicketsToBasket_Request::setTicketItemIdsToDiscard()
     * @uses AddMultiEventTicketsToBasket_Request::setTransactionGuid()
     * @uses AddMultiEventTicketsToBasket_Request::setTransactionSnapshotType()
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @param bool $isReplaceExistingTickets
     * @param bool $isSilentErrorMode
     * @param \patest\ArrayType\ArrayOfCatchSeatsPerEventRequest $seatsToCatchPerEvent
     * @param \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($isConvertPricingErrorsIntoIncomplete = null, $isReplaceExistingTickets = null, $isSilentErrorMode = null, \patest\ArrayType\ArrayOfCatchSeatsPerEventRequest $seatsToCatchPerEvent = null, \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete)
            ->setIsReplaceExistingTickets($isReplaceExistingTickets)
            ->setIsSilentErrorMode($isSilentErrorMode)
            ->setSeatsToCatchPerEvent($seatsToCatchPerEvent)
            ->setTicketItemIdsToDiscard($ticketItemIdsToDiscard)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get IsConvertPricingErrorsIntoIncomplete value
     * @return bool|null
     */
    public function getIsConvertPricingErrorsIntoIncomplete()
    {
        return $this->IsConvertPricingErrorsIntoIncomplete;
    }
    /**
     * Set IsConvertPricingErrorsIntoIncomplete value
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertPricingErrorsIntoIncomplete) && !is_bool($isConvertPricingErrorsIntoIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertPricingErrorsIntoIncomplete, true), gettype($isConvertPricingErrorsIntoIncomplete)), __LINE__);
        }
        $this->IsConvertPricingErrorsIntoIncomplete = $isConvertPricingErrorsIntoIncomplete;
        return $this;
    }
    /**
     * Get IsReplaceExistingTickets value
     * @return bool|null
     */
    public function getIsReplaceExistingTickets()
    {
        return $this->IsReplaceExistingTickets;
    }
    /**
     * Set IsReplaceExistingTickets value
     * @param bool $isReplaceExistingTickets
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setIsReplaceExistingTickets($isReplaceExistingTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceExistingTickets) && !is_bool($isReplaceExistingTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceExistingTickets, true), gettype($isReplaceExistingTickets)), __LINE__);
        }
        $this->IsReplaceExistingTickets = $isReplaceExistingTickets;
        return $this;
    }
    /**
     * Get IsSilentErrorMode value
     * @return bool|null
     */
    public function getIsSilentErrorMode()
    {
        return $this->IsSilentErrorMode;
    }
    /**
     * Set IsSilentErrorMode value
     * @param bool $isSilentErrorMode
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setIsSilentErrorMode($isSilentErrorMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSilentErrorMode) && !is_bool($isSilentErrorMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSilentErrorMode, true), gettype($isSilentErrorMode)), __LINE__);
        }
        $this->IsSilentErrorMode = $isSilentErrorMode;
        return $this;
    }
    /**
     * Get SeatsToCatchPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCatchSeatsPerEventRequest|null
     */
    public function getSeatsToCatchPerEvent()
    {
        return isset($this->SeatsToCatchPerEvent) ? $this->SeatsToCatchPerEvent : null;
    }
    /**
     * Set SeatsToCatchPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCatchSeatsPerEventRequest $seatsToCatchPerEvent
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setSeatsToCatchPerEvent(\patest\ArrayType\ArrayOfCatchSeatsPerEventRequest $seatsToCatchPerEvent = null)
    {
        if (is_null($seatsToCatchPerEvent) || (is_array($seatsToCatchPerEvent) && empty($seatsToCatchPerEvent))) {
            unset($this->SeatsToCatchPerEvent);
        } else {
            $this->SeatsToCatchPerEvent = $seatsToCatchPerEvent;
        }
        return $this;
    }
    /**
     * Get TicketItemIdsToDiscard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getTicketItemIdsToDiscard()
    {
        return isset($this->TicketItemIdsToDiscard) ? $this->TicketItemIdsToDiscard : null;
    }
    /**
     * Set TicketItemIdsToDiscard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setTicketItemIdsToDiscard(\patest\ArrayType\ArrayOfint $ticketItemIdsToDiscard = null)
    {
        if (is_null($ticketItemIdsToDiscard) || (is_array($ticketItemIdsToDiscard) && empty($ticketItemIdsToDiscard))) {
            unset($this->TicketItemIdsToDiscard);
        } else {
            $this->TicketItemIdsToDiscard = $ticketItemIdsToDiscard;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddMultiEventTicketsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
