<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMerchandiseToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddMerchandiseToBasket-Request
 * @subpackage Structs
 */
class AddMerchandiseToBasket_Request extends ExtensibleDataContract
{
    /**
     * The DeliveredByItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveredByItemId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MerchandiseItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfMerchandiseItemsDescription
     */
    public $MerchandiseItems;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddMerchandiseToBasket-Request
     * @uses AddMerchandiseToBasket_Request::setDeliveredByItemId()
     * @uses AddMerchandiseToBasket_Request::setMerchandiseId()
     * @uses AddMerchandiseToBasket_Request::setMerchandiseItems()
     * @uses AddMerchandiseToBasket_Request::setQuantity()
     * @uses AddMerchandiseToBasket_Request::setTransactionGuid()
     * @uses AddMerchandiseToBasket_Request::setTransactionSnapshotType()
     * @param int $deliveredByItemId
     * @param string $merchandiseId
     * @param \patest\ArrayType\ArrayOfMerchandiseItemsDescription $merchandiseItems
     * @param int $quantity
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($deliveredByItemId = null, $merchandiseId = null, \patest\ArrayType\ArrayOfMerchandiseItemsDescription $merchandiseItems = null, $quantity = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setDeliveredByItemId($deliveredByItemId)
            ->setMerchandiseId($merchandiseId)
            ->setMerchandiseItems($merchandiseItems)
            ->setQuantity($quantity)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get DeliveredByItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveredByItemId()
    {
        return isset($this->DeliveredByItemId) ? $this->DeliveredByItemId : null;
    }
    /**
     * Set DeliveredByItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveredByItemId
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setDeliveredByItemId($deliveredByItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredByItemId) && !(is_int($deliveredByItemId) || ctype_digit($deliveredByItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredByItemId, true), gettype($deliveredByItemId)), __LINE__);
        }
        if (is_null($deliveredByItemId) || (is_array($deliveredByItemId) && empty($deliveredByItemId))) {
            unset($this->DeliveredByItemId);
        } else {
            $this->DeliveredByItemId = $deliveredByItemId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return $this->MerchandiseId;
    }
    /**
     * Set MerchandiseId value
     * @param string $merchandiseId
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        $this->MerchandiseId = $merchandiseId;
        return $this;
    }
    /**
     * Get MerchandiseItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfMerchandiseItemsDescription|null
     */
    public function getMerchandiseItems()
    {
        return isset($this->MerchandiseItems) ? $this->MerchandiseItems : null;
    }
    /**
     * Set MerchandiseItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfMerchandiseItemsDescription $merchandiseItems
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setMerchandiseItems(\patest\ArrayType\ArrayOfMerchandiseItemsDescription $merchandiseItems = null)
    {
        if (is_null($merchandiseItems) || (is_array($merchandiseItems) && empty($merchandiseItems))) {
            unset($this->MerchandiseItems);
        } else {
            $this->MerchandiseItems = $merchandiseItems;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddMerchandiseToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
