<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddMembershipsToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddMembershipsToBasket-Request
 * @subpackage Structs
 */
class AddMembershipsToBasket_Request extends ExtensibleDataContract
{
    /**
     * The DeliveredByItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveredByItemId;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceType;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * The RenewedMembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedMembershipId;
    /**
     * The RenewedMembershipInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewedMembershipInstanceId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The ForceNewSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForceNewSale;
    /**
     * The IsAutoRenewRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoRenewRequested;
    /**
     * The SkipAutoRenewValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipAutoRenewValidation;
    /**
     * Constructor method for AddMembershipsToBasket-Request
     * @uses AddMembershipsToBasket_Request::setDeliveredByItemId()
     * @uses AddMembershipsToBasket_Request::setMembershipDefinitionId()
     * @uses AddMembershipsToBasket_Request::setPriceType()
     * @uses AddMembershipsToBasket_Request::setQuantity()
     * @uses AddMembershipsToBasket_Request::setRenewedMembershipId()
     * @uses AddMembershipsToBasket_Request::setRenewedMembershipInstanceId()
     * @uses AddMembershipsToBasket_Request::setTransactionGuid()
     * @uses AddMembershipsToBasket_Request::setTransactionSnapshotType()
     * @uses AddMembershipsToBasket_Request::setForceNewSale()
     * @uses AddMembershipsToBasket_Request::setIsAutoRenewRequested()
     * @uses AddMembershipsToBasket_Request::setSkipAutoRenewValidation()
     * @param int $deliveredByItemId
     * @param string $membershipDefinitionId
     * @param string $priceType
     * @param int $quantity
     * @param string $renewedMembershipId
     * @param string $renewedMembershipInstanceId
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $forceNewSale
     * @param bool $isAutoRenewRequested
     * @param bool $skipAutoRenewValidation
     */
    public function __construct($deliveredByItemId = null, $membershipDefinitionId = null, $priceType = null, $quantity = null, $renewedMembershipId = null, $renewedMembershipInstanceId = null, $transactionGuid = null, $transactionSnapshotType = null, $forceNewSale = null, $isAutoRenewRequested = null, $skipAutoRenewValidation = null)
    {
        $this
            ->setDeliveredByItemId($deliveredByItemId)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setPriceType($priceType)
            ->setQuantity($quantity)
            ->setRenewedMembershipId($renewedMembershipId)
            ->setRenewedMembershipInstanceId($renewedMembershipInstanceId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setForceNewSale($forceNewSale)
            ->setIsAutoRenewRequested($isAutoRenewRequested)
            ->setSkipAutoRenewValidation($skipAutoRenewValidation);
    }
    /**
     * Get DeliveredByItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveredByItemId()
    {
        return isset($this->DeliveredByItemId) ? $this->DeliveredByItemId : null;
    }
    /**
     * Set DeliveredByItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveredByItemId
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setDeliveredByItemId($deliveredByItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveredByItemId) && !(is_int($deliveredByItemId) || ctype_digit($deliveredByItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveredByItemId, true), gettype($deliveredByItemId)), __LINE__);
        }
        if (is_null($deliveredByItemId) || (is_array($deliveredByItemId) && empty($deliveredByItemId))) {
            unset($this->DeliveredByItemId);
        } else {
            $this->DeliveredByItemId = $deliveredByItemId;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get PriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceType()
    {
        return isset($this->PriceType) ? $this->PriceType : null;
    }
    /**
     * Set PriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceType
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceType, true)), __LINE__);
        }
        if (is_null($priceType) || (is_array($priceType) && empty($priceType))) {
            unset($this->PriceType);
        } else {
            $this->PriceType = $priceType;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RenewedMembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedMembershipId()
    {
        return isset($this->RenewedMembershipId) ? $this->RenewedMembershipId : null;
    }
    /**
     * Set RenewedMembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedMembershipId
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setRenewedMembershipId($renewedMembershipId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedMembershipId) && !is_string($renewedMembershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedMembershipId, true), gettype($renewedMembershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedMembershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedMembershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedMembershipId, true)), __LINE__);
        }
        if (is_null($renewedMembershipId) || (is_array($renewedMembershipId) && empty($renewedMembershipId))) {
            unset($this->RenewedMembershipId);
        } else {
            $this->RenewedMembershipId = $renewedMembershipId;
        }
        return $this;
    }
    /**
     * Get RenewedMembershipInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewedMembershipInstanceId()
    {
        return isset($this->RenewedMembershipInstanceId) ? $this->RenewedMembershipInstanceId : null;
    }
    /**
     * Set RenewedMembershipInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewedMembershipInstanceId
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setRenewedMembershipInstanceId($renewedMembershipInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewedMembershipInstanceId) && !is_string($renewedMembershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewedMembershipInstanceId, true), gettype($renewedMembershipInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewedMembershipInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewedMembershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewedMembershipInstanceId, true)), __LINE__);
        }
        if (is_null($renewedMembershipInstanceId) || (is_array($renewedMembershipInstanceId) && empty($renewedMembershipInstanceId))) {
            unset($this->RenewedMembershipInstanceId);
        } else {
            $this->RenewedMembershipInstanceId = $renewedMembershipInstanceId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get ForceNewSale value
     * @return bool|null
     */
    public function getForceNewSale()
    {
        return $this->ForceNewSale;
    }
    /**
     * Set ForceNewSale value
     * @param bool $forceNewSale
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setForceNewSale($forceNewSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceNewSale) && !is_bool($forceNewSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceNewSale, true), gettype($forceNewSale)), __LINE__);
        }
        $this->ForceNewSale = $forceNewSale;
        return $this;
    }
    /**
     * Get IsAutoRenewRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoRenewRequested()
    {
        return isset($this->IsAutoRenewRequested) ? $this->IsAutoRenewRequested : null;
    }
    /**
     * Set IsAutoRenewRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoRenewRequested
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setIsAutoRenewRequested($isAutoRenewRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoRenewRequested) && !is_bool($isAutoRenewRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoRenewRequested, true), gettype($isAutoRenewRequested)), __LINE__);
        }
        if (is_null($isAutoRenewRequested) || (is_array($isAutoRenewRequested) && empty($isAutoRenewRequested))) {
            unset($this->IsAutoRenewRequested);
        } else {
            $this->IsAutoRenewRequested = $isAutoRenewRequested;
        }
        return $this;
    }
    /**
     * Get SkipAutoRenewValidation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipAutoRenewValidation()
    {
        return isset($this->SkipAutoRenewValidation) ? $this->SkipAutoRenewValidation : null;
    }
    /**
     * Set SkipAutoRenewValidation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipAutoRenewValidation
     * @return \patest\StructType\AddMembershipsToBasket_Request
     */
    public function setSkipAutoRenewValidation($skipAutoRenewValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipAutoRenewValidation) && !is_bool($skipAutoRenewValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipAutoRenewValidation, true), gettype($skipAutoRenewValidation)), __LINE__);
        }
        if (is_null($skipAutoRenewValidation) || (is_array($skipAutoRenewValidation) && empty($skipAutoRenewValidation))) {
            unset($this->SkipAutoRenewValidation);
        } else {
            $this->SkipAutoRenewValidation = $skipAutoRenewValidation;
        }
        return $this;
    }
}
