<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddEntityManagementQueryTokenContextRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddEntityManagementQueryTokenContextRequest
 * @subpackage Structs
 */
class AddEntityManagementQueryTokenContextRequest extends AbstractStructBase
{
    /**
     * The QueryToken
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryToken;
    /**
     * The QueryTokenContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryTokenContext
     */
    public $QueryTokenContext;
    /**
     * Constructor method for AddEntityManagementQueryTokenContextRequest
     * @uses AddEntityManagementQueryTokenContextRequest::setQueryToken()
     * @uses AddEntityManagementQueryTokenContextRequest::setQueryTokenContext()
     * @param string $queryToken
     * @param \patest\StructType\QueryTokenContext $queryTokenContext
     */
    public function __construct($queryToken = null, \patest\StructType\QueryTokenContext $queryTokenContext = null)
    {
        $this
            ->setQueryToken($queryToken)
            ->setQueryTokenContext($queryTokenContext);
    }
    /**
     * Get QueryToken value
     * @return string|null
     */
    public function getQueryToken()
    {
        return $this->QueryToken;
    }
    /**
     * Set QueryToken value
     * @param string $queryToken
     * @return \patest\StructType\AddEntityManagementQueryTokenContextRequest
     */
    public function setQueryToken($queryToken = null)
    {
        // validation for constraint: string
        if (!is_null($queryToken) && !is_string($queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryToken, true), gettype($queryToken)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryToken) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryToken, true)), __LINE__);
        }
        $this->QueryToken = $queryToken;
        return $this;
    }
    /**
     * Get QueryTokenContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryTokenContext|null
     */
    public function getQueryTokenContext()
    {
        return isset($this->QueryTokenContext) ? $this->QueryTokenContext : null;
    }
    /**
     * Set QueryTokenContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryTokenContext $queryTokenContext
     * @return \patest\StructType\AddEntityManagementQueryTokenContextRequest
     */
    public function setQueryTokenContext(\patest\StructType\QueryTokenContext $queryTokenContext = null)
    {
        if (is_null($queryTokenContext) || (is_array($queryTokenContext) && empty($queryTokenContext))) {
            unset($this->QueryTokenContext);
        } else {
            $this->QueryTokenContext = $queryTokenContext;
        }
        return $this;
    }
}
