<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddCancellationPaymentToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddCancellationPaymentToBasket-Request
 * @subpackage Structs
 */
class AddCancellationPaymentToBasket_Request extends ExtensibleDataContract
{
    /**
     * The DestinationAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DestinationAmount;
    /**
     * The DestinationTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DestinationTransactionGuid;
    /**
     * The DestinationTransactionRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DestinationTransactionRefNumber;
    /**
     * The DestinationTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTransactionSnapshotType;
    /**
     * The SourcePaymentItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourcePaymentItemId;
    /**
     * Constructor method for AddCancellationPaymentToBasket-Request
     * @uses AddCancellationPaymentToBasket_Request::setDestinationAmount()
     * @uses AddCancellationPaymentToBasket_Request::setDestinationTransactionGuid()
     * @uses AddCancellationPaymentToBasket_Request::setDestinationTransactionRefNumber()
     * @uses AddCancellationPaymentToBasket_Request::setDestinationTransactionSnapshotType()
     * @uses AddCancellationPaymentToBasket_Request::setSourcePaymentItemId()
     * @param \patest\StructType\Money $destinationAmount
     * @param string $destinationTransactionGuid
     * @param int $destinationTransactionRefNumber
     * @param string $destinationTransactionSnapshotType
     * @param string $sourcePaymentItemId
     */
    public function __construct(\patest\StructType\Money $destinationAmount = null, $destinationTransactionGuid = null, $destinationTransactionRefNumber = null, $destinationTransactionSnapshotType = null, $sourcePaymentItemId = null)
    {
        $this
            ->setDestinationAmount($destinationAmount)
            ->setDestinationTransactionGuid($destinationTransactionGuid)
            ->setDestinationTransactionRefNumber($destinationTransactionRefNumber)
            ->setDestinationTransactionSnapshotType($destinationTransactionSnapshotType)
            ->setSourcePaymentItemId($sourcePaymentItemId);
    }
    /**
     * Get DestinationAmount value
     * @return \patest\StructType\Money|null
     */
    public function getDestinationAmount()
    {
        return $this->DestinationAmount;
    }
    /**
     * Set DestinationAmount value
     * @param \patest\StructType\Money $destinationAmount
     * @return \patest\StructType\AddCancellationPaymentToBasket_Request
     */
    public function setDestinationAmount(\patest\StructType\Money $destinationAmount = null)
    {
        $this->DestinationAmount = $destinationAmount;
        return $this;
    }
    /**
     * Get DestinationTransactionGuid value
     * @return string|null
     */
    public function getDestinationTransactionGuid()
    {
        return $this->DestinationTransactionGuid;
    }
    /**
     * Set DestinationTransactionGuid value
     * @param string $destinationTransactionGuid
     * @return \patest\StructType\AddCancellationPaymentToBasket_Request
     */
    public function setDestinationTransactionGuid($destinationTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($destinationTransactionGuid) && !is_string($destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationTransactionGuid, true), gettype($destinationTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($destinationTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $destinationTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($destinationTransactionGuid, true)), __LINE__);
        }
        $this->DestinationTransactionGuid = $destinationTransactionGuid;
        return $this;
    }
    /**
     * Get DestinationTransactionRefNumber value
     * @return int|null
     */
    public function getDestinationTransactionRefNumber()
    {
        return $this->DestinationTransactionRefNumber;
    }
    /**
     * Set DestinationTransactionRefNumber value
     * @param int $destinationTransactionRefNumber
     * @return \patest\StructType\AddCancellationPaymentToBasket_Request
     */
    public function setDestinationTransactionRefNumber($destinationTransactionRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($destinationTransactionRefNumber) && !(is_int($destinationTransactionRefNumber) || ctype_digit($destinationTransactionRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationTransactionRefNumber, true), gettype($destinationTransactionRefNumber)), __LINE__);
        }
        $this->DestinationTransactionRefNumber = $destinationTransactionRefNumber;
        return $this;
    }
    /**
     * Get DestinationTransactionSnapshotType value
     * @return string|null
     */
    public function getDestinationTransactionSnapshotType()
    {
        return $this->DestinationTransactionSnapshotType;
    }
    /**
     * Set DestinationTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationTransactionSnapshotType
     * @return \patest\StructType\AddCancellationPaymentToBasket_Request
     */
    public function setDestinationTransactionSnapshotType($destinationTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($destinationTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($destinationTransactionSnapshotType) ? implode(', ', $destinationTransactionSnapshotType) : var_export($destinationTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->DestinationTransactionSnapshotType = $destinationTransactionSnapshotType;
        return $this;
    }
    /**
     * Get SourcePaymentItemId value
     * @return string|null
     */
    public function getSourcePaymentItemId()
    {
        return $this->SourcePaymentItemId;
    }
    /**
     * Set SourcePaymentItemId value
     * @param string $sourcePaymentItemId
     * @return \patest\StructType\AddCancellationPaymentToBasket_Request
     */
    public function setSourcePaymentItemId($sourcePaymentItemId = null)
    {
        // validation for constraint: string
        if (!is_null($sourcePaymentItemId) && !is_string($sourcePaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourcePaymentItemId, true), gettype($sourcePaymentItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourcePaymentItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourcePaymentItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourcePaymentItemId, true)), __LINE__);
        }
        $this->SourcePaymentItemId = $sourcePaymentItemId;
        return $this;
    }
}
