<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBundleToBasket-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddBundleToBasket-Response
 * @subpackage Structs
 */
class AddBundleToBasket_Response extends ExtensibleDataContract
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem
     */
    public $Items;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * The UserInteractionRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UserInteractionRequired;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfFailureInformation
     */
    public $Warnings;
    /**
     * Constructor method for AddBundleToBasket-Response
     * @uses AddBundleToBasket_Response::setItems()
     * @uses AddBundleToBasket_Response::setTransactionSnapshot()
     * @uses AddBundleToBasket_Response::setUserInteractionRequired()
     * @uses AddBundleToBasket_Response::setWarnings()
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @param bool $userInteractionRequired
     * @param \patest\ArrayType\ArrayOfFailureInformation $warnings
     */
    public function __construct(\patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null, $userInteractionRequired = null, \patest\ArrayType\ArrayOfFailureInformation $warnings = null)
    {
        $this
            ->setItems($items)
            ->setTransactionSnapshot($transactionSnapshot)
            ->setUserInteractionRequired($userInteractionRequired)
            ->setWarnings($warnings);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items
     * @return \patest\StructType\AddBundleToBasket_Response
     */
    public function setItems(\patest\ArrayType\ArrayOfAddProductsToBasketResponseItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\AddBundleToBasket_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
    /**
     * Get UserInteractionRequired value
     * @return bool|null
     */
    public function getUserInteractionRequired()
    {
        return $this->UserInteractionRequired;
    }
    /**
     * Set UserInteractionRequired value
     * @param bool $userInteractionRequired
     * @return \patest\StructType\AddBundleToBasket_Response
     */
    public function setUserInteractionRequired($userInteractionRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($userInteractionRequired) && !is_bool($userInteractionRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userInteractionRequired, true), gettype($userInteractionRequired)), __LINE__);
        }
        $this->UserInteractionRequired = $userInteractionRequired;
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfFailureInformation|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfFailureInformation $warnings
     * @return \patest\StructType\AddBundleToBasket_Response
     */
    public function setWarnings(\patest\ArrayType\ArrayOfFailureInformation $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
