<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBundleToBasket-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddBundleToBasket-Request
 * @subpackage Structs
 */
class AddBundleToBasket_Request extends ExtensibleDataContract
{
    /**
     * The AddSilently
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AddSilently;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The QuantityPerPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidint
     */
    public $QuantityPerPriceType;
    /**
     * The RequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSales_BundleElementRequestBase
     */
    public $RequestDetails;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for AddBundleToBasket-Request
     * @uses AddBundleToBasket_Request::setAddSilently()
     * @uses AddBundleToBasket_Request::setBundleId()
     * @uses AddBundleToBasket_Request::setQuantity()
     * @uses AddBundleToBasket_Request::setQuantityPerPriceType()
     * @uses AddBundleToBasket_Request::setRequestDetails()
     * @uses AddBundleToBasket_Request::setTransactionGuid()
     * @uses AddBundleToBasket_Request::setTransactionSnapshotType()
     * @param bool $addSilently
     * @param string $bundleId
     * @param int $quantity
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType
     * @param \patest\ArrayType\ArrayOfSales_BundleElementRequestBase $requestDetails
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     */
    public function __construct($addSilently = null, $bundleId = null, $quantity = null, \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType = null, \patest\ArrayType\ArrayOfSales_BundleElementRequestBase $requestDetails = null, $transactionGuid = null, $transactionSnapshotType = null)
    {
        $this
            ->setAddSilently($addSilently)
            ->setBundleId($bundleId)
            ->setQuantity($quantity)
            ->setQuantityPerPriceType($quantityPerPriceType)
            ->setRequestDetails($requestDetails)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get AddSilently value
     * @return bool|null
     */
    public function getAddSilently()
    {
        return $this->AddSilently;
    }
    /**
     * Set AddSilently value
     * @param bool $addSilently
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setAddSilently($addSilently = null)
    {
        // validation for constraint: boolean
        if (!is_null($addSilently) && !is_bool($addSilently)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addSilently, true), gettype($addSilently)), __LINE__);
        }
        $this->AddSilently = $addSilently;
        return $this;
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityPerPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidint|null
     */
    public function getQuantityPerPriceType()
    {
        return isset($this->QuantityPerPriceType) ? $this->QuantityPerPriceType : null;
    }
    /**
     * Set QuantityPerPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setQuantityPerPriceType(\patest\ArrayType\ArrayOfKeyValueOfguidint $quantityPerPriceType = null)
    {
        if (is_null($quantityPerPriceType) || (is_array($quantityPerPriceType) && empty($quantityPerPriceType))) {
            unset($this->QuantityPerPriceType);
        } else {
            $this->QuantityPerPriceType = $quantityPerPriceType;
        }
        return $this;
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSales_BundleElementRequestBase|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSales_BundleElementRequestBase $requestDetails
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setRequestDetails(\patest\ArrayType\ArrayOfSales_BundleElementRequestBase $requestDetails = null)
    {
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\AddBundleToBasket_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
