<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdHocRefundItemDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdHocRefundItemDescription
 * @subpackage Structs
 */
class AdHocRefundItemDescription extends AbstractStructBase
{
    /**
     * The AdHocRefundDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdHocRefundDescription;
    /**
     * The AdHocRefundReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdHocRefundReasonId;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The RelatedTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedTransactionGuid;
    /**
     * The RelatedTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RelatedTransactionNumber;
    /**
     * Constructor method for AdHocRefundItemDescription
     * @uses AdHocRefundItemDescription::setAdHocRefundDescription()
     * @uses AdHocRefundItemDescription::setAdHocRefundReasonId()
     * @uses AdHocRefundItemDescription::setAmount()
     * @uses AdHocRefundItemDescription::setClientId()
     * @uses AdHocRefundItemDescription::setRelatedTransactionGuid()
     * @uses AdHocRefundItemDescription::setRelatedTransactionNumber()
     * @param string $adHocRefundDescription
     * @param string $adHocRefundReasonId
     * @param \patest\StructType\Money $amount
     * @param string $clientId
     * @param string $relatedTransactionGuid
     * @param int $relatedTransactionNumber
     */
    public function __construct($adHocRefundDescription = null, $adHocRefundReasonId = null, \patest\StructType\Money $amount = null, $clientId = null, $relatedTransactionGuid = null, $relatedTransactionNumber = null)
    {
        $this
            ->setAdHocRefundDescription($adHocRefundDescription)
            ->setAdHocRefundReasonId($adHocRefundReasonId)
            ->setAmount($amount)
            ->setClientId($clientId)
            ->setRelatedTransactionGuid($relatedTransactionGuid)
            ->setRelatedTransactionNumber($relatedTransactionNumber);
    }
    /**
     * Get AdHocRefundDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdHocRefundDescription()
    {
        return isset($this->AdHocRefundDescription) ? $this->AdHocRefundDescription : null;
    }
    /**
     * Set AdHocRefundDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adHocRefundDescription
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setAdHocRefundDescription($adHocRefundDescription = null)
    {
        // validation for constraint: string
        if (!is_null($adHocRefundDescription) && !is_string($adHocRefundDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adHocRefundDescription, true), gettype($adHocRefundDescription)), __LINE__);
        }
        if (is_null($adHocRefundDescription) || (is_array($adHocRefundDescription) && empty($adHocRefundDescription))) {
            unset($this->AdHocRefundDescription);
        } else {
            $this->AdHocRefundDescription = $adHocRefundDescription;
        }
        return $this;
    }
    /**
     * Get AdHocRefundReasonId value
     * @return string|null
     */
    public function getAdHocRefundReasonId()
    {
        return $this->AdHocRefundReasonId;
    }
    /**
     * Set AdHocRefundReasonId value
     * @param string $adHocRefundReasonId
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setAdHocRefundReasonId($adHocRefundReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($adHocRefundReasonId) && !is_string($adHocRefundReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adHocRefundReasonId, true), gettype($adHocRefundReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($adHocRefundReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $adHocRefundReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($adHocRefundReasonId, true)), __LINE__);
        }
        $this->AdHocRefundReasonId = $adHocRefundReasonId;
        return $this;
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedTransactionGuid()
    {
        return isset($this->RelatedTransactionGuid) ? $this->RelatedTransactionGuid : null;
    }
    /**
     * Set RelatedTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedTransactionGuid
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setRelatedTransactionGuid($relatedTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($relatedTransactionGuid) && !is_string($relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedTransactionGuid, true), gettype($relatedTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedTransactionGuid, true)), __LINE__);
        }
        if (is_null($relatedTransactionGuid) || (is_array($relatedTransactionGuid) && empty($relatedTransactionGuid))) {
            unset($this->RelatedTransactionGuid);
        } else {
            $this->RelatedTransactionGuid = $relatedTransactionGuid;
        }
        return $this;
    }
    /**
     * Get RelatedTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatedTransactionNumber()
    {
        return isset($this->RelatedTransactionNumber) ? $this->RelatedTransactionNumber : null;
    }
    /**
     * Set RelatedTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatedTransactionNumber
     * @return \patest\StructType\AdHocRefundItemDescription
     */
    public function setRelatedTransactionNumber($relatedTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($relatedTransactionNumber) && !(is_int($relatedTransactionNumber) || ctype_digit($relatedTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatedTransactionNumber, true), gettype($relatedTransactionNumber)), __LINE__);
        }
        if (is_null($relatedTransactionNumber) || (is_array($relatedTransactionNumber) && empty($relatedTransactionNumber))) {
            unset($this->RelatedTransactionNumber);
        } else {
            $this->RelatedTransactionNumber = $relatedTransactionNumber;
        }
        return $this;
    }
}
