<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SoldMembershipInfo StructType
 * @subpackage Structs
 */
class AccessControl_SoldMembershipInfo extends AccessControl_SoldItemInfo
{
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJoint;
    /**
     * The JointMembers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_JointMembershipMember
     */
    public $JointMembers;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * Constructor method for AccessControl.SoldMembershipInfo
     * @uses AccessControl_SoldMembershipInfo::setIsJoint()
     * @uses AccessControl_SoldMembershipInfo::setJointMembers()
     * @uses AccessControl_SoldMembershipInfo::setRenewOfInstanceId()
     * @param bool $isJoint
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers
     * @param string $renewOfInstanceId
     */
    public function __construct($isJoint = null, \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers = null, $renewOfInstanceId = null)
    {
        $this
            ->setIsJoint($isJoint)
            ->setJointMembers($jointMembers)
            ->setRenewOfInstanceId($renewOfInstanceId);
    }
    /**
     * Get IsJoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJoint()
    {
        return isset($this->IsJoint) ? $this->IsJoint : null;
    }
    /**
     * Set IsJoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJoint
     * @return \patest\StructType\AccessControl_SoldMembershipInfo
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        if (is_null($isJoint) || (is_array($isJoint) && empty($isJoint))) {
            unset($this->IsJoint);
        } else {
            $this->IsJoint = $isJoint;
        }
        return $this;
    }
    /**
     * Get JointMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_JointMembershipMember|null
     */
    public function getJointMembers()
    {
        return isset($this->JointMembers) ? $this->JointMembers : null;
    }
    /**
     * Set JointMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers
     * @return \patest\StructType\AccessControl_SoldMembershipInfo
     */
    public function setJointMembers(\patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers = null)
    {
        if (is_null($jointMembers) || (is_array($jointMembers) && empty($jointMembers))) {
            unset($this->JointMembers);
        } else {
            $this->JointMembers = $jointMembers;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\AccessControl_SoldMembershipInfo
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
}
