<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ShowtimeBulkOperation StructType
 * @subpackage Structs
 */
class AccessControl_ShowtimeBulkOperation extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ItemsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemsCount;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OperationRunDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationRunDate;
    /**
     * The OperationType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeBulkOperationType
     * @var string
     */
    public $OperationType;
    /**
     * The ReportFileDownloadUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportFileDownloadUrl;
    /**
     * The SelectCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectCriteria;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ShowtimeBulkOperationStatus
     * @var string
     */
    public $Status;
    /**
     * The UploadedFileLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UploadedFileLocation;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for AccessControl.ShowtimeBulkOperation
     * @uses AccessControl_ShowtimeBulkOperation::setAccessControlSystemId()
     * @uses AccessControl_ShowtimeBulkOperation::setAuditId()
     * @uses AccessControl_ShowtimeBulkOperation::setCreationDate()
     * @uses AccessControl_ShowtimeBulkOperation::setEventId()
     * @uses AccessControl_ShowtimeBulkOperation::setItemsCount()
     * @uses AccessControl_ShowtimeBulkOperation::setNotes()
     * @uses AccessControl_ShowtimeBulkOperation::setOperationRunDate()
     * @uses AccessControl_ShowtimeBulkOperation::setOperationType()
     * @uses AccessControl_ShowtimeBulkOperation::setReportFileDownloadUrl()
     * @uses AccessControl_ShowtimeBulkOperation::setSelectCriteria()
     * @uses AccessControl_ShowtimeBulkOperation::setStatus()
     * @uses AccessControl_ShowtimeBulkOperation::setUploadedFileLocation()
     * @uses AccessControl_ShowtimeBulkOperation::setUserId()
     * @param string $accessControlSystemId
     * @param int $auditId
     * @param string $creationDate
     * @param string $eventId
     * @param int $itemsCount
     * @param string $notes
     * @param string $operationRunDate
     * @param string $operationType
     * @param string $reportFileDownloadUrl
     * @param string $selectCriteria
     * @param string $status
     * @param string $uploadedFileLocation
     * @param string $userId
     */
    public function __construct($accessControlSystemId = null, $auditId = null, $creationDate = null, $eventId = null, $itemsCount = null, $notes = null, $operationRunDate = null, $operationType = null, $reportFileDownloadUrl = null, $selectCriteria = null, $status = null, $uploadedFileLocation = null, $userId = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAuditId($auditId)
            ->setCreationDate($creationDate)
            ->setEventId($eventId)
            ->setItemsCount($itemsCount)
            ->setNotes($notes)
            ->setOperationRunDate($operationRunDate)
            ->setOperationType($operationType)
            ->setReportFileDownloadUrl($reportFileDownloadUrl)
            ->setSelectCriteria($selectCriteria)
            ->setStatus($status)
            ->setUploadedFileLocation($uploadedFileLocation)
            ->setUserId($userId);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ItemsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemsCount()
    {
        return isset($this->ItemsCount) ? $this->ItemsCount : null;
    }
    /**
     * Set ItemsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemsCount
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setItemsCount($itemsCount = null)
    {
        // validation for constraint: int
        if (!is_null($itemsCount) && !(is_int($itemsCount) || ctype_digit($itemsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemsCount, true), gettype($itemsCount)), __LINE__);
        }
        if (is_null($itemsCount) || (is_array($itemsCount) && empty($itemsCount))) {
            unset($this->ItemsCount);
        } else {
            $this->ItemsCount = $itemsCount;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OperationRunDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationRunDate()
    {
        return isset($this->OperationRunDate) ? $this->OperationRunDate : null;
    }
    /**
     * Set OperationRunDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationRunDate
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setOperationRunDate($operationRunDate = null)
    {
        // validation for constraint: string
        if (!is_null($operationRunDate) && !is_string($operationRunDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationRunDate, true), gettype($operationRunDate)), __LINE__);
        }
        if (is_null($operationRunDate) || (is_array($operationRunDate) && empty($operationRunDate))) {
            unset($this->OperationRunDate);
        } else {
            $this->OperationRunDate = $operationRunDate;
        }
        return $this;
    }
    /**
     * Get OperationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationType()
    {
        return isset($this->OperationType) ? $this->OperationType : null;
    }
    /**
     * Set OperationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationType
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        if (is_null($operationType) || (is_array($operationType) && empty($operationType))) {
            unset($this->OperationType);
        } else {
            $this->OperationType = $operationType;
        }
        return $this;
    }
    /**
     * Get ReportFileDownloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportFileDownloadUrl()
    {
        return isset($this->ReportFileDownloadUrl) ? $this->ReportFileDownloadUrl : null;
    }
    /**
     * Set ReportFileDownloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportFileDownloadUrl
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setReportFileDownloadUrl($reportFileDownloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($reportFileDownloadUrl) && !is_string($reportFileDownloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportFileDownloadUrl, true), gettype($reportFileDownloadUrl)), __LINE__);
        }
        if (is_null($reportFileDownloadUrl) || (is_array($reportFileDownloadUrl) && empty($reportFileDownloadUrl))) {
            unset($this->ReportFileDownloadUrl);
        } else {
            $this->ReportFileDownloadUrl = $reportFileDownloadUrl;
        }
        return $this;
    }
    /**
     * Get SelectCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectCriteria()
    {
        return isset($this->SelectCriteria) ? $this->SelectCriteria : null;
    }
    /**
     * Set SelectCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectCriteria
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setSelectCriteria($selectCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($selectCriteria) && !is_string($selectCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectCriteria, true), gettype($selectCriteria)), __LINE__);
        }
        if (is_null($selectCriteria) || (is_array($selectCriteria) && empty($selectCriteria))) {
            unset($this->SelectCriteria);
        } else {
            $this->SelectCriteria = $selectCriteria;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UploadedFileLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedFileLocation()
    {
        return isset($this->UploadedFileLocation) ? $this->UploadedFileLocation : null;
    }
    /**
     * Set UploadedFileLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedFileLocation
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setUploadedFileLocation($uploadedFileLocation = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedFileLocation) && !is_string($uploadedFileLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedFileLocation, true), gettype($uploadedFileLocation)), __LINE__);
        }
        if (is_null($uploadedFileLocation) || (is_array($uploadedFileLocation) && empty($uploadedFileLocation))) {
            unset($this->UploadedFileLocation);
        } else {
            $this->UploadedFileLocation = $uploadedFileLocation;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\AccessControl_ShowtimeBulkOperation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
