<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ShowTimeEventData StructType
 * @subpackage Structs
 */
class AccessControl_ShowTimeEventData extends AccessControl_ShowTimeEntityData
{
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The EndDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDateUtc;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeriesIds
     */
    public $SeriesIds;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The StartDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDateUtc;
    /**
     * The TimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeZone;
    /**
     * Constructor method for AccessControl.ShowTimeEventData
     * @uses AccessControl_ShowTimeEventData::setEndDate()
     * @uses AccessControl_ShowTimeEventData::setEndDateUtc()
     * @uses AccessControl_ShowTimeEventData::setHallId()
     * @uses AccessControl_ShowTimeEventData::setHallName()
     * @uses AccessControl_ShowTimeEventData::setSeriesIds()
     * @uses AccessControl_ShowTimeEventData::setShowId()
     * @uses AccessControl_ShowTimeEventData::setShowTypeId()
     * @uses AccessControl_ShowTimeEventData::setStartDate()
     * @uses AccessControl_ShowTimeEventData::setStartDateUtc()
     * @uses AccessControl_ShowTimeEventData::setTimeZone()
     * @param string $endDate
     * @param string $endDateUtc
     * @param string $hallId
     * @param string $hallName
     * @param \patest\StructType\SeriesIds $seriesIds
     * @param string $showId
     * @param string $showTypeId
     * @param string $startDate
     * @param string $startDateUtc
     * @param string $timeZone
     */
    public function __construct($endDate = null, $endDateUtc = null, $hallId = null, $hallName = null, \patest\StructType\SeriesIds $seriesIds = null, $showId = null, $showTypeId = null, $startDate = null, $startDateUtc = null, $timeZone = null)
    {
        $this
            ->setEndDate($endDate)
            ->setEndDateUtc($endDateUtc)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setSeriesIds($seriesIds)
            ->setShowId($showId)
            ->setShowTypeId($showTypeId)
            ->setStartDate($startDate)
            ->setStartDateUtc($startDateUtc)
            ->setTimeZone($timeZone);
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get EndDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDateUtc()
    {
        return isset($this->EndDateUtc) ? $this->EndDateUtc : null;
    }
    /**
     * Set EndDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDateUtc
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setEndDateUtc($endDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($endDateUtc) && !is_string($endDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateUtc, true), gettype($endDateUtc)), __LINE__);
        }
        if (is_null($endDateUtc) || (is_array($endDateUtc) && empty($endDateUtc))) {
            unset($this->EndDateUtc);
        } else {
            $this->EndDateUtc = $endDateUtc;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeriesIds|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeriesIds $seriesIds
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setSeriesIds(\patest\StructType\SeriesIds $seriesIds = null)
    {
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTypeId()
    {
        return isset($this->ShowTypeId) ? $this->ShowTypeId : null;
    }
    /**
     * Set ShowTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTypeId
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        if (is_null($showTypeId) || (is_array($showTypeId) && empty($showTypeId))) {
            unset($this->ShowTypeId);
        } else {
            $this->ShowTypeId = $showTypeId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get StartDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDateUtc()
    {
        return isset($this->StartDateUtc) ? $this->StartDateUtc : null;
    }
    /**
     * Set StartDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDateUtc
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setStartDateUtc($startDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($startDateUtc) && !is_string($startDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateUtc, true), gettype($startDateUtc)), __LINE__);
        }
        if (is_null($startDateUtc) || (is_array($startDateUtc) && empty($startDateUtc))) {
            unset($this->StartDateUtc);
        } else {
            $this->StartDateUtc = $startDateUtc;
        }
        return $this;
    }
    /**
     * Get TimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeZone()
    {
        return isset($this->TimeZone) ? $this->TimeZone : null;
    }
    /**
     * Set TimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeZone
     * @return \patest\StructType\AccessControl_ShowTimeEventData
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZone, true), gettype($timeZone)), __LINE__);
        }
        if (is_null($timeZone) || (is_array($timeZone) && empty($timeZone))) {
            unset($this->TimeZone);
        } else {
            $this->TimeZone = $timeZone;
        }
        return $this;
    }
}
