<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.Scanner StructType
 * @subpackage Structs
 */
class AccessControl_Scanner extends PersistableEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The HallIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\HallIds
     */
    public $HallIds;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for AccessControl.Scanner
     * @uses AccessControl_Scanner::setDescription()
     * @uses AccessControl_Scanner::setExternalId()
     * @uses AccessControl_Scanner::setHallIds()
     * @uses AccessControl_Scanner::setIsActive()
     * @uses AccessControl_Scanner::setOrganizationUnitId()
     * @uses AccessControl_Scanner::setVisibleBySubordinates()
     * @param string $description
     * @param string $externalId
     * @param \patest\StructType\HallIds $hallIds
     * @param bool $isActive
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($description = null, $externalId = null, \patest\StructType\HallIds $hallIds = null, $isActive = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setDescription($description)
            ->setExternalId($externalId)
            ->setHallIds($hallIds)
            ->setIsActive($isActive)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get HallIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\HallIds|null
     */
    public function getHallIds()
    {
        return isset($this->HallIds) ? $this->HallIds : null;
    }
    /**
     * Set HallIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\HallIds $hallIds
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setHallIds(\patest\StructType\HallIds $hallIds = null)
    {
        if (is_null($hallIds) || (is_array($hallIds) && empty($hallIds))) {
            unset($this->HallIds);
        } else {
            $this->HallIds = $hallIds;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\AccessControl_Scanner
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
