<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ScanIngestionApiRequestFailureEntry
 * StructType
 * @subpackage Structs
 */
class AccessControl_ScanIngestionApiRequestFailureEntry extends PersistableEntity
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventId;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reason;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TimeStamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TimeStamp;
    /**
     * The UniqueId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UniqueId;
    /**
     * Constructor method for AccessControl.ScanIngestionApiRequestFailureEntry
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setBarcode()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setDetails()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setEventId()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setReason()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setRequestId()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setState()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setTimeStamp()
     * @uses AccessControl_ScanIngestionApiRequestFailureEntry::setUniqueId()
     * @param string $barcode
     * @param string $details
     * @param string $eventId
     * @param string $reason
     * @param string $requestId
     * @param string $state
     * @param string $timeStamp
     * @param string $uniqueId
     */
    public function __construct($barcode = null, $details = null, $eventId = null, $reason = null, $requestId = null, $state = null, $timeStamp = null, $uniqueId = null)
    {
        $this
            ->setBarcode($barcode)
            ->setDetails($details)
            ->setEventId($eventId)
            ->setReason($reason)
            ->setRequestId($requestId)
            ->setState($state)
            ->setTimeStamp($timeStamp)
            ->setUniqueId($uniqueId);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestId, true)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScanIngestionApiRequestEntryFailureState::valueIsValid()
     * @uses \patest\EnumType\ScanIngestionApiRequestEntryFailureState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanIngestionApiRequestEntryFailureState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanIngestionApiRequestEntryFailureState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\ScanIngestionApiRequestEntryFailureState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TimeStamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeStamp()
    {
        return isset($this->TimeStamp) ? $this->TimeStamp : null;
    }
    /**
     * Set TimeStamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeStamp
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        if (is_null($timeStamp) || (is_array($timeStamp) && empty($timeStamp))) {
            unset($this->TimeStamp);
        } else {
            $this->TimeStamp = $timeStamp;
        }
        return $this;
    }
    /**
     * Get UniqueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUniqueId()
    {
        return isset($this->UniqueId) ? $this->UniqueId : null;
    }
    /**
     * Set UniqueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uniqueId
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequestFailureEntry
     */
    public function setUniqueId($uniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueId) && !is_string($uniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueId, true), gettype($uniqueId)), __LINE__);
        }
        if (is_null($uniqueId) || (is_array($uniqueId) && empty($uniqueId))) {
            unset($this->UniqueId);
        } else {
            $this->UniqueId = $uniqueId;
        }
        return $this;
    }
}
