<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ScanExtraData.JointMembership StructType
 * @subpackage Structs
 */
class AccessControl_ScanExtraData_JointMembership extends AnyEntity
{
    /**
     * The NumberOfScannedExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfScannedExtras;
    /**
     * The NumberOfScannedGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfScannedGuests;
    /**
     * The NumberOfScannedOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfScannedOwners;
    /**
     * The ScannedClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScannedClientIds
     */
    public $ScannedClientIds;
    /**
     * Constructor method for AccessControl.ScanExtraData.JointMembership
     * @uses AccessControl_ScanExtraData_JointMembership::setNumberOfScannedExtras()
     * @uses AccessControl_ScanExtraData_JointMembership::setNumberOfScannedGuests()
     * @uses AccessControl_ScanExtraData_JointMembership::setNumberOfScannedOwners()
     * @uses AccessControl_ScanExtraData_JointMembership::setScannedClientIds()
     * @param int $numberOfScannedExtras
     * @param int $numberOfScannedGuests
     * @param int $numberOfScannedOwners
     * @param \patest\StructType\ScannedClientIds $scannedClientIds
     */
    public function __construct($numberOfScannedExtras = null, $numberOfScannedGuests = null, $numberOfScannedOwners = null, \patest\StructType\ScannedClientIds $scannedClientIds = null)
    {
        $this
            ->setNumberOfScannedExtras($numberOfScannedExtras)
            ->setNumberOfScannedGuests($numberOfScannedGuests)
            ->setNumberOfScannedOwners($numberOfScannedOwners)
            ->setScannedClientIds($scannedClientIds);
    }
    /**
     * Get NumberOfScannedExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfScannedExtras()
    {
        return isset($this->NumberOfScannedExtras) ? $this->NumberOfScannedExtras : null;
    }
    /**
     * Set NumberOfScannedExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfScannedExtras
     * @return \patest\StructType\AccessControl_ScanExtraData_JointMembership
     */
    public function setNumberOfScannedExtras($numberOfScannedExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfScannedExtras) && !(is_int($numberOfScannedExtras) || ctype_digit($numberOfScannedExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfScannedExtras, true), gettype($numberOfScannedExtras)), __LINE__);
        }
        if (is_null($numberOfScannedExtras) || (is_array($numberOfScannedExtras) && empty($numberOfScannedExtras))) {
            unset($this->NumberOfScannedExtras);
        } else {
            $this->NumberOfScannedExtras = $numberOfScannedExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfScannedGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfScannedGuests()
    {
        return isset($this->NumberOfScannedGuests) ? $this->NumberOfScannedGuests : null;
    }
    /**
     * Set NumberOfScannedGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfScannedGuests
     * @return \patest\StructType\AccessControl_ScanExtraData_JointMembership
     */
    public function setNumberOfScannedGuests($numberOfScannedGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfScannedGuests) && !(is_int($numberOfScannedGuests) || ctype_digit($numberOfScannedGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfScannedGuests, true), gettype($numberOfScannedGuests)), __LINE__);
        }
        if (is_null($numberOfScannedGuests) || (is_array($numberOfScannedGuests) && empty($numberOfScannedGuests))) {
            unset($this->NumberOfScannedGuests);
        } else {
            $this->NumberOfScannedGuests = $numberOfScannedGuests;
        }
        return $this;
    }
    /**
     * Get NumberOfScannedOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfScannedOwners()
    {
        return isset($this->NumberOfScannedOwners) ? $this->NumberOfScannedOwners : null;
    }
    /**
     * Set NumberOfScannedOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfScannedOwners
     * @return \patest\StructType\AccessControl_ScanExtraData_JointMembership
     */
    public function setNumberOfScannedOwners($numberOfScannedOwners = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfScannedOwners) && !(is_int($numberOfScannedOwners) || ctype_digit($numberOfScannedOwners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfScannedOwners, true), gettype($numberOfScannedOwners)), __LINE__);
        }
        if (is_null($numberOfScannedOwners) || (is_array($numberOfScannedOwners) && empty($numberOfScannedOwners))) {
            unset($this->NumberOfScannedOwners);
        } else {
            $this->NumberOfScannedOwners = $numberOfScannedOwners;
        }
        return $this;
    }
    /**
     * Get ScannedClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScannedClientIds|null
     */
    public function getScannedClientIds()
    {
        return isset($this->ScannedClientIds) ? $this->ScannedClientIds : null;
    }
    /**
     * Set ScannedClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScannedClientIds $scannedClientIds
     * @return \patest\StructType\AccessControl_ScanExtraData_JointMembership
     */
    public function setScannedClientIds(\patest\StructType\ScannedClientIds $scannedClientIds = null)
    {
        if (is_null($scannedClientIds) || (is_array($scannedClientIds) && empty($scannedClientIds))) {
            unset($this->ScannedClientIds);
        } else {
            $this->ScannedClientIds = $scannedClientIds;
        }
        return $this;
    }
}
