<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ScanDataIngestionJob.QueuedWorkItem
 * StructType
 * @subpackage Structs
 */
class AccessControl_ScanDataIngestionJob_QueuedWorkItem extends Foundation_QueuedWorkItem
{
    /**
     * The ScanIngestionRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanIngestionRequestId;
    /**
     * Constructor method for AccessControl.ScanDataIngestionJob.QueuedWorkItem
     * @uses AccessControl_ScanDataIngestionJob_QueuedWorkItem::setScanIngestionRequestId()
     * @param string $scanIngestionRequestId
     */
    public function __construct($scanIngestionRequestId = null)
    {
        $this
            ->setScanIngestionRequestId($scanIngestionRequestId);
    }
    /**
     * Get ScanIngestionRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanIngestionRequestId()
    {
        return isset($this->ScanIngestionRequestId) ? $this->ScanIngestionRequestId : null;
    }
    /**
     * Set ScanIngestionRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanIngestionRequestId
     * @return \patest\StructType\AccessControl_ScanDataIngestionJob_QueuedWorkItem
     */
    public function setScanIngestionRequestId($scanIngestionRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($scanIngestionRequestId) && !is_string($scanIngestionRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanIngestionRequestId, true), gettype($scanIngestionRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanIngestionRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanIngestionRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanIngestionRequestId, true)), __LINE__);
        }
        if (is_null($scanIngestionRequestId) || (is_array($scanIngestionRequestId) && empty($scanIngestionRequestId))) {
            unset($this->ScanIngestionRequestId);
        } else {
            $this->ScanIngestionRequestId = $scanIngestionRequestId;
        }
        return $this;
    }
}
