<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ResetEventScansJobData StructType
 * @subpackage Structs
 */
class AccessControl_ResetEventScansJobData extends AnyEntity
{
    /**
     * The ResetScanDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResetScanDataId;
    /**
     * Constructor method for AccessControl.ResetEventScansJobData
     * @uses AccessControl_ResetEventScansJobData::setResetScanDataId()
     * @param string $resetScanDataId
     */
    public function __construct($resetScanDataId = null)
    {
        $this
            ->setResetScanDataId($resetScanDataId);
    }
    /**
     * Get ResetScanDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetScanDataId()
    {
        return isset($this->ResetScanDataId) ? $this->ResetScanDataId : null;
    }
    /**
     * Set ResetScanDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetScanDataId
     * @return \patest\StructType\AccessControl_ResetEventScansJobData
     */
    public function setResetScanDataId($resetScanDataId = null)
    {
        // validation for constraint: string
        if (!is_null($resetScanDataId) && !is_string($resetScanDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetScanDataId, true), gettype($resetScanDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resetScanDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resetScanDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resetScanDataId, true)), __LINE__);
        }
        if (is_null($resetScanDataId) || (is_array($resetScanDataId) && empty($resetScanDataId))) {
            unset($this->ResetScanDataId);
        } else {
            $this->ResetScanDataId = $resetScanDataId;
        }
        return $this;
    }
}
