<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ResetEventScanData StructType
 * @subpackage Structs
 */
class AccessControl_ResetEventScanData extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The InitiatedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InitiatedByUserId;
    /**
     * The ResetScanDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResetScanDate;
    /**
     * The ResetScanReason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResetScanReason;
    /**
     * The ResetScanReasonDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResetScanReasonDescr;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for AccessControl.ResetEventScanData
     * @uses AccessControl_ResetEventScanData::setAccessControlSystemId()
     * @uses AccessControl_ResetEventScanData::setEventId()
     * @uses AccessControl_ResetEventScanData::setInitiatedByUserId()
     * @uses AccessControl_ResetEventScanData::setResetScanDate()
     * @uses AccessControl_ResetEventScanData::setResetScanReason()
     * @uses AccessControl_ResetEventScanData::setResetScanReasonDescr()
     * @uses AccessControl_ResetEventScanData::setStatus()
     * @param string $accessControlSystemId
     * @param string $eventId
     * @param string $initiatedByUserId
     * @param string $resetScanDate
     * @param string $resetScanReason
     * @param string $resetScanReasonDescr
     * @param string $status
     */
    public function __construct($accessControlSystemId = null, $eventId = null, $initiatedByUserId = null, $resetScanDate = null, $resetScanReason = null, $resetScanReasonDescr = null, $status = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setEventId($eventId)
            ->setInitiatedByUserId($initiatedByUserId)
            ->setResetScanDate($resetScanDate)
            ->setResetScanReason($resetScanReason)
            ->setResetScanReasonDescr($resetScanReasonDescr)
            ->setStatus($status);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get InitiatedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitiatedByUserId()
    {
        return isset($this->InitiatedByUserId) ? $this->InitiatedByUserId : null;
    }
    /**
     * Set InitiatedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initiatedByUserId
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setInitiatedByUserId($initiatedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($initiatedByUserId) && !is_string($initiatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initiatedByUserId, true), gettype($initiatedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($initiatedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $initiatedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($initiatedByUserId, true)), __LINE__);
        }
        if (is_null($initiatedByUserId) || (is_array($initiatedByUserId) && empty($initiatedByUserId))) {
            unset($this->InitiatedByUserId);
        } else {
            $this->InitiatedByUserId = $initiatedByUserId;
        }
        return $this;
    }
    /**
     * Get ResetScanDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetScanDate()
    {
        return isset($this->ResetScanDate) ? $this->ResetScanDate : null;
    }
    /**
     * Set ResetScanDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetScanDate
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setResetScanDate($resetScanDate = null)
    {
        // validation for constraint: string
        if (!is_null($resetScanDate) && !is_string($resetScanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetScanDate, true), gettype($resetScanDate)), __LINE__);
        }
        if (is_null($resetScanDate) || (is_array($resetScanDate) && empty($resetScanDate))) {
            unset($this->ResetScanDate);
        } else {
            $this->ResetScanDate = $resetScanDate;
        }
        return $this;
    }
    /**
     * Get ResetScanReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetScanReason()
    {
        return isset($this->ResetScanReason) ? $this->ResetScanReason : null;
    }
    /**
     * Set ResetScanReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResetScanReason::valueIsValid()
     * @uses \patest\EnumType\ResetScanReason::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resetScanReason
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setResetScanReason($resetScanReason = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResetScanReason::valueIsValid($resetScanReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResetScanReason', is_array($resetScanReason) ? implode(', ', $resetScanReason) : var_export($resetScanReason, true), implode(', ', \patest\EnumType\ResetScanReason::getValidValues())), __LINE__);
        }
        if (is_null($resetScanReason) || (is_array($resetScanReason) && empty($resetScanReason))) {
            unset($this->ResetScanReason);
        } else {
            $this->ResetScanReason = $resetScanReason;
        }
        return $this;
    }
    /**
     * Get ResetScanReasonDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetScanReasonDescr()
    {
        return isset($this->ResetScanReasonDescr) ? $this->ResetScanReasonDescr : null;
    }
    /**
     * Set ResetScanReasonDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetScanReasonDescr
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setResetScanReasonDescr($resetScanReasonDescr = null)
    {
        // validation for constraint: string
        if (!is_null($resetScanReasonDescr) && !is_string($resetScanReasonDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetScanReasonDescr, true), gettype($resetScanReasonDescr)), __LINE__);
        }
        if (is_null($resetScanReasonDescr) || (is_array($resetScanReasonDescr) && empty($resetScanReasonDescr))) {
            unset($this->ResetScanReasonDescr);
        } else {
            $this->ResetScanReasonDescr = $resetScanReasonDescr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResetScanStatus::valueIsValid()
     * @uses \patest\EnumType\ResetScanStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\AccessControl_ResetEventScanData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResetScanStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResetScanStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ResetScanStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
