<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ProductExtensionForAccessControl StructType
 * @subpackage Structs
 */
class AccessControl_ProductExtensionForAccessControl extends PersistableEntity
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The AccessControlSystemMemberId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemMemberId;
    /**
     * The ApiBarcodeInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApiBarcodeInfo;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeRefEntityId;
    /**
     * The BarcodesHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodesHistory;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The LastConnectionTimedOut
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LastConnectionTimedOut;
    /**
     * The LastError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastError;
    /**
     * The MemberId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberId;
    /**
     * The NeedToUnloadFromCard
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeedToUnloadFromCard;
    /**
     * The PreviousBarcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousBarcode;
    /**
     * The PreviousVersion
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviousVersion;
    /**
     * The ProductIsReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ProductIsReserved;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * The Returned
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Returned;
    /**
     * The ReturnReasonId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReturnReasonId;
    /**
     * The ShowTimeNfcPassUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTimeNfcPassUrl;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for AccessControl.ProductExtensionForAccessControl
     * @uses AccessControl_ProductExtensionForAccessControl::setAccessCardId()
     * @uses AccessControl_ProductExtensionForAccessControl::setAccessControlSystemId()
     * @uses AccessControl_ProductExtensionForAccessControl::setAccessControlSystemMemberId()
     * @uses AccessControl_ProductExtensionForAccessControl::setApiBarcodeInfo()
     * @uses AccessControl_ProductExtensionForAccessControl::setBarcode()
     * @uses AccessControl_ProductExtensionForAccessControl::setBarcodeRefEntityId()
     * @uses AccessControl_ProductExtensionForAccessControl::setBarcodesHistory()
     * @uses AccessControl_ProductExtensionForAccessControl::setCardNumber()
     * @uses AccessControl_ProductExtensionForAccessControl::setClientId()
     * @uses AccessControl_ProductExtensionForAccessControl::setCreationDate()
     * @uses AccessControl_ProductExtensionForAccessControl::setLastConnectionTimedOut()
     * @uses AccessControl_ProductExtensionForAccessControl::setLastError()
     * @uses AccessControl_ProductExtensionForAccessControl::setMemberId()
     * @uses AccessControl_ProductExtensionForAccessControl::setNeedToUnloadFromCard()
     * @uses AccessControl_ProductExtensionForAccessControl::setPreviousBarcode()
     * @uses AccessControl_ProductExtensionForAccessControl::setPreviousVersion()
     * @uses AccessControl_ProductExtensionForAccessControl::setProductIsReserved()
     * @uses AccessControl_ProductExtensionForAccessControl::setProductType()
     * @uses AccessControl_ProductExtensionForAccessControl::setReturned()
     * @uses AccessControl_ProductExtensionForAccessControl::setReturnReasonId()
     * @uses AccessControl_ProductExtensionForAccessControl::setShowTimeNfcPassUrl()
     * @uses AccessControl_ProductExtensionForAccessControl::setXmlContainer()
     * @param string $accessCardId
     * @param string $accessControlSystemId
     * @param string $accessControlSystemMemberId
     * @param string $apiBarcodeInfo
     * @param string $barcode
     * @param string $barcodeRefEntityId
     * @param string $barcodesHistory
     * @param string $cardNumber
     * @param string $clientId
     * @param string $creationDate
     * @param bool $lastConnectionTimedOut
     * @param string $lastError
     * @param string $memberId
     * @param bool $needToUnloadFromCard
     * @param string $previousBarcode
     * @param string $previousVersion
     * @param bool $productIsReserved
     * @param int $productType
     * @param bool $returned
     * @param string $returnReasonId
     * @param string $showTimeNfcPassUrl
     * @param string $xmlContainer
     */
    public function __construct($accessCardId = null, $accessControlSystemId = null, $accessControlSystemMemberId = null, $apiBarcodeInfo = null, $barcode = null, $barcodeRefEntityId = null, $barcodesHistory = null, $cardNumber = null, $clientId = null, $creationDate = null, $lastConnectionTimedOut = null, $lastError = null, $memberId = null, $needToUnloadFromCard = null, $previousBarcode = null, $previousVersion = null, $productIsReserved = null, $productType = null, $returned = null, $returnReasonId = null, $showTimeNfcPassUrl = null, $xmlContainer = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAccessControlSystemMemberId($accessControlSystemMemberId)
            ->setApiBarcodeInfo($apiBarcodeInfo)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityId($barcodeRefEntityId)
            ->setBarcodesHistory($barcodesHistory)
            ->setCardNumber($cardNumber)
            ->setClientId($clientId)
            ->setCreationDate($creationDate)
            ->setLastConnectionTimedOut($lastConnectionTimedOut)
            ->setLastError($lastError)
            ->setMemberId($memberId)
            ->setNeedToUnloadFromCard($needToUnloadFromCard)
            ->setPreviousBarcode($previousBarcode)
            ->setPreviousVersion($previousVersion)
            ->setProductIsReserved($productIsReserved)
            ->setProductType($productType)
            ->setReturned($returned)
            ->setReturnReasonId($returnReasonId)
            ->setShowTimeNfcPassUrl($showTimeNfcPassUrl)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemMemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemMemberId()
    {
        return isset($this->AccessControlSystemMemberId) ? $this->AccessControlSystemMemberId : null;
    }
    /**
     * Set AccessControlSystemMemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemMemberId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setAccessControlSystemMemberId($accessControlSystemMemberId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemMemberId) && !is_string($accessControlSystemMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemMemberId, true), gettype($accessControlSystemMemberId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemMemberId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemMemberId, true)), __LINE__);
        }
        if (is_null($accessControlSystemMemberId) || (is_array($accessControlSystemMemberId) && empty($accessControlSystemMemberId))) {
            unset($this->AccessControlSystemMemberId);
        } else {
            $this->AccessControlSystemMemberId = $accessControlSystemMemberId;
        }
        return $this;
    }
    /**
     * Get ApiBarcodeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApiBarcodeInfo()
    {
        return isset($this->ApiBarcodeInfo) ? $this->ApiBarcodeInfo : null;
    }
    /**
     * Set ApiBarcodeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $apiBarcodeInfo
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setApiBarcodeInfo($apiBarcodeInfo = null)
    {
        // validation for constraint: string
        if (!is_null($apiBarcodeInfo) && !is_string($apiBarcodeInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiBarcodeInfo, true), gettype($apiBarcodeInfo)), __LINE__);
        }
        if (is_null($apiBarcodeInfo) || (is_array($apiBarcodeInfo) && empty($apiBarcodeInfo))) {
            unset($this->ApiBarcodeInfo);
        } else {
            $this->ApiBarcodeInfo = $apiBarcodeInfo;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityId()
    {
        return isset($this->BarcodeRefEntityId) ? $this->BarcodeRefEntityId : null;
    }
    /**
     * Set BarcodeRefEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setBarcodeRefEntityId($barcodeRefEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityId) && !is_string($barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityId, true), gettype($barcodeRefEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeRefEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeRefEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeRefEntityId, true)), __LINE__);
        }
        if (is_null($barcodeRefEntityId) || (is_array($barcodeRefEntityId) && empty($barcodeRefEntityId))) {
            unset($this->BarcodeRefEntityId);
        } else {
            $this->BarcodeRefEntityId = $barcodeRefEntityId;
        }
        return $this;
    }
    /**
     * Get BarcodesHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodesHistory()
    {
        return isset($this->BarcodesHistory) ? $this->BarcodesHistory : null;
    }
    /**
     * Set BarcodesHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodesHistory
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setBarcodesHistory($barcodesHistory = null)
    {
        // validation for constraint: string
        if (!is_null($barcodesHistory) && !is_string($barcodesHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodesHistory, true), gettype($barcodesHistory)), __LINE__);
        }
        if (is_null($barcodesHistory) || (is_array($barcodesHistory) && empty($barcodesHistory))) {
            unset($this->BarcodesHistory);
        } else {
            $this->BarcodesHistory = $barcodesHistory;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get LastConnectionTimedOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLastConnectionTimedOut()
    {
        return isset($this->LastConnectionTimedOut) ? $this->LastConnectionTimedOut : null;
    }
    /**
     * Set LastConnectionTimedOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $lastConnectionTimedOut
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setLastConnectionTimedOut($lastConnectionTimedOut = null)
    {
        // validation for constraint: boolean
        if (!is_null($lastConnectionTimedOut) && !is_bool($lastConnectionTimedOut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lastConnectionTimedOut, true), gettype($lastConnectionTimedOut)), __LINE__);
        }
        if (is_null($lastConnectionTimedOut) || (is_array($lastConnectionTimedOut) && empty($lastConnectionTimedOut))) {
            unset($this->LastConnectionTimedOut);
        } else {
            $this->LastConnectionTimedOut = $lastConnectionTimedOut;
        }
        return $this;
    }
    /**
     * Get LastError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastError()
    {
        return isset($this->LastError) ? $this->LastError : null;
    }
    /**
     * Set LastError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastError
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setLastError($lastError = null)
    {
        // validation for constraint: string
        if (!is_null($lastError) && !is_string($lastError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastError, true), gettype($lastError)), __LINE__);
        }
        if (is_null($lastError) || (is_array($lastError) && empty($lastError))) {
            unset($this->LastError);
        } else {
            $this->LastError = $lastError;
        }
        return $this;
    }
    /**
     * Get MemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberId()
    {
        return isset($this->MemberId) ? $this->MemberId : null;
    }
    /**
     * Set MemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setMemberId($memberId = null)
    {
        // validation for constraint: string
        if (!is_null($memberId) && !is_string($memberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberId, true), gettype($memberId)), __LINE__);
        }
        if (is_null($memberId) || (is_array($memberId) && empty($memberId))) {
            unset($this->MemberId);
        } else {
            $this->MemberId = $memberId;
        }
        return $this;
    }
    /**
     * Get NeedToUnloadFromCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeedToUnloadFromCard()
    {
        return isset($this->NeedToUnloadFromCard) ? $this->NeedToUnloadFromCard : null;
    }
    /**
     * Set NeedToUnloadFromCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $needToUnloadFromCard
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setNeedToUnloadFromCard($needToUnloadFromCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($needToUnloadFromCard) && !is_bool($needToUnloadFromCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needToUnloadFromCard, true), gettype($needToUnloadFromCard)), __LINE__);
        }
        if (is_null($needToUnloadFromCard) || (is_array($needToUnloadFromCard) && empty($needToUnloadFromCard))) {
            unset($this->NeedToUnloadFromCard);
        } else {
            $this->NeedToUnloadFromCard = $needToUnloadFromCard;
        }
        return $this;
    }
    /**
     * Get PreviousBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousBarcode()
    {
        return isset($this->PreviousBarcode) ? $this->PreviousBarcode : null;
    }
    /**
     * Set PreviousBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousBarcode
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setPreviousBarcode($previousBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($previousBarcode) && !is_string($previousBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousBarcode, true), gettype($previousBarcode)), __LINE__);
        }
        if (is_null($previousBarcode) || (is_array($previousBarcode) && empty($previousBarcode))) {
            unset($this->PreviousBarcode);
        } else {
            $this->PreviousBarcode = $previousBarcode;
        }
        return $this;
    }
    /**
     * Get PreviousVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviousVersion()
    {
        return isset($this->PreviousVersion) ? $this->PreviousVersion : null;
    }
    /**
     * Set PreviousVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previousVersion
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setPreviousVersion($previousVersion = null)
    {
        // validation for constraint: string
        if (!is_null($previousVersion) && !is_string($previousVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previousVersion, true), gettype($previousVersion)), __LINE__);
        }
        if (is_null($previousVersion) || (is_array($previousVersion) && empty($previousVersion))) {
            unset($this->PreviousVersion);
        } else {
            $this->PreviousVersion = $previousVersion;
        }
        return $this;
    }
    /**
     * Get ProductIsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getProductIsReserved()
    {
        return isset($this->ProductIsReserved) ? $this->ProductIsReserved : null;
    }
    /**
     * Set ProductIsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $productIsReserved
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setProductIsReserved($productIsReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($productIsReserved) && !is_bool($productIsReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($productIsReserved, true), gettype($productIsReserved)), __LINE__);
        }
        if (is_null($productIsReserved) || (is_array($productIsReserved) && empty($productIsReserved))) {
            unset($this->ProductIsReserved);
        } else {
            $this->ProductIsReserved = $productIsReserved;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $productType
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !(is_int($productType) || ctype_digit($productType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get Returned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturned()
    {
        return isset($this->Returned) ? $this->Returned : null;
    }
    /**
     * Set Returned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returned
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setReturned($returned = null)
    {
        // validation for constraint: boolean
        if (!is_null($returned) && !is_bool($returned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returned, true), gettype($returned)), __LINE__);
        }
        if (is_null($returned) || (is_array($returned) && empty($returned))) {
            unset($this->Returned);
        } else {
            $this->Returned = $returned;
        }
        return $this;
    }
    /**
     * Get ReturnReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReturnReasonId()
    {
        return isset($this->ReturnReasonId) ? $this->ReturnReasonId : null;
    }
    /**
     * Set ReturnReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $returnReasonId
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setReturnReasonId($returnReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($returnReasonId) && !is_string($returnReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnReasonId, true), gettype($returnReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($returnReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $returnReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($returnReasonId, true)), __LINE__);
        }
        if (is_null($returnReasonId) || (is_array($returnReasonId) && empty($returnReasonId))) {
            unset($this->ReturnReasonId);
        } else {
            $this->ReturnReasonId = $returnReasonId;
        }
        return $this;
    }
    /**
     * Get ShowTimeNfcPassUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTimeNfcPassUrl()
    {
        return isset($this->ShowTimeNfcPassUrl) ? $this->ShowTimeNfcPassUrl : null;
    }
    /**
     * Set ShowTimeNfcPassUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTimeNfcPassUrl
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setShowTimeNfcPassUrl($showTimeNfcPassUrl = null)
    {
        // validation for constraint: string
        if (!is_null($showTimeNfcPassUrl) && !is_string($showTimeNfcPassUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTimeNfcPassUrl, true), gettype($showTimeNfcPassUrl)), __LINE__);
        }
        if (is_null($showTimeNfcPassUrl) || (is_array($showTimeNfcPassUrl) && empty($showTimeNfcPassUrl))) {
            unset($this->ShowTimeNfcPassUrl);
        } else {
            $this->ShowTimeNfcPassUrl = $showTimeNfcPassUrl;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\AccessControl_ProductExtensionForAccessControl
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
