<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.MobileApplication StructType
 * @subpackage Structs
 */
class AccessControl_MobileApplication extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The MobileAppDownloadUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppDownloadUrl;
    /**
     * The MobileAppProviderConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppProviderConfig;
    /**
     * The MobileAppProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileAppProviderId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for AccessControl.MobileApplication
     * @uses AccessControl_MobileApplication::setIsActive()
     * @uses AccessControl_MobileApplication::setMobileAppDownloadUrl()
     * @uses AccessControl_MobileApplication::setMobileAppProviderConfig()
     * @uses AccessControl_MobileApplication::setMobileAppProviderId()
     * @uses AccessControl_MobileApplication::setOrganizationUnitId()
     * @uses AccessControl_MobileApplication::setVisibleBySubordinates()
     * @param bool $isActive
     * @param string $mobileAppDownloadUrl
     * @param string $mobileAppProviderConfig
     * @param string $mobileAppProviderId
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($isActive = null, $mobileAppDownloadUrl = null, $mobileAppProviderConfig = null, $mobileAppProviderId = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setIsActive($isActive)
            ->setMobileAppDownloadUrl($mobileAppDownloadUrl)
            ->setMobileAppProviderConfig($mobileAppProviderConfig)
            ->setMobileAppProviderId($mobileAppProviderId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get MobileAppDownloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppDownloadUrl()
    {
        return isset($this->MobileAppDownloadUrl) ? $this->MobileAppDownloadUrl : null;
    }
    /**
     * Set MobileAppDownloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppDownloadUrl
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setMobileAppDownloadUrl($mobileAppDownloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppDownloadUrl) && !is_string($mobileAppDownloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppDownloadUrl, true), gettype($mobileAppDownloadUrl)), __LINE__);
        }
        if (is_null($mobileAppDownloadUrl) || (is_array($mobileAppDownloadUrl) && empty($mobileAppDownloadUrl))) {
            unset($this->MobileAppDownloadUrl);
        } else {
            $this->MobileAppDownloadUrl = $mobileAppDownloadUrl;
        }
        return $this;
    }
    /**
     * Get MobileAppProviderConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppProviderConfig()
    {
        return isset($this->MobileAppProviderConfig) ? $this->MobileAppProviderConfig : null;
    }
    /**
     * Set MobileAppProviderConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppProviderConfig
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setMobileAppProviderConfig($mobileAppProviderConfig = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppProviderConfig) && !is_string($mobileAppProviderConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppProviderConfig, true), gettype($mobileAppProviderConfig)), __LINE__);
        }
        if (is_null($mobileAppProviderConfig) || (is_array($mobileAppProviderConfig) && empty($mobileAppProviderConfig))) {
            unset($this->MobileAppProviderConfig);
        } else {
            $this->MobileAppProviderConfig = $mobileAppProviderConfig;
        }
        return $this;
    }
    /**
     * Get MobileAppProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileAppProviderId()
    {
        return isset($this->MobileAppProviderId) ? $this->MobileAppProviderId : null;
    }
    /**
     * Set MobileAppProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileAppProviderId
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setMobileAppProviderId($mobileAppProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($mobileAppProviderId) && !is_string($mobileAppProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileAppProviderId, true), gettype($mobileAppProviderId)), __LINE__);
        }
        if (is_null($mobileAppProviderId) || (is_array($mobileAppProviderId) && empty($mobileAppProviderId))) {
            unset($this->MobileAppProviderId);
        } else {
            $this->MobileAppProviderId = $mobileAppProviderId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\AccessControl_MobileApplication
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
