<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.MobileAppJournalLogFilter StructType
 * @subpackage Structs
 */
class AccessControl_MobileAppJournalLogFilter extends FilterEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ActivityTimestampFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityTimestampFrom;
    /**
     * The ActivityTimestampTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityTimestampTo;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The EventSystemName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:MobileApplicationEvent
     * @var string
     */
    public $EventSystemName;
    /**
     * The MobileApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MobileApplicationId;
    /**
     * The NotificationSentSuccessfully
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NotificationSentSuccessfully;
    /**
     * The NotificationTimestampFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationTimestampFrom;
    /**
     * The NotificationTimestampTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationTimestampTo;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * Constructor method for AccessControl.MobileAppJournalLogFilter
     * @uses AccessControl_MobileAppJournalLogFilter::setAccessControlSystemId()
     * @uses AccessControl_MobileAppJournalLogFilter::setActivityTimestampFrom()
     * @uses AccessControl_MobileAppJournalLogFilter::setActivityTimestampTo()
     * @uses AccessControl_MobileAppJournalLogFilter::setBarcode()
     * @uses AccessControl_MobileAppJournalLogFilter::setEventSystemName()
     * @uses AccessControl_MobileAppJournalLogFilter::setMobileApplicationId()
     * @uses AccessControl_MobileAppJournalLogFilter::setNotificationSentSuccessfully()
     * @uses AccessControl_MobileAppJournalLogFilter::setNotificationTimestampFrom()
     * @uses AccessControl_MobileAppJournalLogFilter::setNotificationTimestampTo()
     * @uses AccessControl_MobileAppJournalLogFilter::setOrganizationUnitId()
     * @param string $accessControlSystemId
     * @param string $activityTimestampFrom
     * @param string $activityTimestampTo
     * @param string $barcode
     * @param string $eventSystemName
     * @param string $mobileApplicationId
     * @param bool $notificationSentSuccessfully
     * @param string $notificationTimestampFrom
     * @param string $notificationTimestampTo
     * @param string $organizationUnitId
     */
    public function __construct($accessControlSystemId = null, $activityTimestampFrom = null, $activityTimestampTo = null, $barcode = null, $eventSystemName = null, $mobileApplicationId = null, $notificationSentSuccessfully = null, $notificationTimestampFrom = null, $notificationTimestampTo = null, $organizationUnitId = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setActivityTimestampFrom($activityTimestampFrom)
            ->setActivityTimestampTo($activityTimestampTo)
            ->setBarcode($barcode)
            ->setEventSystemName($eventSystemName)
            ->setMobileApplicationId($mobileApplicationId)
            ->setNotificationSentSuccessfully($notificationSentSuccessfully)
            ->setNotificationTimestampFrom($notificationTimestampFrom)
            ->setNotificationTimestampTo($notificationTimestampTo)
            ->setOrganizationUnitId($organizationUnitId);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ActivityTimestampFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityTimestampFrom()
    {
        return isset($this->ActivityTimestampFrom) ? $this->ActivityTimestampFrom : null;
    }
    /**
     * Set ActivityTimestampFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityTimestampFrom
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setActivityTimestampFrom($activityTimestampFrom = null)
    {
        // validation for constraint: string
        if (!is_null($activityTimestampFrom) && !is_string($activityTimestampFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityTimestampFrom, true), gettype($activityTimestampFrom)), __LINE__);
        }
        if (is_null($activityTimestampFrom) || (is_array($activityTimestampFrom) && empty($activityTimestampFrom))) {
            unset($this->ActivityTimestampFrom);
        } else {
            $this->ActivityTimestampFrom = $activityTimestampFrom;
        }
        return $this;
    }
    /**
     * Get ActivityTimestampTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityTimestampTo()
    {
        return isset($this->ActivityTimestampTo) ? $this->ActivityTimestampTo : null;
    }
    /**
     * Set ActivityTimestampTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityTimestampTo
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setActivityTimestampTo($activityTimestampTo = null)
    {
        // validation for constraint: string
        if (!is_null($activityTimestampTo) && !is_string($activityTimestampTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityTimestampTo, true), gettype($activityTimestampTo)), __LINE__);
        }
        if (is_null($activityTimestampTo) || (is_array($activityTimestampTo) && empty($activityTimestampTo))) {
            unset($this->ActivityTimestampTo);
        } else {
            $this->ActivityTimestampTo = $activityTimestampTo;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get EventSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventSystemName()
    {
        return isset($this->EventSystemName) ? $this->EventSystemName : null;
    }
    /**
     * Set EventSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventSystemName
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setEventSystemName($eventSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($eventSystemName) && !is_string($eventSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventSystemName, true), gettype($eventSystemName)), __LINE__);
        }
        if (is_null($eventSystemName) || (is_array($eventSystemName) && empty($eventSystemName))) {
            unset($this->EventSystemName);
        } else {
            $this->EventSystemName = $eventSystemName;
        }
        return $this;
    }
    /**
     * Get MobileApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileApplicationId()
    {
        return isset($this->MobileApplicationId) ? $this->MobileApplicationId : null;
    }
    /**
     * Set MobileApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileApplicationId
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setMobileApplicationId($mobileApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($mobileApplicationId) && !is_string($mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileApplicationId, true), gettype($mobileApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mobileApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mobileApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mobileApplicationId, true)), __LINE__);
        }
        if (is_null($mobileApplicationId) || (is_array($mobileApplicationId) && empty($mobileApplicationId))) {
            unset($this->MobileApplicationId);
        } else {
            $this->MobileApplicationId = $mobileApplicationId;
        }
        return $this;
    }
    /**
     * Get NotificationSentSuccessfully value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNotificationSentSuccessfully()
    {
        return isset($this->NotificationSentSuccessfully) ? $this->NotificationSentSuccessfully : null;
    }
    /**
     * Set NotificationSentSuccessfully value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $notificationSentSuccessfully
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setNotificationSentSuccessfully($notificationSentSuccessfully = null)
    {
        // validation for constraint: boolean
        if (!is_null($notificationSentSuccessfully) && !is_bool($notificationSentSuccessfully)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notificationSentSuccessfully, true), gettype($notificationSentSuccessfully)), __LINE__);
        }
        if (is_null($notificationSentSuccessfully) || (is_array($notificationSentSuccessfully) && empty($notificationSentSuccessfully))) {
            unset($this->NotificationSentSuccessfully);
        } else {
            $this->NotificationSentSuccessfully = $notificationSentSuccessfully;
        }
        return $this;
    }
    /**
     * Get NotificationTimestampFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationTimestampFrom()
    {
        return isset($this->NotificationTimestampFrom) ? $this->NotificationTimestampFrom : null;
    }
    /**
     * Set NotificationTimestampFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationTimestampFrom
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setNotificationTimestampFrom($notificationTimestampFrom = null)
    {
        // validation for constraint: string
        if (!is_null($notificationTimestampFrom) && !is_string($notificationTimestampFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationTimestampFrom, true), gettype($notificationTimestampFrom)), __LINE__);
        }
        if (is_null($notificationTimestampFrom) || (is_array($notificationTimestampFrom) && empty($notificationTimestampFrom))) {
            unset($this->NotificationTimestampFrom);
        } else {
            $this->NotificationTimestampFrom = $notificationTimestampFrom;
        }
        return $this;
    }
    /**
     * Get NotificationTimestampTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationTimestampTo()
    {
        return isset($this->NotificationTimestampTo) ? $this->NotificationTimestampTo : null;
    }
    /**
     * Set NotificationTimestampTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationTimestampTo
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setNotificationTimestampTo($notificationTimestampTo = null)
    {
        // validation for constraint: string
        if (!is_null($notificationTimestampTo) && !is_string($notificationTimestampTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notificationTimestampTo, true), gettype($notificationTimestampTo)), __LINE__);
        }
        if (is_null($notificationTimestampTo) || (is_array($notificationTimestampTo) && empty($notificationTimestampTo))) {
            unset($this->NotificationTimestampTo);
        } else {
            $this->NotificationTimestampTo = $notificationTimestampTo;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_MobileAppJournalLogFilter
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
}
