<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.InboundBarCodeFileItem StructType
 * @subpackage Structs
 */
class AccessControl_InboundBarCodeFileItem extends PersistableEntity
{
    /**
     * The BarCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarCode;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorText;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ExternalEventId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalEventId;
    /**
     * The ExternalItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalItemId;
    /**
     * The ExternalTransactionDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalTransactionDate;
    /**
     * The FileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FileId;
    /**
     * The IndexInFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IndexInFile;
    /**
     * The ItemData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemData;
    /**
     * The ItemPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemPrice;
    /**
     * The ProviderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for AccessControl.InboundBarCodeFileItem
     * @uses AccessControl_InboundBarCodeFileItem::setBarCode()
     * @uses AccessControl_InboundBarCodeFileItem::setEntityName()
     * @uses AccessControl_InboundBarCodeFileItem::setErrorCode()
     * @uses AccessControl_InboundBarCodeFileItem::setErrorText()
     * @uses AccessControl_InboundBarCodeFileItem::setEventDate()
     * @uses AccessControl_InboundBarCodeFileItem::setEventId()
     * @uses AccessControl_InboundBarCodeFileItem::setExternalEventId()
     * @uses AccessControl_InboundBarCodeFileItem::setExternalItemId()
     * @uses AccessControl_InboundBarCodeFileItem::setExternalTransactionDate()
     * @uses AccessControl_InboundBarCodeFileItem::setFileId()
     * @uses AccessControl_InboundBarCodeFileItem::setIndexInFile()
     * @uses AccessControl_InboundBarCodeFileItem::setItemData()
     * @uses AccessControl_InboundBarCodeFileItem::setItemPrice()
     * @uses AccessControl_InboundBarCodeFileItem::setProviderName()
     * @uses AccessControl_InboundBarCodeFileItem::setStatus()
     * @param string $barCode
     * @param string $entityName
     * @param string $errorCode
     * @param string $errorText
     * @param string $eventDate
     * @param string $eventId
     * @param string $externalEventId
     * @param string $externalItemId
     * @param string $externalTransactionDate
     * @param string $fileId
     * @param int $indexInFile
     * @param string $itemData
     * @param \patest\StructType\Money $itemPrice
     * @param string $providerName
     * @param string $status
     */
    public function __construct($barCode = null, $entityName = null, $errorCode = null, $errorText = null, $eventDate = null, $eventId = null, $externalEventId = null, $externalItemId = null, $externalTransactionDate = null, $fileId = null, $indexInFile = null, $itemData = null, \patest\StructType\Money $itemPrice = null, $providerName = null, $status = null)
    {
        $this
            ->setBarCode($barCode)
            ->setEntityName($entityName)
            ->setErrorCode($errorCode)
            ->setErrorText($errorText)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setExternalEventId($externalEventId)
            ->setExternalItemId($externalItemId)
            ->setExternalTransactionDate($externalTransactionDate)
            ->setFileId($fileId)
            ->setIndexInFile($indexInFile)
            ->setItemData($itemData)
            ->setItemPrice($itemPrice)
            ->setProviderName($providerName)
            ->setStatus($status);
    }
    /**
     * Get BarCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarCode()
    {
        return isset($this->BarCode) ? $this->BarCode : null;
    }
    /**
     * Set BarCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barCode
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setBarCode($barCode = null)
    {
        // validation for constraint: string
        if (!is_null($barCode) && !is_string($barCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barCode, true), gettype($barCode)), __LINE__);
        }
        if (is_null($barCode) || (is_array($barCode) && empty($barCode))) {
            unset($this->BarCode);
        } else {
            $this->BarCode = $barCode;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get ErrorCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorCode()
    {
        return isset($this->ErrorCode) ? $this->ErrorCode : null;
    }
    /**
     * Set ErrorCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorCode
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        if (is_null($errorCode) || (is_array($errorCode) && empty($errorCode))) {
            unset($this->ErrorCode);
        } else {
            $this->ErrorCode = $errorCode;
        }
        return $this;
    }
    /**
     * Get ErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->ErrorText) ? $this->ErrorText : null;
    }
    /**
     * Set ErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->ErrorText);
        } else {
            $this->ErrorText = $errorText;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ExternalEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalEventId()
    {
        return isset($this->ExternalEventId) ? $this->ExternalEventId : null;
    }
    /**
     * Set ExternalEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalEventId
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setExternalEventId($externalEventId = null)
    {
        // validation for constraint: string
        if (!is_null($externalEventId) && !is_string($externalEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalEventId, true), gettype($externalEventId)), __LINE__);
        }
        if (is_null($externalEventId) || (is_array($externalEventId) && empty($externalEventId))) {
            unset($this->ExternalEventId);
        } else {
            $this->ExternalEventId = $externalEventId;
        }
        return $this;
    }
    /**
     * Get ExternalItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalItemId()
    {
        return isset($this->ExternalItemId) ? $this->ExternalItemId : null;
    }
    /**
     * Set ExternalItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalItemId
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setExternalItemId($externalItemId = null)
    {
        // validation for constraint: string
        if (!is_null($externalItemId) && !is_string($externalItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalItemId, true), gettype($externalItemId)), __LINE__);
        }
        if (is_null($externalItemId) || (is_array($externalItemId) && empty($externalItemId))) {
            unset($this->ExternalItemId);
        } else {
            $this->ExternalItemId = $externalItemId;
        }
        return $this;
    }
    /**
     * Get ExternalTransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalTransactionDate()
    {
        return isset($this->ExternalTransactionDate) ? $this->ExternalTransactionDate : null;
    }
    /**
     * Set ExternalTransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalTransactionDate
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setExternalTransactionDate($externalTransactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($externalTransactionDate) && !is_string($externalTransactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTransactionDate, true), gettype($externalTransactionDate)), __LINE__);
        }
        if (is_null($externalTransactionDate) || (is_array($externalTransactionDate) && empty($externalTransactionDate))) {
            unset($this->ExternalTransactionDate);
        } else {
            $this->ExternalTransactionDate = $externalTransactionDate;
        }
        return $this;
    }
    /**
     * Get FileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileId()
    {
        return isset($this->FileId) ? $this->FileId : null;
    }
    /**
     * Set FileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileId
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setFileId($fileId = null)
    {
        // validation for constraint: string
        if (!is_null($fileId) && !is_string($fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileId, true), gettype($fileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fileId, true)), __LINE__);
        }
        if (is_null($fileId) || (is_array($fileId) && empty($fileId))) {
            unset($this->FileId);
        } else {
            $this->FileId = $fileId;
        }
        return $this;
    }
    /**
     * Get IndexInFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIndexInFile()
    {
        return isset($this->IndexInFile) ? $this->IndexInFile : null;
    }
    /**
     * Set IndexInFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $indexInFile
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setIndexInFile($indexInFile = null)
    {
        // validation for constraint: int
        if (!is_null($indexInFile) && !(is_int($indexInFile) || ctype_digit($indexInFile))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indexInFile, true), gettype($indexInFile)), __LINE__);
        }
        if (is_null($indexInFile) || (is_array($indexInFile) && empty($indexInFile))) {
            unset($this->IndexInFile);
        } else {
            $this->IndexInFile = $indexInFile;
        }
        return $this;
    }
    /**
     * Get ItemData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemData()
    {
        return isset($this->ItemData) ? $this->ItemData : null;
    }
    /**
     * Set ItemData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemData
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setItemData($itemData = null)
    {
        // validation for constraint: string
        if (!is_null($itemData) && !is_string($itemData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemData, true), gettype($itemData)), __LINE__);
        }
        if (is_null($itemData) || (is_array($itemData) && empty($itemData))) {
            unset($this->ItemData);
        } else {
            $this->ItemData = $itemData;
        }
        return $this;
    }
    /**
     * Get ItemPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemPrice()
    {
        return isset($this->ItemPrice) ? $this->ItemPrice : null;
    }
    /**
     * Set ItemPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemPrice
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setItemPrice(\patest\StructType\Money $itemPrice = null)
    {
        if (is_null($itemPrice) || (is_array($itemPrice) && empty($itemPrice))) {
            unset($this->ItemPrice);
        } else {
            $this->ItemPrice = $itemPrice;
        }
        return $this;
    }
    /**
     * Get ProviderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderName()
    {
        return isset($this->ProviderName) ? $this->ProviderName : null;
    }
    /**
     * Set ProviderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerName
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerName, true), gettype($providerName)), __LINE__);
        }
        if (is_null($providerName) || (is_array($providerName) && empty($providerName))) {
            unset($this->ProviderName);
        } else {
            $this->ProviderName = $providerName;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InboundBarCodeFileItemStatus::valueIsValid()
     * @uses \patest\EnumType\InboundBarCodeFileItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\AccessControl_InboundBarCodeFileItem
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InboundBarCodeFileItemStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InboundBarCodeFileItemStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\InboundBarCodeFileItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
