<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.HttpApiUser StructType
 * @subpackage Structs
 */
class AccessControl_HttpApiUser extends PersistableEntity
{
    /**
     * The Approved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Approved;
    /**
     * The LastPasswordChangeDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastPasswordChangeDate;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Login;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reason;
    /**
     * The RegistrationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationDate;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SessionId;
    /**
     * Constructor method for AccessControl.HttpApiUser
     * @uses AccessControl_HttpApiUser::setApproved()
     * @uses AccessControl_HttpApiUser::setLastPasswordChangeDate()
     * @uses AccessControl_HttpApiUser::setLogin()
     * @uses AccessControl_HttpApiUser::setPassword()
     * @uses AccessControl_HttpApiUser::setProvider()
     * @uses AccessControl_HttpApiUser::setReason()
     * @uses AccessControl_HttpApiUser::setRegistrationDate()
     * @uses AccessControl_HttpApiUser::setSessionId()
     * @param bool $approved
     * @param string $lastPasswordChangeDate
     * @param string $login
     * @param string $password
     * @param string $provider
     * @param string $reason
     * @param string $registrationDate
     * @param string $sessionId
     */
    public function __construct($approved = null, $lastPasswordChangeDate = null, $login = null, $password = null, $provider = null, $reason = null, $registrationDate = null, $sessionId = null)
    {
        $this
            ->setApproved($approved)
            ->setLastPasswordChangeDate($lastPasswordChangeDate)
            ->setLogin($login)
            ->setPassword($password)
            ->setProvider($provider)
            ->setReason($reason)
            ->setRegistrationDate($registrationDate)
            ->setSessionId($sessionId);
    }
    /**
     * Get Approved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApproved()
    {
        return isset($this->Approved) ? $this->Approved : null;
    }
    /**
     * Set Approved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $approved
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: boolean
        if (!is_null($approved) && !is_bool($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($approved, true), gettype($approved)), __LINE__);
        }
        if (is_null($approved) || (is_array($approved) && empty($approved))) {
            unset($this->Approved);
        } else {
            $this->Approved = $approved;
        }
        return $this;
    }
    /**
     * Get LastPasswordChangeDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastPasswordChangeDate()
    {
        return isset($this->LastPasswordChangeDate) ? $this->LastPasswordChangeDate : null;
    }
    /**
     * Set LastPasswordChangeDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastPasswordChangeDate
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setLastPasswordChangeDate($lastPasswordChangeDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastPasswordChangeDate) && !is_string($lastPasswordChangeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastPasswordChangeDate, true), gettype($lastPasswordChangeDate)), __LINE__);
        }
        if (is_null($lastPasswordChangeDate) || (is_array($lastPasswordChangeDate) && empty($lastPasswordChangeDate))) {
            unset($this->LastPasswordChangeDate);
        } else {
            $this->LastPasswordChangeDate = $lastPasswordChangeDate;
        }
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get Reason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReason()
    {
        return isset($this->Reason) ? $this->Reason : null;
    }
    /**
     * Set Reason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reason
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        if (is_null($reason) || (is_array($reason) && empty($reason))) {
            unset($this->Reason);
        } else {
            $this->Reason = $reason;
        }
        return $this;
    }
    /**
     * Get RegistrationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return isset($this->RegistrationDate) ? $this->RegistrationDate : null;
    }
    /**
     * Set RegistrationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationDate
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationDate, true), gettype($registrationDate)), __LINE__);
        }
        if (is_null($registrationDate) || (is_array($registrationDate) && empty($registrationDate))) {
            unset($this->RegistrationDate);
        } else {
            $this->RegistrationDate = $registrationDate;
        }
        return $this;
    }
    /**
     * Get SessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->SessionId) ? $this->SessionId : null;
    }
    /**
     * Set SessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionId
     * @return \patest\StructType\AccessControl_HttpApiUser
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->SessionId);
        } else {
            $this->SessionId = $sessionId;
        }
        return $this;
    }
}
