<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.EventAccessControlManager StructType
 * @subpackage Structs
 */
class AccessControl_EventAccessControlManager extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The BarcodesHistoryLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BarcodesHistoryLength;
    /**
     * The CurrentEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentEntries;
    /**
     * The CurrentEntriesFromOtherEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentEntriesFromOtherEvents;
    /**
     * The CurrentOuts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentOuts;
    /**
     * The EarliestAllowedEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EarliestAllowedEntry;
    /**
     * The EntriesToOtherEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EntriesToOtherEvents;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventLocalId;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventName;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The LastError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastError;
    /**
     * The LatestAllowedEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LatestAllowedEntry;
    /**
     * The LoadedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoadedDateTime;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OtherBarcodesLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OtherBarcodesLoaded;
    /**
     * The PendingUpdates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingUpdates;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The SubscriptionBarcodesLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionBarcodesLoaded;
    /**
     * The TicketBarcodesLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketBarcodesLoaded;
    /**
     * The TicketsLoaded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsLoaded;
    /**
     * The TotalAllowedEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalAllowedEntries;
    /**
     * The TotalScans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalScans;
    /**
     * The UnloadedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnloadedDateTime;
    /**
     * The VenueId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VenueId;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VenueName;
    /**
     * Constructor method for AccessControl.EventAccessControlManager
     * @uses AccessControl_EventAccessControlManager::setAccessControlSystemId()
     * @uses AccessControl_EventAccessControlManager::setBarcodesHistoryLength()
     * @uses AccessControl_EventAccessControlManager::setCurrentEntries()
     * @uses AccessControl_EventAccessControlManager::setCurrentEntriesFromOtherEvents()
     * @uses AccessControl_EventAccessControlManager::setCurrentOuts()
     * @uses AccessControl_EventAccessControlManager::setEarliestAllowedEntry()
     * @uses AccessControl_EventAccessControlManager::setEntriesToOtherEvents()
     * @uses AccessControl_EventAccessControlManager::setEventDate()
     * @uses AccessControl_EventAccessControlManager::setEventId()
     * @uses AccessControl_EventAccessControlManager::setEventLocalId()
     * @uses AccessControl_EventAccessControlManager::setEventName()
     * @uses AccessControl_EventAccessControlManager::setHallId()
     * @uses AccessControl_EventAccessControlManager::setHallName()
     * @uses AccessControl_EventAccessControlManager::setLastError()
     * @uses AccessControl_EventAccessControlManager::setLatestAllowedEntry()
     * @uses AccessControl_EventAccessControlManager::setLoadedDateTime()
     * @uses AccessControl_EventAccessControlManager::setOrganizationUnitId()
     * @uses AccessControl_EventAccessControlManager::setOtherBarcodesLoaded()
     * @uses AccessControl_EventAccessControlManager::setPendingUpdates()
     * @uses AccessControl_EventAccessControlManager::setState()
     * @uses AccessControl_EventAccessControlManager::setSubscriptionBarcodesLoaded()
     * @uses AccessControl_EventAccessControlManager::setTicketBarcodesLoaded()
     * @uses AccessControl_EventAccessControlManager::setTicketsLoaded()
     * @uses AccessControl_EventAccessControlManager::setTotalAllowedEntries()
     * @uses AccessControl_EventAccessControlManager::setTotalScans()
     * @uses AccessControl_EventAccessControlManager::setUnloadedDateTime()
     * @uses AccessControl_EventAccessControlManager::setVenueId()
     * @uses AccessControl_EventAccessControlManager::setVenueName()
     * @param string $accessControlSystemId
     * @param int $barcodesHistoryLength
     * @param int $currentEntries
     * @param int $currentEntriesFromOtherEvents
     * @param int $currentOuts
     * @param string $earliestAllowedEntry
     * @param int $entriesToOtherEvents
     * @param string $eventDate
     * @param string $eventId
     * @param int $eventLocalId
     * @param \patest\StructType\GlobalString $eventName
     * @param string $hallId
     * @param \patest\StructType\GlobalString $hallName
     * @param string $lastError
     * @param string $latestAllowedEntry
     * @param string $loadedDateTime
     * @param string $organizationUnitId
     * @param int $otherBarcodesLoaded
     * @param int $pendingUpdates
     * @param string $state
     * @param int $subscriptionBarcodesLoaded
     * @param int $ticketBarcodesLoaded
     * @param int $ticketsLoaded
     * @param int $totalAllowedEntries
     * @param int $totalScans
     * @param string $unloadedDateTime
     * @param string $venueId
     * @param \patest\StructType\GlobalString $venueName
     */
    public function __construct($accessControlSystemId = null, $barcodesHistoryLength = null, $currentEntries = null, $currentEntriesFromOtherEvents = null, $currentOuts = null, $earliestAllowedEntry = null, $entriesToOtherEvents = null, $eventDate = null, $eventId = null, $eventLocalId = null, \patest\StructType\GlobalString $eventName = null, $hallId = null, \patest\StructType\GlobalString $hallName = null, $lastError = null, $latestAllowedEntry = null, $loadedDateTime = null, $organizationUnitId = null, $otherBarcodesLoaded = null, $pendingUpdates = null, $state = null, $subscriptionBarcodesLoaded = null, $ticketBarcodesLoaded = null, $ticketsLoaded = null, $totalAllowedEntries = null, $totalScans = null, $unloadedDateTime = null, $venueId = null, \patest\StructType\GlobalString $venueName = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcodesHistoryLength($barcodesHistoryLength)
            ->setCurrentEntries($currentEntries)
            ->setCurrentEntriesFromOtherEvents($currentEntriesFromOtherEvents)
            ->setCurrentOuts($currentOuts)
            ->setEarliestAllowedEntry($earliestAllowedEntry)
            ->setEntriesToOtherEvents($entriesToOtherEvents)
            ->setEventDate($eventDate)
            ->setEventId($eventId)
            ->setEventLocalId($eventLocalId)
            ->setEventName($eventName)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setLastError($lastError)
            ->setLatestAllowedEntry($latestAllowedEntry)
            ->setLoadedDateTime($loadedDateTime)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOtherBarcodesLoaded($otherBarcodesLoaded)
            ->setPendingUpdates($pendingUpdates)
            ->setState($state)
            ->setSubscriptionBarcodesLoaded($subscriptionBarcodesLoaded)
            ->setTicketBarcodesLoaded($ticketBarcodesLoaded)
            ->setTicketsLoaded($ticketsLoaded)
            ->setTotalAllowedEntries($totalAllowedEntries)
            ->setTotalScans($totalScans)
            ->setUnloadedDateTime($unloadedDateTime)
            ->setVenueId($venueId)
            ->setVenueName($venueName);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get BarcodesHistoryLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBarcodesHistoryLength()
    {
        return isset($this->BarcodesHistoryLength) ? $this->BarcodesHistoryLength : null;
    }
    /**
     * Set BarcodesHistoryLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $barcodesHistoryLength
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setBarcodesHistoryLength($barcodesHistoryLength = null)
    {
        // validation for constraint: int
        if (!is_null($barcodesHistoryLength) && !(is_int($barcodesHistoryLength) || ctype_digit($barcodesHistoryLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodesHistoryLength, true), gettype($barcodesHistoryLength)), __LINE__);
        }
        if (is_null($barcodesHistoryLength) || (is_array($barcodesHistoryLength) && empty($barcodesHistoryLength))) {
            unset($this->BarcodesHistoryLength);
        } else {
            $this->BarcodesHistoryLength = $barcodesHistoryLength;
        }
        return $this;
    }
    /**
     * Get CurrentEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentEntries()
    {
        return isset($this->CurrentEntries) ? $this->CurrentEntries : null;
    }
    /**
     * Set CurrentEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentEntries
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setCurrentEntries($currentEntries = null)
    {
        // validation for constraint: int
        if (!is_null($currentEntries) && !(is_int($currentEntries) || ctype_digit($currentEntries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentEntries, true), gettype($currentEntries)), __LINE__);
        }
        if (is_null($currentEntries) || (is_array($currentEntries) && empty($currentEntries))) {
            unset($this->CurrentEntries);
        } else {
            $this->CurrentEntries = $currentEntries;
        }
        return $this;
    }
    /**
     * Get CurrentEntriesFromOtherEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentEntriesFromOtherEvents()
    {
        return isset($this->CurrentEntriesFromOtherEvents) ? $this->CurrentEntriesFromOtherEvents : null;
    }
    /**
     * Set CurrentEntriesFromOtherEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentEntriesFromOtherEvents
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setCurrentEntriesFromOtherEvents($currentEntriesFromOtherEvents = null)
    {
        // validation for constraint: int
        if (!is_null($currentEntriesFromOtherEvents) && !(is_int($currentEntriesFromOtherEvents) || ctype_digit($currentEntriesFromOtherEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentEntriesFromOtherEvents, true), gettype($currentEntriesFromOtherEvents)), __LINE__);
        }
        if (is_null($currentEntriesFromOtherEvents) || (is_array($currentEntriesFromOtherEvents) && empty($currentEntriesFromOtherEvents))) {
            unset($this->CurrentEntriesFromOtherEvents);
        } else {
            $this->CurrentEntriesFromOtherEvents = $currentEntriesFromOtherEvents;
        }
        return $this;
    }
    /**
     * Get CurrentOuts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentOuts()
    {
        return isset($this->CurrentOuts) ? $this->CurrentOuts : null;
    }
    /**
     * Set CurrentOuts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentOuts
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setCurrentOuts($currentOuts = null)
    {
        // validation for constraint: int
        if (!is_null($currentOuts) && !(is_int($currentOuts) || ctype_digit($currentOuts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentOuts, true), gettype($currentOuts)), __LINE__);
        }
        if (is_null($currentOuts) || (is_array($currentOuts) && empty($currentOuts))) {
            unset($this->CurrentOuts);
        } else {
            $this->CurrentOuts = $currentOuts;
        }
        return $this;
    }
    /**
     * Get EarliestAllowedEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEarliestAllowedEntry()
    {
        return isset($this->EarliestAllowedEntry) ? $this->EarliestAllowedEntry : null;
    }
    /**
     * Set EarliestAllowedEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $earliestAllowedEntry
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEarliestAllowedEntry($earliestAllowedEntry = null)
    {
        // validation for constraint: string
        if (!is_null($earliestAllowedEntry) && !is_string($earliestAllowedEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($earliestAllowedEntry, true), gettype($earliestAllowedEntry)), __LINE__);
        }
        if (is_null($earliestAllowedEntry) || (is_array($earliestAllowedEntry) && empty($earliestAllowedEntry))) {
            unset($this->EarliestAllowedEntry);
        } else {
            $this->EarliestAllowedEntry = $earliestAllowedEntry;
        }
        return $this;
    }
    /**
     * Get EntriesToOtherEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEntriesToOtherEvents()
    {
        return isset($this->EntriesToOtherEvents) ? $this->EntriesToOtherEvents : null;
    }
    /**
     * Set EntriesToOtherEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $entriesToOtherEvents
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEntriesToOtherEvents($entriesToOtherEvents = null)
    {
        // validation for constraint: int
        if (!is_null($entriesToOtherEvents) && !(is_int($entriesToOtherEvents) || ctype_digit($entriesToOtherEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entriesToOtherEvents, true), gettype($entriesToOtherEvents)), __LINE__);
        }
        if (is_null($entriesToOtherEvents) || (is_array($entriesToOtherEvents) && empty($entriesToOtherEvents))) {
            unset($this->EntriesToOtherEvents);
        } else {
            $this->EntriesToOtherEvents = $entriesToOtherEvents;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventLocalId()
    {
        return isset($this->EventLocalId) ? $this->EventLocalId : null;
    }
    /**
     * Set EventLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventLocalId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEventLocalId($eventLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($eventLocalId) && !(is_int($eventLocalId) || ctype_digit($eventLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventLocalId, true), gettype($eventLocalId)), __LINE__);
        }
        if (is_null($eventLocalId) || (is_array($eventLocalId) && empty($eventLocalId))) {
            unset($this->EventLocalId);
        } else {
            $this->EventLocalId = $eventLocalId;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventName
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setEventName(\patest\StructType\GlobalString $eventName = null)
    {
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get LastError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastError()
    {
        return isset($this->LastError) ? $this->LastError : null;
    }
    /**
     * Set LastError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastError
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setLastError($lastError = null)
    {
        // validation for constraint: string
        if (!is_null($lastError) && !is_string($lastError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastError, true), gettype($lastError)), __LINE__);
        }
        if (is_null($lastError) || (is_array($lastError) && empty($lastError))) {
            unset($this->LastError);
        } else {
            $this->LastError = $lastError;
        }
        return $this;
    }
    /**
     * Get LatestAllowedEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLatestAllowedEntry()
    {
        return isset($this->LatestAllowedEntry) ? $this->LatestAllowedEntry : null;
    }
    /**
     * Set LatestAllowedEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $latestAllowedEntry
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setLatestAllowedEntry($latestAllowedEntry = null)
    {
        // validation for constraint: string
        if (!is_null($latestAllowedEntry) && !is_string($latestAllowedEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestAllowedEntry, true), gettype($latestAllowedEntry)), __LINE__);
        }
        if (is_null($latestAllowedEntry) || (is_array($latestAllowedEntry) && empty($latestAllowedEntry))) {
            unset($this->LatestAllowedEntry);
        } else {
            $this->LatestAllowedEntry = $latestAllowedEntry;
        }
        return $this;
    }
    /**
     * Get LoadedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadedDateTime()
    {
        return isset($this->LoadedDateTime) ? $this->LoadedDateTime : null;
    }
    /**
     * Set LoadedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadedDateTime
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setLoadedDateTime($loadedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($loadedDateTime) && !is_string($loadedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadedDateTime, true), gettype($loadedDateTime)), __LINE__);
        }
        if (is_null($loadedDateTime) || (is_array($loadedDateTime) && empty($loadedDateTime))) {
            unset($this->LoadedDateTime);
        } else {
            $this->LoadedDateTime = $loadedDateTime;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OtherBarcodesLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOtherBarcodesLoaded()
    {
        return isset($this->OtherBarcodesLoaded) ? $this->OtherBarcodesLoaded : null;
    }
    /**
     * Set OtherBarcodesLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $otherBarcodesLoaded
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setOtherBarcodesLoaded($otherBarcodesLoaded = null)
    {
        // validation for constraint: int
        if (!is_null($otherBarcodesLoaded) && !(is_int($otherBarcodesLoaded) || ctype_digit($otherBarcodesLoaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($otherBarcodesLoaded, true), gettype($otherBarcodesLoaded)), __LINE__);
        }
        if (is_null($otherBarcodesLoaded) || (is_array($otherBarcodesLoaded) && empty($otherBarcodesLoaded))) {
            unset($this->OtherBarcodesLoaded);
        } else {
            $this->OtherBarcodesLoaded = $otherBarcodesLoaded;
        }
        return $this;
    }
    /**
     * Get PendingUpdates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingUpdates()
    {
        return isset($this->PendingUpdates) ? $this->PendingUpdates : null;
    }
    /**
     * Set PendingUpdates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingUpdates
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setPendingUpdates($pendingUpdates = null)
    {
        // validation for constraint: int
        if (!is_null($pendingUpdates) && !(is_int($pendingUpdates) || ctype_digit($pendingUpdates))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingUpdates, true), gettype($pendingUpdates)), __LINE__);
        }
        if (is_null($pendingUpdates) || (is_array($pendingUpdates) && empty($pendingUpdates))) {
            unset($this->PendingUpdates);
        } else {
            $this->PendingUpdates = $pendingUpdates;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventAccessControlManagerState::valueIsValid()
     * @uses \patest\EnumType\EventAccessControlManagerState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventAccessControlManagerState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventAccessControlManagerState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EventAccessControlManagerState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get SubscriptionBarcodesLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionBarcodesLoaded()
    {
        return isset($this->SubscriptionBarcodesLoaded) ? $this->SubscriptionBarcodesLoaded : null;
    }
    /**
     * Set SubscriptionBarcodesLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionBarcodesLoaded
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setSubscriptionBarcodesLoaded($subscriptionBarcodesLoaded = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionBarcodesLoaded) && !(is_int($subscriptionBarcodesLoaded) || ctype_digit($subscriptionBarcodesLoaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionBarcodesLoaded, true), gettype($subscriptionBarcodesLoaded)), __LINE__);
        }
        if (is_null($subscriptionBarcodesLoaded) || (is_array($subscriptionBarcodesLoaded) && empty($subscriptionBarcodesLoaded))) {
            unset($this->SubscriptionBarcodesLoaded);
        } else {
            $this->SubscriptionBarcodesLoaded = $subscriptionBarcodesLoaded;
        }
        return $this;
    }
    /**
     * Get TicketBarcodesLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketBarcodesLoaded()
    {
        return isset($this->TicketBarcodesLoaded) ? $this->TicketBarcodesLoaded : null;
    }
    /**
     * Set TicketBarcodesLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketBarcodesLoaded
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setTicketBarcodesLoaded($ticketBarcodesLoaded = null)
    {
        // validation for constraint: int
        if (!is_null($ticketBarcodesLoaded) && !(is_int($ticketBarcodesLoaded) || ctype_digit($ticketBarcodesLoaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketBarcodesLoaded, true), gettype($ticketBarcodesLoaded)), __LINE__);
        }
        if (is_null($ticketBarcodesLoaded) || (is_array($ticketBarcodesLoaded) && empty($ticketBarcodesLoaded))) {
            unset($this->TicketBarcodesLoaded);
        } else {
            $this->TicketBarcodesLoaded = $ticketBarcodesLoaded;
        }
        return $this;
    }
    /**
     * Get TicketsLoaded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsLoaded()
    {
        return isset($this->TicketsLoaded) ? $this->TicketsLoaded : null;
    }
    /**
     * Set TicketsLoaded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsLoaded
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setTicketsLoaded($ticketsLoaded = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsLoaded) && !(is_int($ticketsLoaded) || ctype_digit($ticketsLoaded))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsLoaded, true), gettype($ticketsLoaded)), __LINE__);
        }
        if (is_null($ticketsLoaded) || (is_array($ticketsLoaded) && empty($ticketsLoaded))) {
            unset($this->TicketsLoaded);
        } else {
            $this->TicketsLoaded = $ticketsLoaded;
        }
        return $this;
    }
    /**
     * Get TotalAllowedEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalAllowedEntries()
    {
        return isset($this->TotalAllowedEntries) ? $this->TotalAllowedEntries : null;
    }
    /**
     * Set TotalAllowedEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalAllowedEntries
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setTotalAllowedEntries($totalAllowedEntries = null)
    {
        // validation for constraint: int
        if (!is_null($totalAllowedEntries) && !(is_int($totalAllowedEntries) || ctype_digit($totalAllowedEntries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAllowedEntries, true), gettype($totalAllowedEntries)), __LINE__);
        }
        if (is_null($totalAllowedEntries) || (is_array($totalAllowedEntries) && empty($totalAllowedEntries))) {
            unset($this->TotalAllowedEntries);
        } else {
            $this->TotalAllowedEntries = $totalAllowedEntries;
        }
        return $this;
    }
    /**
     * Get TotalScans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalScans()
    {
        return isset($this->TotalScans) ? $this->TotalScans : null;
    }
    /**
     * Set TotalScans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalScans
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setTotalScans($totalScans = null)
    {
        // validation for constraint: int
        if (!is_null($totalScans) && !(is_int($totalScans) || ctype_digit($totalScans))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalScans, true), gettype($totalScans)), __LINE__);
        }
        if (is_null($totalScans) || (is_array($totalScans) && empty($totalScans))) {
            unset($this->TotalScans);
        } else {
            $this->TotalScans = $totalScans;
        }
        return $this;
    }
    /**
     * Get UnloadedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnloadedDateTime()
    {
        return isset($this->UnloadedDateTime) ? $this->UnloadedDateTime : null;
    }
    /**
     * Set UnloadedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unloadedDateTime
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setUnloadedDateTime($unloadedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($unloadedDateTime) && !is_string($unloadedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unloadedDateTime, true), gettype($unloadedDateTime)), __LINE__);
        }
        if (is_null($unloadedDateTime) || (is_array($unloadedDateTime) && empty($unloadedDateTime))) {
            unset($this->UnloadedDateTime);
        } else {
            $this->UnloadedDateTime = $unloadedDateTime;
        }
        return $this;
    }
    /**
     * Get VenueId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueId()
    {
        return isset($this->VenueId) ? $this->VenueId : null;
    }
    /**
     * Set VenueId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueId
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setVenueId($venueId = null)
    {
        // validation for constraint: string
        if (!is_null($venueId) && !is_string($venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueId, true), gettype($venueId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($venueId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $venueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($venueId, true)), __LINE__);
        }
        if (is_null($venueId) || (is_array($venueId) && empty($venueId))) {
            unset($this->VenueId);
        } else {
            $this->VenueId = $venueId;
        }
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $venueName
     * @return \patest\StructType\AccessControl_EventAccessControlManager
     */
    public function setVenueName(\patest\StructType\GlobalString $venueName = null)
    {
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
}
