<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeUsage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessControl.BarcodeUsage
 * @subpackage Structs
 */
class AccessControl_BarcodeUsage extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The ApplicationClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationClientId;
    /**
     * The ApplicationPlatform
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationPlatform;
    /**
     * The ApplicationVersion
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationVersion;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeApplication
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeApplication;
    /**
     * The BarcodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeId;
    /**
     * The BarcodeMetadata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeMetadata;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DeviceGroupId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceGroupId;
    /**
     * The DeviceGroupName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceGroupName;
    /**
     * The DoNotReportToAuthoritativeSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotReportToAuthoritativeSystem;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ExternalAreaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalAreaId;
    /**
     * The ExternalAreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalAreaName;
    /**
     * The ExternalDoorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalDoorId;
    /**
     * The ExternalReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReferenceId;
    /**
     * The ExternalRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExternalRequestId;
    /**
     * The ExternalScannerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalScannerName;
    /**
     * The ExternalServiceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalServiceId;
    /**
     * The FailureReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonCode;
    /**
     * The FailureReasonDescr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FailureReasonDescr;
    /**
     * The GateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GateId;
    /**
     * The IsFirstScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstScan;
    /**
     * The IsOfflineScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOfflineScan;
    /**
     * The IsReportedToAuthoritativeSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReportedToAuthoritativeSystem;
    /**
     * The IsVirtualScan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVirtualScan;
    /**
     * The JointMembershipMemberId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JointMembershipMemberId;
    /**
     * The JointMembershipMemberType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipMemberType;
    /**
     * The OtpCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtpCode;
    /**
     * The OtpValidationStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtpValidationStatus;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * The ReportedByAccessControlSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportedByAccessControlSystemName;
    /**
     * The ReportedByComputerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportedByComputerName;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleId;
    /**
     * The RuleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleName;
    /**
     * The SameShowOriginalEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SameShowOriginalEventId;
    /**
     * The ScanDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanDate;
    /**
     * The ScannedByAccessControlSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScannedByAccessControlSystemName;
    /**
     * The ScannedByComputerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScannedByComputerName;
    /**
     * The ScannerControlledEntranceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:ControlledEntrance
     * @var string
     */
    public $ScannerControlledEntranceType;
    /**
     * The ScannerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannerId;
    /**
     * The ScanningSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningSessionId;
    /**
     * The ScanSucceeded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScanSucceeded;
    /**
     * The ServerSignature
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerSignature;
    /**
     * The ServerTimestamp
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerTimestamp;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The TurnstileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TurnstileId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserId;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for AccessControl.BarcodeUsage
     * @uses AccessControl_BarcodeUsage::setAccessControlSystemId()
     * @uses AccessControl_BarcodeUsage::setAction()
     * @uses AccessControl_BarcodeUsage::setApplicationClientId()
     * @uses AccessControl_BarcodeUsage::setApplicationPlatform()
     * @uses AccessControl_BarcodeUsage::setApplicationVersion()
     * @uses AccessControl_BarcodeUsage::setAreaId()
     * @uses AccessControl_BarcodeUsage::setBarcode()
     * @uses AccessControl_BarcodeUsage::setBarcodeApplication()
     * @uses AccessControl_BarcodeUsage::setBarcodeId()
     * @uses AccessControl_BarcodeUsage::setBarcodeMetadata()
     * @uses AccessControl_BarcodeUsage::setClientId()
     * @uses AccessControl_BarcodeUsage::setDeviceGroupId()
     * @uses AccessControl_BarcodeUsage::setDeviceGroupName()
     * @uses AccessControl_BarcodeUsage::setDoNotReportToAuthoritativeSystem()
     * @uses AccessControl_BarcodeUsage::setEventId()
     * @uses AccessControl_BarcodeUsage::setExternalAreaId()
     * @uses AccessControl_BarcodeUsage::setExternalAreaName()
     * @uses AccessControl_BarcodeUsage::setExternalDoorId()
     * @uses AccessControl_BarcodeUsage::setExternalReferenceId()
     * @uses AccessControl_BarcodeUsage::setExternalRequestId()
     * @uses AccessControl_BarcodeUsage::setExternalScannerName()
     * @uses AccessControl_BarcodeUsage::setExternalServiceId()
     * @uses AccessControl_BarcodeUsage::setFailureReasonCode()
     * @uses AccessControl_BarcodeUsage::setFailureReasonDescr()
     * @uses AccessControl_BarcodeUsage::setGateId()
     * @uses AccessControl_BarcodeUsage::setIsFirstScan()
     * @uses AccessControl_BarcodeUsage::setIsOfflineScan()
     * @uses AccessControl_BarcodeUsage::setIsReportedToAuthoritativeSystem()
     * @uses AccessControl_BarcodeUsage::setIsVirtualScan()
     * @uses AccessControl_BarcodeUsage::setJointMembershipMemberId()
     * @uses AccessControl_BarcodeUsage::setJointMembershipMemberType()
     * @uses AccessControl_BarcodeUsage::setOtpCode()
     * @uses AccessControl_BarcodeUsage::setOtpValidationStatus()
     * @uses AccessControl_BarcodeUsage::setReferencedEntityId()
     * @uses AccessControl_BarcodeUsage::setReferencedEntityName()
     * @uses AccessControl_BarcodeUsage::setReportedByAccessControlSystemName()
     * @uses AccessControl_BarcodeUsage::setReportedByComputerName()
     * @uses AccessControl_BarcodeUsage::setRuleId()
     * @uses AccessControl_BarcodeUsage::setRuleName()
     * @uses AccessControl_BarcodeUsage::setSameShowOriginalEventId()
     * @uses AccessControl_BarcodeUsage::setScanDate()
     * @uses AccessControl_BarcodeUsage::setScannedByAccessControlSystemName()
     * @uses AccessControl_BarcodeUsage::setScannedByComputerName()
     * @uses AccessControl_BarcodeUsage::setScannerControlledEntranceType()
     * @uses AccessControl_BarcodeUsage::setScannerId()
     * @uses AccessControl_BarcodeUsage::setScanningSessionId()
     * @uses AccessControl_BarcodeUsage::setScanSucceeded()
     * @uses AccessControl_BarcodeUsage::setServerSignature()
     * @uses AccessControl_BarcodeUsage::setServerTimestamp()
     * @uses AccessControl_BarcodeUsage::setShowId()
     * @uses AccessControl_BarcodeUsage::setTicketId()
     * @uses AccessControl_BarcodeUsage::setTurnstileId()
     * @uses AccessControl_BarcodeUsage::setUserId()
     * @uses AccessControl_BarcodeUsage::setXmlContainer()
     * @param string $accessControlSystemId
     * @param string $action
     * @param string $applicationClientId
     * @param string $applicationPlatform
     * @param string $applicationVersion
     * @param string $areaId
     * @param string $barcode
     * @param string $barcodeApplication
     * @param string $barcodeId
     * @param string $barcodeMetadata
     * @param string $clientId
     * @param string $deviceGroupId
     * @param string $deviceGroupName
     * @param bool $doNotReportToAuthoritativeSystem
     * @param string $eventId
     * @param string $externalAreaId
     * @param string $externalAreaName
     * @param string $externalDoorId
     * @param string $externalReferenceId
     * @param string $externalRequestId
     * @param string $externalScannerName
     * @param string $externalServiceId
     * @param string $failureReasonCode
     * @param string $failureReasonDescr
     * @param string $gateId
     * @param bool $isFirstScan
     * @param bool $isOfflineScan
     * @param bool $isReportedToAuthoritativeSystem
     * @param bool $isVirtualScan
     * @param string $jointMembershipMemberId
     * @param string $jointMembershipMemberType
     * @param string $otpCode
     * @param string $otpValidationStatus
     * @param string $referencedEntityId
     * @param string $referencedEntityName
     * @param string $reportedByAccessControlSystemName
     * @param string $reportedByComputerName
     * @param string $ruleId
     * @param string $ruleName
     * @param string $sameShowOriginalEventId
     * @param string $scanDate
     * @param string $scannedByAccessControlSystemName
     * @param string $scannedByComputerName
     * @param string $scannerControlledEntranceType
     * @param string $scannerId
     * @param string $scanningSessionId
     * @param bool $scanSucceeded
     * @param string $serverSignature
     * @param string $serverTimestamp
     * @param string $showId
     * @param string $ticketId
     * @param string $turnstileId
     * @param string $userId
     * @param string $xmlContainer
     */
    public function __construct($accessControlSystemId = null, $action = null, $applicationClientId = null, $applicationPlatform = null, $applicationVersion = null, $areaId = null, $barcode = null, $barcodeApplication = null, $barcodeId = null, $barcodeMetadata = null, $clientId = null, $deviceGroupId = null, $deviceGroupName = null, $doNotReportToAuthoritativeSystem = null, $eventId = null, $externalAreaId = null, $externalAreaName = null, $externalDoorId = null, $externalReferenceId = null, $externalRequestId = null, $externalScannerName = null, $externalServiceId = null, $failureReasonCode = null, $failureReasonDescr = null, $gateId = null, $isFirstScan = null, $isOfflineScan = null, $isReportedToAuthoritativeSystem = null, $isVirtualScan = null, $jointMembershipMemberId = null, $jointMembershipMemberType = null, $otpCode = null, $otpValidationStatus = null, $referencedEntityId = null, $referencedEntityName = null, $reportedByAccessControlSystemName = null, $reportedByComputerName = null, $ruleId = null, $ruleName = null, $sameShowOriginalEventId = null, $scanDate = null, $scannedByAccessControlSystemName = null, $scannedByComputerName = null, $scannerControlledEntranceType = null, $scannerId = null, $scanningSessionId = null, $scanSucceeded = null, $serverSignature = null, $serverTimestamp = null, $showId = null, $ticketId = null, $turnstileId = null, $userId = null, $xmlContainer = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAction($action)
            ->setApplicationClientId($applicationClientId)
            ->setApplicationPlatform($applicationPlatform)
            ->setApplicationVersion($applicationVersion)
            ->setAreaId($areaId)
            ->setBarcode($barcode)
            ->setBarcodeApplication($barcodeApplication)
            ->setBarcodeId($barcodeId)
            ->setBarcodeMetadata($barcodeMetadata)
            ->setClientId($clientId)
            ->setDeviceGroupId($deviceGroupId)
            ->setDeviceGroupName($deviceGroupName)
            ->setDoNotReportToAuthoritativeSystem($doNotReportToAuthoritativeSystem)
            ->setEventId($eventId)
            ->setExternalAreaId($externalAreaId)
            ->setExternalAreaName($externalAreaName)
            ->setExternalDoorId($externalDoorId)
            ->setExternalReferenceId($externalReferenceId)
            ->setExternalRequestId($externalRequestId)
            ->setExternalScannerName($externalScannerName)
            ->setExternalServiceId($externalServiceId)
            ->setFailureReasonCode($failureReasonCode)
            ->setFailureReasonDescr($failureReasonDescr)
            ->setGateId($gateId)
            ->setIsFirstScan($isFirstScan)
            ->setIsOfflineScan($isOfflineScan)
            ->setIsReportedToAuthoritativeSystem($isReportedToAuthoritativeSystem)
            ->setIsVirtualScan($isVirtualScan)
            ->setJointMembershipMemberId($jointMembershipMemberId)
            ->setJointMembershipMemberType($jointMembershipMemberType)
            ->setOtpCode($otpCode)
            ->setOtpValidationStatus($otpValidationStatus)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityName($referencedEntityName)
            ->setReportedByAccessControlSystemName($reportedByAccessControlSystemName)
            ->setReportedByComputerName($reportedByComputerName)
            ->setRuleId($ruleId)
            ->setRuleName($ruleName)
            ->setSameShowOriginalEventId($sameShowOriginalEventId)
            ->setScanDate($scanDate)
            ->setScannedByAccessControlSystemName($scannedByAccessControlSystemName)
            ->setScannedByComputerName($scannedByComputerName)
            ->setScannerControlledEntranceType($scannerControlledEntranceType)
            ->setScannerId($scannerId)
            ->setScanningSessionId($scanningSessionId)
            ->setScanSucceeded($scanSucceeded)
            ->setServerSignature($serverSignature)
            ->setServerTimestamp($serverTimestamp)
            ->setShowId($showId)
            ->setTicketId($ticketId)
            ->setTurnstileId($turnstileId)
            ->setUserId($userId)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeScanAction::valueIsValid()
     * @uses \patest\EnumType\BarcodeScanAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeScanAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeScanAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\BarcodeScanAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get ApplicationClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationClientId()
    {
        return isset($this->ApplicationClientId) ? $this->ApplicationClientId : null;
    }
    /**
     * Set ApplicationClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationClientId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setApplicationClientId($applicationClientId = null)
    {
        // validation for constraint: string
        if (!is_null($applicationClientId) && !is_string($applicationClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationClientId, true), gettype($applicationClientId)), __LINE__);
        }
        if (is_null($applicationClientId) || (is_array($applicationClientId) && empty($applicationClientId))) {
            unset($this->ApplicationClientId);
        } else {
            $this->ApplicationClientId = $applicationClientId;
        }
        return $this;
    }
    /**
     * Get ApplicationPlatform value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationPlatform()
    {
        return isset($this->ApplicationPlatform) ? $this->ApplicationPlatform : null;
    }
    /**
     * Set ApplicationPlatform value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationPlatform
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setApplicationPlatform($applicationPlatform = null)
    {
        // validation for constraint: string
        if (!is_null($applicationPlatform) && !is_string($applicationPlatform)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationPlatform, true), gettype($applicationPlatform)), __LINE__);
        }
        if (is_null($applicationPlatform) || (is_array($applicationPlatform) && empty($applicationPlatform))) {
            unset($this->ApplicationPlatform);
        } else {
            $this->ApplicationPlatform = $applicationPlatform;
        }
        return $this;
    }
    /**
     * Get ApplicationVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationVersion()
    {
        return isset($this->ApplicationVersion) ? $this->ApplicationVersion : null;
    }
    /**
     * Set ApplicationVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationVersion
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setApplicationVersion($applicationVersion = null)
    {
        // validation for constraint: string
        if (!is_null($applicationVersion) && !is_string($applicationVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationVersion, true), gettype($applicationVersion)), __LINE__);
        }
        if (is_null($applicationVersion) || (is_array($applicationVersion) && empty($applicationVersion))) {
            unset($this->ApplicationVersion);
        } else {
            $this->ApplicationVersion = $applicationVersion;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeApplication()
    {
        return isset($this->BarcodeApplication) ? $this->BarcodeApplication : null;
    }
    /**
     * Set BarcodeApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeApplication
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setBarcodeApplication($barcodeApplication = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeApplication) && !is_string($barcodeApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeApplication, true), gettype($barcodeApplication)), __LINE__);
        }
        if (is_null($barcodeApplication) || (is_array($barcodeApplication) && empty($barcodeApplication))) {
            unset($this->BarcodeApplication);
        } else {
            $this->BarcodeApplication = $barcodeApplication;
        }
        return $this;
    }
    /**
     * Get BarcodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeId()
    {
        return isset($this->BarcodeId) ? $this->BarcodeId : null;
    }
    /**
     * Set BarcodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setBarcodeId($barcodeId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeId) && !is_string($barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeId, true), gettype($barcodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeId, true)), __LINE__);
        }
        if (is_null($barcodeId) || (is_array($barcodeId) && empty($barcodeId))) {
            unset($this->BarcodeId);
        } else {
            $this->BarcodeId = $barcodeId;
        }
        return $this;
    }
    /**
     * Get BarcodeMetadata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeMetadata()
    {
        return isset($this->BarcodeMetadata) ? $this->BarcodeMetadata : null;
    }
    /**
     * Set BarcodeMetadata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeMetadata
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setBarcodeMetadata($barcodeMetadata = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeMetadata) && !is_string($barcodeMetadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeMetadata, true), gettype($barcodeMetadata)), __LINE__);
        }
        if (is_null($barcodeMetadata) || (is_array($barcodeMetadata) && empty($barcodeMetadata))) {
            unset($this->BarcodeMetadata);
        } else {
            $this->BarcodeMetadata = $barcodeMetadata;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DeviceGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceGroupId()
    {
        return isset($this->DeviceGroupId) ? $this->DeviceGroupId : null;
    }
    /**
     * Set DeviceGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceGroupId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setDeviceGroupId($deviceGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceGroupId) && !is_string($deviceGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceGroupId, true), gettype($deviceGroupId)), __LINE__);
        }
        if (is_null($deviceGroupId) || (is_array($deviceGroupId) && empty($deviceGroupId))) {
            unset($this->DeviceGroupId);
        } else {
            $this->DeviceGroupId = $deviceGroupId;
        }
        return $this;
    }
    /**
     * Get DeviceGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceGroupName()
    {
        return isset($this->DeviceGroupName) ? $this->DeviceGroupName : null;
    }
    /**
     * Set DeviceGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceGroupName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setDeviceGroupName($deviceGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceGroupName) && !is_string($deviceGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceGroupName, true), gettype($deviceGroupName)), __LINE__);
        }
        if (is_null($deviceGroupName) || (is_array($deviceGroupName) && empty($deviceGroupName))) {
            unset($this->DeviceGroupName);
        } else {
            $this->DeviceGroupName = $deviceGroupName;
        }
        return $this;
    }
    /**
     * Get DoNotReportToAuthoritativeSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotReportToAuthoritativeSystem()
    {
        return isset($this->DoNotReportToAuthoritativeSystem) ? $this->DoNotReportToAuthoritativeSystem : null;
    }
    /**
     * Set DoNotReportToAuthoritativeSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotReportToAuthoritativeSystem
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setDoNotReportToAuthoritativeSystem($doNotReportToAuthoritativeSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotReportToAuthoritativeSystem) && !is_bool($doNotReportToAuthoritativeSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotReportToAuthoritativeSystem, true), gettype($doNotReportToAuthoritativeSystem)), __LINE__);
        }
        if (is_null($doNotReportToAuthoritativeSystem) || (is_array($doNotReportToAuthoritativeSystem) && empty($doNotReportToAuthoritativeSystem))) {
            unset($this->DoNotReportToAuthoritativeSystem);
        } else {
            $this->DoNotReportToAuthoritativeSystem = $doNotReportToAuthoritativeSystem;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ExternalAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalAreaId()
    {
        return isset($this->ExternalAreaId) ? $this->ExternalAreaId : null;
    }
    /**
     * Set ExternalAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalAreaId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalAreaId($externalAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($externalAreaId) && !is_string($externalAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAreaId, true), gettype($externalAreaId)), __LINE__);
        }
        if (is_null($externalAreaId) || (is_array($externalAreaId) && empty($externalAreaId))) {
            unset($this->ExternalAreaId);
        } else {
            $this->ExternalAreaId = $externalAreaId;
        }
        return $this;
    }
    /**
     * Get ExternalAreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalAreaName()
    {
        return isset($this->ExternalAreaName) ? $this->ExternalAreaName : null;
    }
    /**
     * Set ExternalAreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalAreaName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalAreaName($externalAreaName = null)
    {
        // validation for constraint: string
        if (!is_null($externalAreaName) && !is_string($externalAreaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalAreaName, true), gettype($externalAreaName)), __LINE__);
        }
        if (is_null($externalAreaName) || (is_array($externalAreaName) && empty($externalAreaName))) {
            unset($this->ExternalAreaName);
        } else {
            $this->ExternalAreaName = $externalAreaName;
        }
        return $this;
    }
    /**
     * Get ExternalDoorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDoorId()
    {
        return isset($this->ExternalDoorId) ? $this->ExternalDoorId : null;
    }
    /**
     * Set ExternalDoorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDoorId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalDoorId($externalDoorId = null)
    {
        // validation for constraint: string
        if (!is_null($externalDoorId) && !is_string($externalDoorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDoorId, true), gettype($externalDoorId)), __LINE__);
        }
        if (is_null($externalDoorId) || (is_array($externalDoorId) && empty($externalDoorId))) {
            unset($this->ExternalDoorId);
        } else {
            $this->ExternalDoorId = $externalDoorId;
        }
        return $this;
    }
    /**
     * Get ExternalReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReferenceId()
    {
        return isset($this->ExternalReferenceId) ? $this->ExternalReferenceId : null;
    }
    /**
     * Set ExternalReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReferenceId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalReferenceId($externalReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($externalReferenceId) && !is_string($externalReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReferenceId, true), gettype($externalReferenceId)), __LINE__);
        }
        if (is_null($externalReferenceId) || (is_array($externalReferenceId) && empty($externalReferenceId))) {
            unset($this->ExternalReferenceId);
        } else {
            $this->ExternalReferenceId = $externalReferenceId;
        }
        return $this;
    }
    /**
     * Get ExternalRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalRequestId()
    {
        return isset($this->ExternalRequestId) ? $this->ExternalRequestId : null;
    }
    /**
     * Set ExternalRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalRequestId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalRequestId($externalRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($externalRequestId) && !is_string($externalRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalRequestId, true), gettype($externalRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($externalRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $externalRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($externalRequestId, true)), __LINE__);
        }
        if (is_null($externalRequestId) || (is_array($externalRequestId) && empty($externalRequestId))) {
            unset($this->ExternalRequestId);
        } else {
            $this->ExternalRequestId = $externalRequestId;
        }
        return $this;
    }
    /**
     * Get ExternalScannerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalScannerName()
    {
        return isset($this->ExternalScannerName) ? $this->ExternalScannerName : null;
    }
    /**
     * Set ExternalScannerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalScannerName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalScannerName($externalScannerName = null)
    {
        // validation for constraint: string
        if (!is_null($externalScannerName) && !is_string($externalScannerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalScannerName, true), gettype($externalScannerName)), __LINE__);
        }
        if (is_null($externalScannerName) || (is_array($externalScannerName) && empty($externalScannerName))) {
            unset($this->ExternalScannerName);
        } else {
            $this->ExternalScannerName = $externalScannerName;
        }
        return $this;
    }
    /**
     * Get ExternalServiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalServiceId()
    {
        return isset($this->ExternalServiceId) ? $this->ExternalServiceId : null;
    }
    /**
     * Set ExternalServiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalServiceId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setExternalServiceId($externalServiceId = null)
    {
        // validation for constraint: string
        if (!is_null($externalServiceId) && !is_string($externalServiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalServiceId, true), gettype($externalServiceId)), __LINE__);
        }
        if (is_null($externalServiceId) || (is_array($externalServiceId) && empty($externalServiceId))) {
            unset($this->ExternalServiceId);
        } else {
            $this->ExternalServiceId = $externalServiceId;
        }
        return $this;
    }
    /**
     * Get FailureReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonCode()
    {
        return isset($this->FailureReasonCode) ? $this->FailureReasonCode : null;
    }
    /**
     * Set FailureReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonCode
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setFailureReasonCode($failureReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonCode) && !is_string($failureReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonCode, true), gettype($failureReasonCode)), __LINE__);
        }
        if (is_null($failureReasonCode) || (is_array($failureReasonCode) && empty($failureReasonCode))) {
            unset($this->FailureReasonCode);
        } else {
            $this->FailureReasonCode = $failureReasonCode;
        }
        return $this;
    }
    /**
     * Get FailureReasonDescr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFailureReasonDescr()
    {
        return isset($this->FailureReasonDescr) ? $this->FailureReasonDescr : null;
    }
    /**
     * Set FailureReasonDescr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $failureReasonDescr
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setFailureReasonDescr($failureReasonDescr = null)
    {
        // validation for constraint: string
        if (!is_null($failureReasonDescr) && !is_string($failureReasonDescr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failureReasonDescr, true), gettype($failureReasonDescr)), __LINE__);
        }
        if (is_null($failureReasonDescr) || (is_array($failureReasonDescr) && empty($failureReasonDescr))) {
            unset($this->FailureReasonDescr);
        } else {
            $this->FailureReasonDescr = $failureReasonDescr;
        }
        return $this;
    }
    /**
     * Get GateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateId()
    {
        return isset($this->GateId) ? $this->GateId : null;
    }
    /**
     * Set GateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setGateId($gateId = null)
    {
        // validation for constraint: string
        if (!is_null($gateId) && !is_string($gateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateId, true), gettype($gateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gateId, true)), __LINE__);
        }
        if (is_null($gateId) || (is_array($gateId) && empty($gateId))) {
            unset($this->GateId);
        } else {
            $this->GateId = $gateId;
        }
        return $this;
    }
    /**
     * Get IsFirstScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstScan()
    {
        return isset($this->IsFirstScan) ? $this->IsFirstScan : null;
    }
    /**
     * Set IsFirstScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstScan
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setIsFirstScan($isFirstScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstScan) && !is_bool($isFirstScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstScan, true), gettype($isFirstScan)), __LINE__);
        }
        if (is_null($isFirstScan) || (is_array($isFirstScan) && empty($isFirstScan))) {
            unset($this->IsFirstScan);
        } else {
            $this->IsFirstScan = $isFirstScan;
        }
        return $this;
    }
    /**
     * Get IsOfflineScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOfflineScan()
    {
        return isset($this->IsOfflineScan) ? $this->IsOfflineScan : null;
    }
    /**
     * Set IsOfflineScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOfflineScan
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setIsOfflineScan($isOfflineScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOfflineScan) && !is_bool($isOfflineScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOfflineScan, true), gettype($isOfflineScan)), __LINE__);
        }
        if (is_null($isOfflineScan) || (is_array($isOfflineScan) && empty($isOfflineScan))) {
            unset($this->IsOfflineScan);
        } else {
            $this->IsOfflineScan = $isOfflineScan;
        }
        return $this;
    }
    /**
     * Get IsReportedToAuthoritativeSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReportedToAuthoritativeSystem()
    {
        return isset($this->IsReportedToAuthoritativeSystem) ? $this->IsReportedToAuthoritativeSystem : null;
    }
    /**
     * Set IsReportedToAuthoritativeSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReportedToAuthoritativeSystem
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setIsReportedToAuthoritativeSystem($isReportedToAuthoritativeSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReportedToAuthoritativeSystem) && !is_bool($isReportedToAuthoritativeSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReportedToAuthoritativeSystem, true), gettype($isReportedToAuthoritativeSystem)), __LINE__);
        }
        if (is_null($isReportedToAuthoritativeSystem) || (is_array($isReportedToAuthoritativeSystem) && empty($isReportedToAuthoritativeSystem))) {
            unset($this->IsReportedToAuthoritativeSystem);
        } else {
            $this->IsReportedToAuthoritativeSystem = $isReportedToAuthoritativeSystem;
        }
        return $this;
    }
    /**
     * Get IsVirtualScan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVirtualScan()
    {
        return isset($this->IsVirtualScan) ? $this->IsVirtualScan : null;
    }
    /**
     * Set IsVirtualScan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVirtualScan
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setIsVirtualScan($isVirtualScan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVirtualScan) && !is_bool($isVirtualScan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVirtualScan, true), gettype($isVirtualScan)), __LINE__);
        }
        if (is_null($isVirtualScan) || (is_array($isVirtualScan) && empty($isVirtualScan))) {
            unset($this->IsVirtualScan);
        } else {
            $this->IsVirtualScan = $isVirtualScan;
        }
        return $this;
    }
    /**
     * Get JointMembershipMemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipMemberId()
    {
        return isset($this->JointMembershipMemberId) ? $this->JointMembershipMemberId : null;
    }
    /**
     * Set JointMembershipMemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $jointMembershipMemberId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setJointMembershipMemberId($jointMembershipMemberId = null)
    {
        // validation for constraint: string
        if (!is_null($jointMembershipMemberId) && !is_string($jointMembershipMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jointMembershipMemberId, true), gettype($jointMembershipMemberId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jointMembershipMemberId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jointMembershipMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jointMembershipMemberId, true)), __LINE__);
        }
        if (is_null($jointMembershipMemberId) || (is_array($jointMembershipMemberId) && empty($jointMembershipMemberId))) {
            unset($this->JointMembershipMemberId);
        } else {
            $this->JointMembershipMemberId = $jointMembershipMemberId;
        }
        return $this;
    }
    /**
     * Get JointMembershipMemberType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipMemberType()
    {
        return isset($this->JointMembershipMemberType) ? $this->JointMembershipMemberType : null;
    }
    /**
     * Set JointMembershipMemberType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipMemberType::valueIsValid()
     * @uses \patest\EnumType\JointMembershipMemberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipMemberType
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setJointMembershipMemberType($jointMembershipMemberType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipMemberType::valueIsValid($jointMembershipMemberType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipMemberType', is_array($jointMembershipMemberType) ? implode(', ', $jointMembershipMemberType) : var_export($jointMembershipMemberType, true), implode(', ', \patest\EnumType\JointMembershipMemberType::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipMemberType) || (is_array($jointMembershipMemberType) && empty($jointMembershipMemberType))) {
            unset($this->JointMembershipMemberType);
        } else {
            $this->JointMembershipMemberType = $jointMembershipMemberType;
        }
        return $this;
    }
    /**
     * Get OtpCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtpCode()
    {
        return isset($this->OtpCode) ? $this->OtpCode : null;
    }
    /**
     * Set OtpCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otpCode
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setOtpCode($otpCode = null)
    {
        // validation for constraint: string
        if (!is_null($otpCode) && !is_string($otpCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otpCode, true), gettype($otpCode)), __LINE__);
        }
        if (is_null($otpCode) || (is_array($otpCode) && empty($otpCode))) {
            unset($this->OtpCode);
        } else {
            $this->OtpCode = $otpCode;
        }
        return $this;
    }
    /**
     * Get OtpValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtpValidationStatus()
    {
        return isset($this->OtpValidationStatus) ? $this->OtpValidationStatus : null;
    }
    /**
     * Set OtpValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otpValidationStatus
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setOtpValidationStatus($otpValidationStatus = null)
    {
        // validation for constraint: string
        if (!is_null($otpValidationStatus) && !is_string($otpValidationStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otpValidationStatus, true), gettype($otpValidationStatus)), __LINE__);
        }
        if (is_null($otpValidationStatus) || (is_array($otpValidationStatus) && empty($otpValidationStatus))) {
            unset($this->OtpValidationStatus);
        } else {
            $this->OtpValidationStatus = $otpValidationStatus;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
    /**
     * Get ReportedByAccessControlSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportedByAccessControlSystemName()
    {
        return isset($this->ReportedByAccessControlSystemName) ? $this->ReportedByAccessControlSystemName : null;
    }
    /**
     * Set ReportedByAccessControlSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportedByAccessControlSystemName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setReportedByAccessControlSystemName($reportedByAccessControlSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($reportedByAccessControlSystemName) && !is_string($reportedByAccessControlSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedByAccessControlSystemName, true), gettype($reportedByAccessControlSystemName)), __LINE__);
        }
        if (is_null($reportedByAccessControlSystemName) || (is_array($reportedByAccessControlSystemName) && empty($reportedByAccessControlSystemName))) {
            unset($this->ReportedByAccessControlSystemName);
        } else {
            $this->ReportedByAccessControlSystemName = $reportedByAccessControlSystemName;
        }
        return $this;
    }
    /**
     * Get ReportedByComputerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportedByComputerName()
    {
        return isset($this->ReportedByComputerName) ? $this->ReportedByComputerName : null;
    }
    /**
     * Set ReportedByComputerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportedByComputerName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setReportedByComputerName($reportedByComputerName = null)
    {
        // validation for constraint: string
        if (!is_null($reportedByComputerName) && !is_string($reportedByComputerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedByComputerName, true), gettype($reportedByComputerName)), __LINE__);
        }
        if (is_null($reportedByComputerName) || (is_array($reportedByComputerName) && empty($reportedByComputerName))) {
            unset($this->ReportedByComputerName);
        } else {
            $this->ReportedByComputerName = $reportedByComputerName;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
    /**
     * Get RuleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleName()
    {
        return isset($this->RuleName) ? $this->RuleName : null;
    }
    /**
     * Set RuleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setRuleName($ruleName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleName) && !is_string($ruleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleName, true), gettype($ruleName)), __LINE__);
        }
        if (is_null($ruleName) || (is_array($ruleName) && empty($ruleName))) {
            unset($this->RuleName);
        } else {
            $this->RuleName = $ruleName;
        }
        return $this;
    }
    /**
     * Get SameShowOriginalEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSameShowOriginalEventId()
    {
        return isset($this->SameShowOriginalEventId) ? $this->SameShowOriginalEventId : null;
    }
    /**
     * Set SameShowOriginalEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sameShowOriginalEventId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setSameShowOriginalEventId($sameShowOriginalEventId = null)
    {
        // validation for constraint: string
        if (!is_null($sameShowOriginalEventId) && !is_string($sameShowOriginalEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sameShowOriginalEventId, true), gettype($sameShowOriginalEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sameShowOriginalEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sameShowOriginalEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sameShowOriginalEventId, true)), __LINE__);
        }
        if (is_null($sameShowOriginalEventId) || (is_array($sameShowOriginalEventId) && empty($sameShowOriginalEventId))) {
            unset($this->SameShowOriginalEventId);
        } else {
            $this->SameShowOriginalEventId = $sameShowOriginalEventId;
        }
        return $this;
    }
    /**
     * Get ScanDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanDate()
    {
        return isset($this->ScanDate) ? $this->ScanDate : null;
    }
    /**
     * Set ScanDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanDate
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScanDate($scanDate = null)
    {
        // validation for constraint: string
        if (!is_null($scanDate) && !is_string($scanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanDate, true), gettype($scanDate)), __LINE__);
        }
        if (is_null($scanDate) || (is_array($scanDate) && empty($scanDate))) {
            unset($this->ScanDate);
        } else {
            $this->ScanDate = $scanDate;
        }
        return $this;
    }
    /**
     * Get ScannedByAccessControlSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannedByAccessControlSystemName()
    {
        return isset($this->ScannedByAccessControlSystemName) ? $this->ScannedByAccessControlSystemName : null;
    }
    /**
     * Set ScannedByAccessControlSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannedByAccessControlSystemName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScannedByAccessControlSystemName($scannedByAccessControlSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($scannedByAccessControlSystemName) && !is_string($scannedByAccessControlSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannedByAccessControlSystemName, true), gettype($scannedByAccessControlSystemName)), __LINE__);
        }
        if (is_null($scannedByAccessControlSystemName) || (is_array($scannedByAccessControlSystemName) && empty($scannedByAccessControlSystemName))) {
            unset($this->ScannedByAccessControlSystemName);
        } else {
            $this->ScannedByAccessControlSystemName = $scannedByAccessControlSystemName;
        }
        return $this;
    }
    /**
     * Get ScannedByComputerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannedByComputerName()
    {
        return isset($this->ScannedByComputerName) ? $this->ScannedByComputerName : null;
    }
    /**
     * Set ScannedByComputerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannedByComputerName
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScannedByComputerName($scannedByComputerName = null)
    {
        // validation for constraint: string
        if (!is_null($scannedByComputerName) && !is_string($scannedByComputerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannedByComputerName, true), gettype($scannedByComputerName)), __LINE__);
        }
        if (is_null($scannedByComputerName) || (is_array($scannedByComputerName) && empty($scannedByComputerName))) {
            unset($this->ScannedByComputerName);
        } else {
            $this->ScannedByComputerName = $scannedByComputerName;
        }
        return $this;
    }
    /**
     * Get ScannerControlledEntranceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerControlledEntranceType()
    {
        return isset($this->ScannerControlledEntranceType) ? $this->ScannerControlledEntranceType : null;
    }
    /**
     * Set ScannerControlledEntranceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerControlledEntranceType
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScannerControlledEntranceType($scannerControlledEntranceType = null)
    {
        // validation for constraint: string
        if (!is_null($scannerControlledEntranceType) && !is_string($scannerControlledEntranceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerControlledEntranceType, true), gettype($scannerControlledEntranceType)), __LINE__);
        }
        if (is_null($scannerControlledEntranceType) || (is_array($scannerControlledEntranceType) && empty($scannerControlledEntranceType))) {
            unset($this->ScannerControlledEntranceType);
        } else {
            $this->ScannerControlledEntranceType = $scannerControlledEntranceType;
        }
        return $this;
    }
    /**
     * Get ScannerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannerId()
    {
        return isset($this->ScannerId) ? $this->ScannerId : null;
    }
    /**
     * Set ScannerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannerId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScannerId($scannerId = null)
    {
        // validation for constraint: string
        if (!is_null($scannerId) && !is_string($scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerId, true), gettype($scannerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannerId, true)), __LINE__);
        }
        if (is_null($scannerId) || (is_array($scannerId) && empty($scannerId))) {
            unset($this->ScannerId);
        } else {
            $this->ScannerId = $scannerId;
        }
        return $this;
    }
    /**
     * Get ScanningSessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanningSessionId()
    {
        return isset($this->ScanningSessionId) ? $this->ScanningSessionId : null;
    }
    /**
     * Set ScanningSessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scanningSessionId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScanningSessionId($scanningSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($scanningSessionId) && !is_string($scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningSessionId, true), gettype($scanningSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningSessionId, true)), __LINE__);
        }
        if (is_null($scanningSessionId) || (is_array($scanningSessionId) && empty($scanningSessionId))) {
            unset($this->ScanningSessionId);
        } else {
            $this->ScanningSessionId = $scanningSessionId;
        }
        return $this;
    }
    /**
     * Get ScanSucceeded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScanSucceeded()
    {
        return isset($this->ScanSucceeded) ? $this->ScanSucceeded : null;
    }
    /**
     * Set ScanSucceeded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scanSucceeded
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setScanSucceeded($scanSucceeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($scanSucceeded) && !is_bool($scanSucceeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scanSucceeded, true), gettype($scanSucceeded)), __LINE__);
        }
        if (is_null($scanSucceeded) || (is_array($scanSucceeded) && empty($scanSucceeded))) {
            unset($this->ScanSucceeded);
        } else {
            $this->ScanSucceeded = $scanSucceeded;
        }
        return $this;
    }
    /**
     * Get ServerSignature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerSignature()
    {
        return isset($this->ServerSignature) ? $this->ServerSignature : null;
    }
    /**
     * Set ServerSignature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serverSignature
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setServerSignature($serverSignature = null)
    {
        // validation for constraint: string
        if (!is_null($serverSignature) && !is_string($serverSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverSignature, true), gettype($serverSignature)), __LINE__);
        }
        if (is_null($serverSignature) || (is_array($serverSignature) && empty($serverSignature))) {
            unset($this->ServerSignature);
        } else {
            $this->ServerSignature = $serverSignature;
        }
        return $this;
    }
    /**
     * Get ServerTimestamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerTimestamp()
    {
        return isset($this->ServerTimestamp) ? $this->ServerTimestamp : null;
    }
    /**
     * Set ServerTimestamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serverTimestamp
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setServerTimestamp($serverTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($serverTimestamp) && !is_string($serverTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serverTimestamp, true), gettype($serverTimestamp)), __LINE__);
        }
        if (is_null($serverTimestamp) || (is_array($serverTimestamp) && empty($serverTimestamp))) {
            unset($this->ServerTimestamp);
        } else {
            $this->ServerTimestamp = $serverTimestamp;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get TurnstileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileId()
    {
        return isset($this->TurnstileId) ? $this->TurnstileId : null;
    }
    /**
     * Set TurnstileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setTurnstileId($turnstileId = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileId) && !is_string($turnstileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileId, true), gettype($turnstileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($turnstileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $turnstileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($turnstileId, true)), __LINE__);
        }
        if (is_null($turnstileId) || (is_array($turnstileId) && empty($turnstileId))) {
            unset($this->TurnstileId);
        } else {
            $this->TurnstileId = $turnstileId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\AccessControl_BarcodeUsage
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
