<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.MembershipEventInfo StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_MembershipEventInfo extends AnyEntity
{
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCode;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventEntriesCount;
    /**
     * The EventTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTimeZone;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The ShowEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowEntriesCount;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * The ValidityDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates
     */
    public $ValidityDates;
    /**
     * The ValidityDatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidityDatesSummary;
    /**
     * Constructor method for AccessControl.BarcodeInfo.MembershipEventInfo
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setEventCode()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setEventDate()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setEventEntriesCount()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setEventTimeZone()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setHallName()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setShowEntriesCount()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setShowName()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setValidityDates()
     * @uses AccessControl_BarcodeInfo_MembershipEventInfo::setValidityDatesSummary()
     * @param int $eventCode
     * @param string $eventDate
     * @param int $eventEntriesCount
     * @param string $eventTimeZone
     * @param \patest\StructType\GlobalString $hallName
     * @param int $showEntriesCount
     * @param \patest\StructType\GlobalString $showName
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates
     * @param string $validityDatesSummary
     */
    public function __construct($eventCode = null, $eventDate = null, $eventEntriesCount = null, $eventTimeZone = null, \patest\StructType\GlobalString $hallName = null, $showEntriesCount = null, \patest\StructType\GlobalString $showName = null, \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates = null, $validityDatesSummary = null)
    {
        $this
            ->setEventCode($eventCode)
            ->setEventDate($eventDate)
            ->setEventEntriesCount($eventEntriesCount)
            ->setEventTimeZone($eventTimeZone)
            ->setHallName($hallName)
            ->setShowEntriesCount($showEntriesCount)
            ->setShowName($showName)
            ->setValidityDates($validityDates)
            ->setValidityDatesSummary($validityDatesSummary);
    }
    /**
     * Get EventCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCode()
    {
        return isset($this->EventCode) ? $this->EventCode : null;
    }
    /**
     * Set EventCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCode
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: int
        if (!is_null($eventCode) && !(is_int($eventCode) || ctype_digit($eventCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        if (is_null($eventCode) || (is_array($eventCode) && empty($eventCode))) {
            unset($this->EventCode);
        } else {
            $this->EventCode = $eventCode;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventEntriesCount()
    {
        return isset($this->EventEntriesCount) ? $this->EventEntriesCount : null;
    }
    /**
     * Set EventEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventEntriesCount
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setEventEntriesCount($eventEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventEntriesCount) && !(is_int($eventEntriesCount) || ctype_digit($eventEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventEntriesCount, true), gettype($eventEntriesCount)), __LINE__);
        }
        if (is_null($eventEntriesCount) || (is_array($eventEntriesCount) && empty($eventEntriesCount))) {
            unset($this->EventEntriesCount);
        } else {
            $this->EventEntriesCount = $eventEntriesCount;
        }
        return $this;
    }
    /**
     * Get EventTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTimeZone()
    {
        return isset($this->EventTimeZone) ? $this->EventTimeZone : null;
    }
    /**
     * Set EventTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTimeZone
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setEventTimeZone($eventTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($eventTimeZone) && !is_string($eventTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTimeZone, true), gettype($eventTimeZone)), __LINE__);
        }
        if (is_null($eventTimeZone) || (is_array($eventTimeZone) && empty($eventTimeZone))) {
            unset($this->EventTimeZone);
        } else {
            $this->EventTimeZone = $eventTimeZone;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get ShowEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowEntriesCount()
    {
        return isset($this->ShowEntriesCount) ? $this->ShowEntriesCount : null;
    }
    /**
     * Set ShowEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showEntriesCount
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setShowEntriesCount($showEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($showEntriesCount) && !(is_int($showEntriesCount) || ctype_digit($showEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showEntriesCount, true), gettype($showEntriesCount)), __LINE__);
        }
        if (is_null($showEntriesCount) || (is_array($showEntriesCount) && empty($showEntriesCount))) {
            unset($this->ShowEntriesCount);
        } else {
            $this->ShowEntriesCount = $showEntriesCount;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get ValidityDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates|null
     */
    public function getValidityDates()
    {
        return isset($this->ValidityDates) ? $this->ValidityDates : null;
    }
    /**
     * Set ValidityDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setValidityDates(\patest\StructType\RecordSetOfAccessControl_BarcodeValidityDates $validityDates = null)
    {
        if (is_null($validityDates) || (is_array($validityDates) && empty($validityDates))) {
            unset($this->ValidityDates);
        } else {
            $this->ValidityDates = $validityDates;
        }
        return $this;
    }
    /**
     * Get ValidityDatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidityDatesSummary()
    {
        return isset($this->ValidityDatesSummary) ? $this->ValidityDatesSummary : null;
    }
    /**
     * Set ValidityDatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validityDatesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_MembershipEventInfo
     */
    public function setValidityDatesSummary($validityDatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($validityDatesSummary) && !is_string($validityDatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validityDatesSummary, true), gettype($validityDatesSummary)), __LINE__);
        }
        if (is_null($validityDatesSummary) || (is_array($validityDatesSummary) && empty($validityDatesSummary))) {
            unset($this->ValidityDatesSummary);
        } else {
            $this->ValidityDatesSummary = $validityDatesSummary;
        }
        return $this;
    }
}
