<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.JointMembershipInfo StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_JointMembershipInfo extends AnyEntity
{
    /**
     * The ExtrasPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtrasPriceTypeId;
    /**
     * The ExtrasPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtrasPriceTypeName;
    /**
     * The GuestsPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuestsPriceTypeId;
    /**
     * The GuestsPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GuestsPriceTypeName;
    /**
     * The IsSingleCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSingleCard;
    /**
     * The MaxNumberOfExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfExtras;
    /**
     * The MaxNumberOfGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfGuests;
    /**
     * The MaxNumberOfOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfOwners;
    /**
     * The Members
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo
     */
    public $Members;
    /**
     * The NumberOfExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtras;
    /**
     * The NumberOfExtrasWithoutClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtrasWithoutClient;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The NumberOfOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwners;
    /**
     * The OwnersPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnersPriceTypeId;
    /**
     * The OwnersPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnersPriceTypeName;
    /**
     * The ScannedMemberId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannedMemberId;
    /**
     * Constructor method for AccessControl.BarcodeInfo.JointMembershipInfo
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setExtrasPriceTypeId()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setExtrasPriceTypeName()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setGuestsPriceTypeId()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setGuestsPriceTypeName()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setIsSingleCard()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setMaxNumberOfExtras()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setMaxNumberOfGuests()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setMaxNumberOfOwners()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setMembers()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setNumberOfExtras()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setNumberOfExtrasWithoutClient()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setNumberOfGuests()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setNumberOfOwners()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setOwnersPriceTypeId()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setOwnersPriceTypeName()
     * @uses AccessControl_BarcodeInfo_JointMembershipInfo::setScannedMemberId()
     * @param string $extrasPriceTypeId
     * @param string $extrasPriceTypeName
     * @param string $guestsPriceTypeId
     * @param string $guestsPriceTypeName
     * @param bool $isSingleCard
     * @param int $maxNumberOfExtras
     * @param int $maxNumberOfGuests
     * @param int $maxNumberOfOwners
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo $members
     * @param int $numberOfExtras
     * @param int $numberOfExtrasWithoutClient
     * @param int $numberOfGuests
     * @param int $numberOfOwners
     * @param string $ownersPriceTypeId
     * @param string $ownersPriceTypeName
     * @param string $scannedMemberId
     */
    public function __construct($extrasPriceTypeId = null, $extrasPriceTypeName = null, $guestsPriceTypeId = null, $guestsPriceTypeName = null, $isSingleCard = null, $maxNumberOfExtras = null, $maxNumberOfGuests = null, $maxNumberOfOwners = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo $members = null, $numberOfExtras = null, $numberOfExtrasWithoutClient = null, $numberOfGuests = null, $numberOfOwners = null, $ownersPriceTypeId = null, $ownersPriceTypeName = null, $scannedMemberId = null)
    {
        $this
            ->setExtrasPriceTypeId($extrasPriceTypeId)
            ->setExtrasPriceTypeName($extrasPriceTypeName)
            ->setGuestsPriceTypeId($guestsPriceTypeId)
            ->setGuestsPriceTypeName($guestsPriceTypeName)
            ->setIsSingleCard($isSingleCard)
            ->setMaxNumberOfExtras($maxNumberOfExtras)
            ->setMaxNumberOfGuests($maxNumberOfGuests)
            ->setMaxNumberOfOwners($maxNumberOfOwners)
            ->setMembers($members)
            ->setNumberOfExtras($numberOfExtras)
            ->setNumberOfExtrasWithoutClient($numberOfExtrasWithoutClient)
            ->setNumberOfGuests($numberOfGuests)
            ->setNumberOfOwners($numberOfOwners)
            ->setOwnersPriceTypeId($ownersPriceTypeId)
            ->setOwnersPriceTypeName($ownersPriceTypeName)
            ->setScannedMemberId($scannedMemberId);
    }
    /**
     * Get ExtrasPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeId()
    {
        return isset($this->ExtrasPriceTypeId) ? $this->ExtrasPriceTypeId : null;
    }
    /**
     * Set ExtrasPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeId
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setExtrasPriceTypeId($extrasPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeId) && !is_string($extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeId, true), gettype($extrasPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extrasPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extrasPriceTypeId, true)), __LINE__);
        }
        if (is_null($extrasPriceTypeId) || (is_array($extrasPriceTypeId) && empty($extrasPriceTypeId))) {
            unset($this->ExtrasPriceTypeId);
        } else {
            $this->ExtrasPriceTypeId = $extrasPriceTypeId;
        }
        return $this;
    }
    /**
     * Get ExtrasPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeName()
    {
        return isset($this->ExtrasPriceTypeName) ? $this->ExtrasPriceTypeName : null;
    }
    /**
     * Set ExtrasPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeName
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setExtrasPriceTypeName($extrasPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeName) && !is_string($extrasPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeName, true), gettype($extrasPriceTypeName)), __LINE__);
        }
        if (is_null($extrasPriceTypeName) || (is_array($extrasPriceTypeName) && empty($extrasPriceTypeName))) {
            unset($this->ExtrasPriceTypeName);
        } else {
            $this->ExtrasPriceTypeName = $extrasPriceTypeName;
        }
        return $this;
    }
    /**
     * Get GuestsPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestsPriceTypeId()
    {
        return isset($this->GuestsPriceTypeId) ? $this->GuestsPriceTypeId : null;
    }
    /**
     * Set GuestsPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestsPriceTypeId
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setGuestsPriceTypeId($guestsPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guestsPriceTypeId) && !is_string($guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestsPriceTypeId, true), gettype($guestsPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guestsPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guestsPriceTypeId, true)), __LINE__);
        }
        if (is_null($guestsPriceTypeId) || (is_array($guestsPriceTypeId) && empty($guestsPriceTypeId))) {
            unset($this->GuestsPriceTypeId);
        } else {
            $this->GuestsPriceTypeId = $guestsPriceTypeId;
        }
        return $this;
    }
    /**
     * Get GuestsPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestsPriceTypeName()
    {
        return isset($this->GuestsPriceTypeName) ? $this->GuestsPriceTypeName : null;
    }
    /**
     * Set GuestsPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestsPriceTypeName
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setGuestsPriceTypeName($guestsPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($guestsPriceTypeName) && !is_string($guestsPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestsPriceTypeName, true), gettype($guestsPriceTypeName)), __LINE__);
        }
        if (is_null($guestsPriceTypeName) || (is_array($guestsPriceTypeName) && empty($guestsPriceTypeName))) {
            unset($this->GuestsPriceTypeName);
        } else {
            $this->GuestsPriceTypeName = $guestsPriceTypeName;
        }
        return $this;
    }
    /**
     * Get IsSingleCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSingleCard()
    {
        return isset($this->IsSingleCard) ? $this->IsSingleCard : null;
    }
    /**
     * Set IsSingleCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSingleCard
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setIsSingleCard($isSingleCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSingleCard) && !is_bool($isSingleCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSingleCard, true), gettype($isSingleCard)), __LINE__);
        }
        if (is_null($isSingleCard) || (is_array($isSingleCard) && empty($isSingleCard))) {
            unset($this->IsSingleCard);
        } else {
            $this->IsSingleCard = $isSingleCard;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfExtras()
    {
        return isset($this->MaxNumberOfExtras) ? $this->MaxNumberOfExtras : null;
    }
    /**
     * Set MaxNumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfExtras
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setMaxNumberOfExtras($maxNumberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfExtras) && !(is_int($maxNumberOfExtras) || ctype_digit($maxNumberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfExtras, true), gettype($maxNumberOfExtras)), __LINE__);
        }
        if (is_null($maxNumberOfExtras) || (is_array($maxNumberOfExtras) && empty($maxNumberOfExtras))) {
            unset($this->MaxNumberOfExtras);
        } else {
            $this->MaxNumberOfExtras = $maxNumberOfExtras;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfGuests()
    {
        return isset($this->MaxNumberOfGuests) ? $this->MaxNumberOfGuests : null;
    }
    /**
     * Set MaxNumberOfGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfGuests
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setMaxNumberOfGuests($maxNumberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfGuests) && !(is_int($maxNumberOfGuests) || ctype_digit($maxNumberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfGuests, true), gettype($maxNumberOfGuests)), __LINE__);
        }
        if (is_null($maxNumberOfGuests) || (is_array($maxNumberOfGuests) && empty($maxNumberOfGuests))) {
            unset($this->MaxNumberOfGuests);
        } else {
            $this->MaxNumberOfGuests = $maxNumberOfGuests;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfOwners()
    {
        return isset($this->MaxNumberOfOwners) ? $this->MaxNumberOfOwners : null;
    }
    /**
     * Set MaxNumberOfOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfOwners
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setMaxNumberOfOwners($maxNumberOfOwners = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfOwners) && !(is_int($maxNumberOfOwners) || ctype_digit($maxNumberOfOwners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfOwners, true), gettype($maxNumberOfOwners)), __LINE__);
        }
        if (is_null($maxNumberOfOwners) || (is_array($maxNumberOfOwners) && empty($maxNumberOfOwners))) {
            unset($this->MaxNumberOfOwners);
        } else {
            $this->MaxNumberOfOwners = $maxNumberOfOwners;
        }
        return $this;
    }
    /**
     * Get Members value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo|null
     */
    public function getMembers()
    {
        return isset($this->Members) ? $this->Members : null;
    }
    /**
     * Set Members value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo $members
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setMembers(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_JointMembershipMemberInfo $members = null)
    {
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->Members);
        } else {
            $this->Members = $members;
        }
        return $this;
    }
    /**
     * Get NumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtras()
    {
        return isset($this->NumberOfExtras) ? $this->NumberOfExtras : null;
    }
    /**
     * Set NumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtras
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setNumberOfExtras($numberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtras) && !(is_int($numberOfExtras) || ctype_digit($numberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtras, true), gettype($numberOfExtras)), __LINE__);
        }
        if (is_null($numberOfExtras) || (is_array($numberOfExtras) && empty($numberOfExtras))) {
            unset($this->NumberOfExtras);
        } else {
            $this->NumberOfExtras = $numberOfExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfExtrasWithoutClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtrasWithoutClient()
    {
        return isset($this->NumberOfExtrasWithoutClient) ? $this->NumberOfExtrasWithoutClient : null;
    }
    /**
     * Set NumberOfExtrasWithoutClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtrasWithoutClient
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setNumberOfExtrasWithoutClient($numberOfExtrasWithoutClient = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtrasWithoutClient) && !(is_int($numberOfExtrasWithoutClient) || ctype_digit($numberOfExtrasWithoutClient))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtrasWithoutClient, true), gettype($numberOfExtrasWithoutClient)), __LINE__);
        }
        if (is_null($numberOfExtrasWithoutClient) || (is_array($numberOfExtrasWithoutClient) && empty($numberOfExtrasWithoutClient))) {
            unset($this->NumberOfExtrasWithoutClient);
        } else {
            $this->NumberOfExtrasWithoutClient = $numberOfExtrasWithoutClient;
        }
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return isset($this->NumberOfGuests) ? $this->NumberOfGuests : null;
    }
    /**
     * Set NumberOfGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfGuests
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        if (is_null($numberOfGuests) || (is_array($numberOfGuests) && empty($numberOfGuests))) {
            unset($this->NumberOfGuests);
        } else {
            $this->NumberOfGuests = $numberOfGuests;
        }
        return $this;
    }
    /**
     * Get NumberOfOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwners()
    {
        return isset($this->NumberOfOwners) ? $this->NumberOfOwners : null;
    }
    /**
     * Set NumberOfOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwners
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setNumberOfOwners($numberOfOwners = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwners) && !(is_int($numberOfOwners) || ctype_digit($numberOfOwners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwners, true), gettype($numberOfOwners)), __LINE__);
        }
        if (is_null($numberOfOwners) || (is_array($numberOfOwners) && empty($numberOfOwners))) {
            unset($this->NumberOfOwners);
        } else {
            $this->NumberOfOwners = $numberOfOwners;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeId()
    {
        return isset($this->OwnersPriceTypeId) ? $this->OwnersPriceTypeId : null;
    }
    /**
     * Set OwnersPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeId
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setOwnersPriceTypeId($ownersPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeId) && !is_string($ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeId, true), gettype($ownersPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownersPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownersPriceTypeId, true)), __LINE__);
        }
        if (is_null($ownersPriceTypeId) || (is_array($ownersPriceTypeId) && empty($ownersPriceTypeId))) {
            unset($this->OwnersPriceTypeId);
        } else {
            $this->OwnersPriceTypeId = $ownersPriceTypeId;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeName()
    {
        return isset($this->OwnersPriceTypeName) ? $this->OwnersPriceTypeName : null;
    }
    /**
     * Set OwnersPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeName
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setOwnersPriceTypeName($ownersPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeName) && !is_string($ownersPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeName, true), gettype($ownersPriceTypeName)), __LINE__);
        }
        if (is_null($ownersPriceTypeName) || (is_array($ownersPriceTypeName) && empty($ownersPriceTypeName))) {
            unset($this->OwnersPriceTypeName);
        } else {
            $this->OwnersPriceTypeName = $ownersPriceTypeName;
        }
        return $this;
    }
    /**
     * Get ScannedMemberId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannedMemberId()
    {
        return isset($this->ScannedMemberId) ? $this->ScannedMemberId : null;
    }
    /**
     * Set ScannedMemberId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannedMemberId
     * @return \patest\StructType\AccessControl_BarcodeInfo_JointMembershipInfo
     */
    public function setScannedMemberId($scannedMemberId = null)
    {
        // validation for constraint: string
        if (!is_null($scannedMemberId) && !is_string($scannedMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannedMemberId, true), gettype($scannedMemberId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannedMemberId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannedMemberId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannedMemberId, true)), __LINE__);
        }
        if (is_null($scannedMemberId) || (is_array($scannedMemberId) && empty($scannedMemberId))) {
            unset($this->ScannedMemberId);
        } else {
            $this->ScannedMemberId = $scannedMemberId;
        }
        return $this;
    }
}
