<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.GroupTicket StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_GroupTicket extends AccessControl_BarcodeInfo_NonTerminalEntity
{
    /**
     * The CurrentEntriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentEntriesCount;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCode;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventTimeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventTimeZone;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ShowName;
    /**
     * Constructor method for AccessControl.BarcodeInfo.GroupTicket
     * @uses AccessControl_BarcodeInfo_GroupTicket::setCurrentEntriesCount()
     * @uses AccessControl_BarcodeInfo_GroupTicket::setEventCode()
     * @uses AccessControl_BarcodeInfo_GroupTicket::setEventDate()
     * @uses AccessControl_BarcodeInfo_GroupTicket::setEventTimeZone()
     * @uses AccessControl_BarcodeInfo_GroupTicket::setHallName()
     * @uses AccessControl_BarcodeInfo_GroupTicket::setShowName()
     * @param int $currentEntriesCount
     * @param int $eventCode
     * @param string $eventDate
     * @param string $eventTimeZone
     * @param \patest\StructType\GlobalString $hallName
     * @param \patest\StructType\GlobalString $showName
     */
    public function __construct($currentEntriesCount = null, $eventCode = null, $eventDate = null, $eventTimeZone = null, \patest\StructType\GlobalString $hallName = null, \patest\StructType\GlobalString $showName = null)
    {
        $this
            ->setCurrentEntriesCount($currentEntriesCount)
            ->setEventCode($eventCode)
            ->setEventDate($eventDate)
            ->setEventTimeZone($eventTimeZone)
            ->setHallName($hallName)
            ->setShowName($showName);
    }
    /**
     * Get CurrentEntriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentEntriesCount()
    {
        return isset($this->CurrentEntriesCount) ? $this->CurrentEntriesCount : null;
    }
    /**
     * Set CurrentEntriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentEntriesCount
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setCurrentEntriesCount($currentEntriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($currentEntriesCount) && !(is_int($currentEntriesCount) || ctype_digit($currentEntriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentEntriesCount, true), gettype($currentEntriesCount)), __LINE__);
        }
        if (is_null($currentEntriesCount) || (is_array($currentEntriesCount) && empty($currentEntriesCount))) {
            unset($this->CurrentEntriesCount);
        } else {
            $this->CurrentEntriesCount = $currentEntriesCount;
        }
        return $this;
    }
    /**
     * Get EventCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCode()
    {
        return isset($this->EventCode) ? $this->EventCode : null;
    }
    /**
     * Set EventCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCode
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: int
        if (!is_null($eventCode) && !(is_int($eventCode) || ctype_digit($eventCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        if (is_null($eventCode) || (is_array($eventCode) && empty($eventCode))) {
            unset($this->EventCode);
        } else {
            $this->EventCode = $eventCode;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventTimeZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventTimeZone()
    {
        return isset($this->EventTimeZone) ? $this->EventTimeZone : null;
    }
    /**
     * Set EventTimeZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventTimeZone
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setEventTimeZone($eventTimeZone = null)
    {
        // validation for constraint: string
        if (!is_null($eventTimeZone) && !is_string($eventTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventTimeZone, true), gettype($eventTimeZone)), __LINE__);
        }
        if (is_null($eventTimeZone) || (is_array($eventTimeZone) && empty($eventTimeZone))) {
            unset($this->EventTimeZone);
        } else {
            $this->EventTimeZone = $eventTimeZone;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $showName
     * @return \patest\StructType\AccessControl_BarcodeInfo_GroupTicket
     */
    public function setShowName(\patest\StructType\GlobalString $showName = null)
    {
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
}
