<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.AccessControlSystemCounter StructType
 * @subpackage Structs
 */
class AccessControl_AccessControlSystemCounter extends PersistableEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The CounterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CounterId;
    /**
     * The CounterSubCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CounterSubCategory;
    /**
     * Constructor method for AccessControl.AccessControlSystemCounter
     * @uses AccessControl_AccessControlSystemCounter::setAccessControlSystemId()
     * @uses AccessControl_AccessControlSystemCounter::setCounterId()
     * @uses AccessControl_AccessControlSystemCounter::setCounterSubCategory()
     * @param string $accessControlSystemId
     * @param string $counterId
     * @param string $counterSubCategory
     */
    public function __construct($accessControlSystemId = null, $counterId = null, $counterSubCategory = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setCounterId($counterId)
            ->setCounterSubCategory($counterSubCategory);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\AccessControl_AccessControlSystemCounter
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get CounterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounterId()
    {
        return isset($this->CounterId) ? $this->CounterId : null;
    }
    /**
     * Set CounterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $counterId
     * @return \patest\StructType\AccessControl_AccessControlSystemCounter
     */
    public function setCounterId($counterId = null)
    {
        // validation for constraint: string
        if (!is_null($counterId) && !is_string($counterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($counterId, true), gettype($counterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($counterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $counterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($counterId, true)), __LINE__);
        }
        if (is_null($counterId) || (is_array($counterId) && empty($counterId))) {
            unset($this->CounterId);
        } else {
            $this->CounterId = $counterId;
        }
        return $this;
    }
    /**
     * Get CounterSubCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCounterSubCategory()
    {
        return isset($this->CounterSubCategory) ? $this->CounterSubCategory : null;
    }
    /**
     * Set CounterSubCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $counterSubCategory
     * @return \patest\StructType\AccessControl_AccessControlSystemCounter
     */
    public function setCounterSubCategory($counterSubCategory = null)
    {
        // validation for constraint: string
        if (!is_null($counterSubCategory) && !is_string($counterSubCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($counterSubCategory, true), gettype($counterSubCategory)), __LINE__);
        }
        if (is_null($counterSubCategory) || (is_array($counterSubCategory) && empty($counterSubCategory))) {
            unset($this->CounterSubCategory);
        } else {
            $this->CounterSubCategory = $counterSubCategory;
        }
        return $this;
    }
}
