<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessCodeDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessCodeDescriptor
 * @subpackage Structs
 */
class AccessCodeDescriptor extends AbstractStructBase
{
    /**
     * The CodeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeText;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The TicketCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketCount;
    /**
     * The TransactionCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionCount;
    /**
     * Constructor method for AccessCodeDescriptor
     * @uses AccessCodeDescriptor::setCodeText()
     * @uses AccessCodeDescriptor::setIsActive()
     * @uses AccessCodeDescriptor::setTicketCount()
     * @uses AccessCodeDescriptor::setTransactionCount()
     * @param string $codeText
     * @param bool $isActive
     * @param int $ticketCount
     * @param int $transactionCount
     */
    public function __construct($codeText = null, $isActive = null, $ticketCount = null, $transactionCount = null)
    {
        $this
            ->setCodeText($codeText)
            ->setIsActive($isActive)
            ->setTicketCount($ticketCount)
            ->setTransactionCount($transactionCount);
    }
    /**
     * Get CodeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeText()
    {
        return isset($this->CodeText) ? $this->CodeText : null;
    }
    /**
     * Set CodeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeText
     * @return \patest\StructType\AccessCodeDescriptor
     */
    public function setCodeText($codeText = null)
    {
        // validation for constraint: string
        if (!is_null($codeText) && !is_string($codeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeText, true), gettype($codeText)), __LINE__);
        }
        if (is_null($codeText) || (is_array($codeText) && empty($codeText))) {
            unset($this->CodeText);
        } else {
            $this->CodeText = $codeText;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\AccessCodeDescriptor
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get TicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketCount()
    {
        return isset($this->TicketCount) ? $this->TicketCount : null;
    }
    /**
     * Set TicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketCount
     * @return \patest\StructType\AccessCodeDescriptor
     */
    public function setTicketCount($ticketCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCount) && !(is_int($ticketCount) || ctype_digit($ticketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketCount, true), gettype($ticketCount)), __LINE__);
        }
        if (is_null($ticketCount) || (is_array($ticketCount) && empty($ticketCount))) {
            unset($this->TicketCount);
        } else {
            $this->TicketCount = $ticketCount;
        }
        return $this;
    }
    /**
     * Get TransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionCount()
    {
        return isset($this->TransactionCount) ? $this->TransactionCount : null;
    }
    /**
     * Set TransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionCount
     * @return \patest\StructType\AccessCodeDescriptor
     */
    public function setTransactionCount($transactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionCount) && !(is_int($transactionCount) || ctype_digit($transactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionCount, true), gettype($transactionCount)), __LINE__);
        }
        if (is_null($transactionCount) || (is_array($transactionCount) && empty($transactionCount))) {
            unset($this->TransactionCount);
        } else {
            $this->TransactionCount = $transactionCount;
        }
        return $this;
    }
}
