<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcceptRelationshipInvitation-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AcceptRelationshipInvitation-Request
 * @subpackage Structs
 */
class AcceptRelationshipInvitation_Request extends AbstractStructBase
{
    /**
     * The InviteeClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InviteeClientId;
    /**
     * The IsRelationshipTemporary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRelationshipTemporary;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * Constructor method for AcceptRelationshipInvitation-Request
     * @uses AcceptRelationshipInvitation_Request::setInviteeClientId()
     * @uses AcceptRelationshipInvitation_Request::setIsRelationshipTemporary()
     * @uses AcceptRelationshipInvitation_Request::setRelationshipId()
     * @param string $inviteeClientId
     * @param bool $isRelationshipTemporary
     * @param string $relationshipId
     */
    public function __construct($inviteeClientId = null, $isRelationshipTemporary = null, $relationshipId = null)
    {
        $this
            ->setInviteeClientId($inviteeClientId)
            ->setIsRelationshipTemporary($isRelationshipTemporary)
            ->setRelationshipId($relationshipId);
    }
    /**
     * Get InviteeClientId value
     * @return string|null
     */
    public function getInviteeClientId()
    {
        return $this->InviteeClientId;
    }
    /**
     * Set InviteeClientId value
     * @param string $inviteeClientId
     * @return \patest\StructType\AcceptRelationshipInvitation_Request
     */
    public function setInviteeClientId($inviteeClientId = null)
    {
        // validation for constraint: string
        if (!is_null($inviteeClientId) && !is_string($inviteeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inviteeClientId, true), gettype($inviteeClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inviteeClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inviteeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inviteeClientId, true)), __LINE__);
        }
        $this->InviteeClientId = $inviteeClientId;
        return $this;
    }
    /**
     * Get IsRelationshipTemporary value
     * @return bool|null
     */
    public function getIsRelationshipTemporary()
    {
        return $this->IsRelationshipTemporary;
    }
    /**
     * Set IsRelationshipTemporary value
     * @param bool $isRelationshipTemporary
     * @return \patest\StructType\AcceptRelationshipInvitation_Request
     */
    public function setIsRelationshipTemporary($isRelationshipTemporary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelationshipTemporary) && !is_bool($isRelationshipTemporary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelationshipTemporary, true), gettype($isRelationshipTemporary)), __LINE__);
        }
        $this->IsRelationshipTemporary = $isRelationshipTemporary;
        return $this;
    }
    /**
     * Get RelationshipId value
     * @return string|null
     */
    public function getRelationshipId()
    {
        return $this->RelationshipId;
    }
    /**
     * Set RelationshipId value
     * @param string $relationshipId
     * @return \patest\StructType\AcceptRelationshipInvitation_Request
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        $this->RelationshipId = $relationshipId;
        return $this;
    }
}
