<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractProductItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractProductItem
 * @subpackage Structs
 */
class AbstractProductItem extends AbstractItem
{
    /**
     * The BackwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ItemIdentity
     */
    public $BackwardContinuation;
    /**
     * The DeliveryItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryItemId;
    /**
     * The ForwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ItemIdentity
     */
    public $ForwardContinuation;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The ClientIdentificationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientIdentificationId;
    /**
     * The IsExchangeable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExchangeable;
    /**
     * The SubstitutedForItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubstitutedForItemId;
    /**
     * The PriceEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PriceEffectiveness;
    /**
     * The ECardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ECardId;
    /**
     * The OriginalPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPriceTypeId;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrderIdentity
     */
    public $OrderIdentity;
    /**
     * The SubsidizedByAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizedByAccountId;
    /**
     * The SupplierBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierBranchId;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierId;
    /**
     * The BenefitPackageGrantData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BenefitPackageGrantData
     */
    public $BenefitPackageGrantData;
    /**
     * The IsExtraProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExtraProduct;
    /**
     * The LinkingProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\LinkingProductDetails
     */
    public $LinkingProduct;
    /**
     * The PinnedToPromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PinnedToPromptId;
    /**
     * The AttachedToBenefitInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AttachedToBenefitInstanceId;
    /**
     * The BenefitElementName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BenefitElementName;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The PinnedToCouponItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PinnedToCouponItemId;
    /**
     * The IsRequiredByBasketContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRequiredByBasketContent;
    /**
     * The FinancialJournalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionElementFinancialJournalInfo
     */
    public $FinancialJournalInfo;
    /**
     * The ExtraProductElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraProductElementId;
    /**
     * The BenefitClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BenefitClientId;
    /**
     * The AccessCodeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCodeText;
    /**
     * Constructor method for AbstractProductItem
     * @uses AbstractProductItem::setBackwardContinuation()
     * @uses AbstractProductItem::setDeliveryItemId()
     * @uses AbstractProductItem::setForwardContinuation()
     * @uses AbstractProductItem::setIsComplimentary()
     * @uses AbstractProductItem::setPriceListId()
     * @uses AbstractProductItem::setPriceTypeId()
     * @uses AbstractProductItem::setPriceTypeName()
     * @uses AbstractProductItem::setReservationExpiryDate()
     * @uses AbstractProductItem::setPrintCount()
     * @uses AbstractProductItem::setClientIdentificationId()
     * @uses AbstractProductItem::setIsExchangeable()
     * @uses AbstractProductItem::setSubstitutedForItemId()
     * @uses AbstractProductItem::setPriceEffectiveness()
     * @uses AbstractProductItem::setECardId()
     * @uses AbstractProductItem::setOriginalPriceTypeId()
     * @uses AbstractProductItem::setOrderIdentity()
     * @uses AbstractProductItem::setSubsidizedByAccountId()
     * @uses AbstractProductItem::setSupplierBranchId()
     * @uses AbstractProductItem::setSupplierId()
     * @uses AbstractProductItem::setBenefitPackageGrantData()
     * @uses AbstractProductItem::setIsExtraProduct()
     * @uses AbstractProductItem::setLinkingProduct()
     * @uses AbstractProductItem::setPinnedToPromptId()
     * @uses AbstractProductItem::setAttachedToBenefitInstanceId()
     * @uses AbstractProductItem::setBenefitElementName()
     * @uses AbstractProductItem::setSalesRepresentativeId()
     * @uses AbstractProductItem::setPinnedToCouponItemId()
     * @uses AbstractProductItem::setIsRequiredByBasketContent()
     * @uses AbstractProductItem::setFinancialJournalInfo()
     * @uses AbstractProductItem::setExtraProductElementId()
     * @uses AbstractProductItem::setBenefitClientId()
     * @uses AbstractProductItem::setAccessCodeText()
     * @param \patest\StructType\ItemIdentity $backwardContinuation
     * @param int $deliveryItemId
     * @param \patest\StructType\ItemIdentity $forwardContinuation
     * @param bool $isComplimentary
     * @param string $priceListId
     * @param string $priceTypeId
     * @param string $priceTypeName
     * @param string $reservationExpiryDate
     * @param int $printCount
     * @param int $clientIdentificationId
     * @param bool $isExchangeable
     * @param int $substitutedForItemId
     * @param string $priceEffectiveness
     * @param string $eCardId
     * @param string $originalPriceTypeId
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @param string $subsidizedByAccountId
     * @param string $supplierBranchId
     * @param string $supplierId
     * @param \patest\StructType\BenefitPackageGrantData $benefitPackageGrantData
     * @param bool $isExtraProduct
     * @param \patest\StructType\LinkingProductDetails $linkingProduct
     * @param string $pinnedToPromptId
     * @param string $attachedToBenefitInstanceId
     * @param string $benefitElementName
     * @param string $salesRepresentativeId
     * @param int $pinnedToCouponItemId
     * @param bool $isRequiredByBasketContent
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @param string $extraProductElementId
     * @param string $benefitClientId
     * @param string $accessCodeText
     */
    public function __construct(\patest\StructType\ItemIdentity $backwardContinuation = null, $deliveryItemId = null, \patest\StructType\ItemIdentity $forwardContinuation = null, $isComplimentary = null, $priceListId = null, $priceTypeId = null, $priceTypeName = null, $reservationExpiryDate = null, $printCount = null, $clientIdentificationId = null, $isExchangeable = null, $substitutedForItemId = null, $priceEffectiveness = null, $eCardId = null, $originalPriceTypeId = null, \patest\StructType\OrderIdentity $orderIdentity = null, $subsidizedByAccountId = null, $supplierBranchId = null, $supplierId = null, \patest\StructType\BenefitPackageGrantData $benefitPackageGrantData = null, $isExtraProduct = null, \patest\StructType\LinkingProductDetails $linkingProduct = null, $pinnedToPromptId = null, $attachedToBenefitInstanceId = null, $benefitElementName = null, $salesRepresentativeId = null, $pinnedToCouponItemId = null, $isRequiredByBasketContent = null, \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null, $extraProductElementId = null, $benefitClientId = null, $accessCodeText = null)
    {
        $this
            ->setBackwardContinuation($backwardContinuation)
            ->setDeliveryItemId($deliveryItemId)
            ->setForwardContinuation($forwardContinuation)
            ->setIsComplimentary($isComplimentary)
            ->setPriceListId($priceListId)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setPrintCount($printCount)
            ->setClientIdentificationId($clientIdentificationId)
            ->setIsExchangeable($isExchangeable)
            ->setSubstitutedForItemId($substitutedForItemId)
            ->setPriceEffectiveness($priceEffectiveness)
            ->setECardId($eCardId)
            ->setOriginalPriceTypeId($originalPriceTypeId)
            ->setOrderIdentity($orderIdentity)
            ->setSubsidizedByAccountId($subsidizedByAccountId)
            ->setSupplierBranchId($supplierBranchId)
            ->setSupplierId($supplierId)
            ->setBenefitPackageGrantData($benefitPackageGrantData)
            ->setIsExtraProduct($isExtraProduct)
            ->setLinkingProduct($linkingProduct)
            ->setPinnedToPromptId($pinnedToPromptId)
            ->setAttachedToBenefitInstanceId($attachedToBenefitInstanceId)
            ->setBenefitElementName($benefitElementName)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setPinnedToCouponItemId($pinnedToCouponItemId)
            ->setIsRequiredByBasketContent($isRequiredByBasketContent)
            ->setFinancialJournalInfo($financialJournalInfo)
            ->setExtraProductElementId($extraProductElementId)
            ->setBenefitClientId($benefitClientId)
            ->setAccessCodeText($accessCodeText);
    }
    /**
     * Get BackwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ItemIdentity|null
     */
    public function getBackwardContinuation()
    {
        return isset($this->BackwardContinuation) ? $this->BackwardContinuation : null;
    }
    /**
     * Set BackwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ItemIdentity $backwardContinuation
     * @return \patest\StructType\AbstractProductItem
     */
    public function setBackwardContinuation(\patest\StructType\ItemIdentity $backwardContinuation = null)
    {
        if (is_null($backwardContinuation) || (is_array($backwardContinuation) && empty($backwardContinuation))) {
            unset($this->BackwardContinuation);
        } else {
            $this->BackwardContinuation = $backwardContinuation;
        }
        return $this;
    }
    /**
     * Get DeliveryItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryItemId()
    {
        return isset($this->DeliveryItemId) ? $this->DeliveryItemId : null;
    }
    /**
     * Set DeliveryItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryItemId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setDeliveryItemId($deliveryItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryItemId) && !(is_int($deliveryItemId) || ctype_digit($deliveryItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryItemId, true), gettype($deliveryItemId)), __LINE__);
        }
        if (is_null($deliveryItemId) || (is_array($deliveryItemId) && empty($deliveryItemId))) {
            unset($this->DeliveryItemId);
        } else {
            $this->DeliveryItemId = $deliveryItemId;
        }
        return $this;
    }
    /**
     * Get ForwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ItemIdentity|null
     */
    public function getForwardContinuation()
    {
        return isset($this->ForwardContinuation) ? $this->ForwardContinuation : null;
    }
    /**
     * Set ForwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ItemIdentity $forwardContinuation
     * @return \patest\StructType\AbstractProductItem
     */
    public function setForwardContinuation(\patest\StructType\ItemIdentity $forwardContinuation = null)
    {
        if (is_null($forwardContinuation) || (is_array($forwardContinuation) && empty($forwardContinuation))) {
            unset($this->ForwardContinuation);
        } else {
            $this->ForwardContinuation = $forwardContinuation;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return $this->IsComplimentary;
    }
    /**
     * Set IsComplimentary value
     * @param bool $isComplimentary
     * @return \patest\StructType\AbstractProductItem
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        $this->IsComplimentary = $isComplimentary;
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\AbstractProductItem
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get ClientIdentificationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientIdentificationId()
    {
        return isset($this->ClientIdentificationId) ? $this->ClientIdentificationId : null;
    }
    /**
     * Set ClientIdentificationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientIdentificationId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setClientIdentificationId($clientIdentificationId = null)
    {
        // validation for constraint: int
        if (!is_null($clientIdentificationId) && !(is_int($clientIdentificationId) || ctype_digit($clientIdentificationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientIdentificationId, true), gettype($clientIdentificationId)), __LINE__);
        }
        if (is_null($clientIdentificationId) || (is_array($clientIdentificationId) && empty($clientIdentificationId))) {
            unset($this->ClientIdentificationId);
        } else {
            $this->ClientIdentificationId = $clientIdentificationId;
        }
        return $this;
    }
    /**
     * Get IsExchangeable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExchangeable()
    {
        return isset($this->IsExchangeable) ? $this->IsExchangeable : null;
    }
    /**
     * Set IsExchangeable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExchangeable
     * @return \patest\StructType\AbstractProductItem
     */
    public function setIsExchangeable($isExchangeable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExchangeable) && !is_bool($isExchangeable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExchangeable, true), gettype($isExchangeable)), __LINE__);
        }
        if (is_null($isExchangeable) || (is_array($isExchangeable) && empty($isExchangeable))) {
            unset($this->IsExchangeable);
        } else {
            $this->IsExchangeable = $isExchangeable;
        }
        return $this;
    }
    /**
     * Get SubstitutedForItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubstitutedForItemId()
    {
        return isset($this->SubstitutedForItemId) ? $this->SubstitutedForItemId : null;
    }
    /**
     * Set SubstitutedForItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $substitutedForItemId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setSubstitutedForItemId($substitutedForItemId = null)
    {
        // validation for constraint: int
        if (!is_null($substitutedForItemId) && !(is_int($substitutedForItemId) || ctype_digit($substitutedForItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($substitutedForItemId, true), gettype($substitutedForItemId)), __LINE__);
        }
        if (is_null($substitutedForItemId) || (is_array($substitutedForItemId) && empty($substitutedForItemId))) {
            unset($this->SubstitutedForItemId);
        } else {
            $this->SubstitutedForItemId = $substitutedForItemId;
        }
        return $this;
    }
    /**
     * Get PriceEffectiveness value
     * @return string|null
     */
    public function getPriceEffectiveness()
    {
        return $this->PriceEffectiveness;
    }
    /**
     * Set PriceEffectiveness value
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::valueIsValid()
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceEffectiveness
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPriceEffectiveness($priceEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemPriceEffectiveness::valueIsValid($priceEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemPriceEffectiveness', is_array($priceEffectiveness) ? implode(', ', $priceEffectiveness) : var_export($priceEffectiveness, true), implode(', ', \patest\EnumType\ProductItemPriceEffectiveness::getValidValues())), __LINE__);
        }
        $this->PriceEffectiveness = $priceEffectiveness;
        return $this;
    }
    /**
     * Get ECardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECardId()
    {
        return isset($this->ECardId) ? $this->ECardId : null;
    }
    /**
     * Set ECardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCardId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setECardId($eCardId = null)
    {
        // validation for constraint: string
        if (!is_null($eCardId) && !is_string($eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCardId, true), gettype($eCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eCardId, true)), __LINE__);
        }
        if (is_null($eCardId) || (is_array($eCardId) && empty($eCardId))) {
            unset($this->ECardId);
        } else {
            $this->ECardId = $eCardId;
        }
        return $this;
    }
    /**
     * Get OriginalPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPriceTypeId()
    {
        return isset($this->OriginalPriceTypeId) ? $this->OriginalPriceTypeId : null;
    }
    /**
     * Set OriginalPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPriceTypeId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setOriginalPriceTypeId($originalPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPriceTypeId) && !is_string($originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPriceTypeId, true), gettype($originalPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPriceTypeId, true)), __LINE__);
        }
        if (is_null($originalPriceTypeId) || (is_array($originalPriceTypeId) && empty($originalPriceTypeId))) {
            unset($this->OriginalPriceTypeId);
        } else {
            $this->OriginalPriceTypeId = $originalPriceTypeId;
        }
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrderIdentity|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrderIdentity $orderIdentity
     * @return \patest\StructType\AbstractProductItem
     */
    public function setOrderIdentity(\patest\StructType\OrderIdentity $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountId()
    {
        return isset($this->SubsidizedByAccountId) ? $this->SubsidizedByAccountId : null;
    }
    /**
     * Set SubsidizedByAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setSubsidizedByAccountId($subsidizedByAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountId) && !is_string($subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountId, true), gettype($subsidizedByAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizedByAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizedByAccountId, true)), __LINE__);
        }
        if (is_null($subsidizedByAccountId) || (is_array($subsidizedByAccountId) && empty($subsidizedByAccountId))) {
            unset($this->SubsidizedByAccountId);
        } else {
            $this->SubsidizedByAccountId = $subsidizedByAccountId;
        }
        return $this;
    }
    /**
     * Get SupplierBranchId value
     * @return string|null
     */
    public function getSupplierBranchId()
    {
        return $this->SupplierBranchId;
    }
    /**
     * Set SupplierBranchId value
     * @param string $supplierBranchId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setSupplierBranchId($supplierBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierBranchId) && !is_string($supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierBranchId, true), gettype($supplierBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierBranchId, true)), __LINE__);
        }
        $this->SupplierBranchId = $supplierBranchId;
        return $this;
    }
    /**
     * Get SupplierId value
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param string $supplierId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierId) && !is_string($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierId, true)), __LINE__);
        }
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get BenefitPackageGrantData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BenefitPackageGrantData|null
     */
    public function getBenefitPackageGrantData()
    {
        return isset($this->BenefitPackageGrantData) ? $this->BenefitPackageGrantData : null;
    }
    /**
     * Set BenefitPackageGrantData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BenefitPackageGrantData $benefitPackageGrantData
     * @return \patest\StructType\AbstractProductItem
     */
    public function setBenefitPackageGrantData(\patest\StructType\BenefitPackageGrantData $benefitPackageGrantData = null)
    {
        if (is_null($benefitPackageGrantData) || (is_array($benefitPackageGrantData) && empty($benefitPackageGrantData))) {
            unset($this->BenefitPackageGrantData);
        } else {
            $this->BenefitPackageGrantData = $benefitPackageGrantData;
        }
        return $this;
    }
    /**
     * Get IsExtraProduct value
     * @return bool|null
     */
    public function getIsExtraProduct()
    {
        return $this->IsExtraProduct;
    }
    /**
     * Set IsExtraProduct value
     * @param bool $isExtraProduct
     * @return \patest\StructType\AbstractProductItem
     */
    public function setIsExtraProduct($isExtraProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraProduct) && !is_bool($isExtraProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraProduct, true), gettype($isExtraProduct)), __LINE__);
        }
        $this->IsExtraProduct = $isExtraProduct;
        return $this;
    }
    /**
     * Get LinkingProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\LinkingProductDetails|null
     */
    public function getLinkingProduct()
    {
        return isset($this->LinkingProduct) ? $this->LinkingProduct : null;
    }
    /**
     * Set LinkingProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\LinkingProductDetails $linkingProduct
     * @return \patest\StructType\AbstractProductItem
     */
    public function setLinkingProduct(\patest\StructType\LinkingProductDetails $linkingProduct = null)
    {
        if (is_null($linkingProduct) || (is_array($linkingProduct) && empty($linkingProduct))) {
            unset($this->LinkingProduct);
        } else {
            $this->LinkingProduct = $linkingProduct;
        }
        return $this;
    }
    /**
     * Get PinnedToPromptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPinnedToPromptId()
    {
        return isset($this->PinnedToPromptId) ? $this->PinnedToPromptId : null;
    }
    /**
     * Set PinnedToPromptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pinnedToPromptId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPinnedToPromptId($pinnedToPromptId = null)
    {
        // validation for constraint: string
        if (!is_null($pinnedToPromptId) && !is_string($pinnedToPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pinnedToPromptId, true), gettype($pinnedToPromptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pinnedToPromptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pinnedToPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pinnedToPromptId, true)), __LINE__);
        }
        if (is_null($pinnedToPromptId) || (is_array($pinnedToPromptId) && empty($pinnedToPromptId))) {
            unset($this->PinnedToPromptId);
        } else {
            $this->PinnedToPromptId = $pinnedToPromptId;
        }
        return $this;
    }
    /**
     * Get AttachedToBenefitInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachedToBenefitInstanceId()
    {
        return isset($this->AttachedToBenefitInstanceId) ? $this->AttachedToBenefitInstanceId : null;
    }
    /**
     * Set AttachedToBenefitInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachedToBenefitInstanceId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setAttachedToBenefitInstanceId($attachedToBenefitInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($attachedToBenefitInstanceId) && !is_string($attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachedToBenefitInstanceId, true), gettype($attachedToBenefitInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($attachedToBenefitInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $attachedToBenefitInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($attachedToBenefitInstanceId, true)), __LINE__);
        }
        if (is_null($attachedToBenefitInstanceId) || (is_array($attachedToBenefitInstanceId) && empty($attachedToBenefitInstanceId))) {
            unset($this->AttachedToBenefitInstanceId);
        } else {
            $this->AttachedToBenefitInstanceId = $attachedToBenefitInstanceId;
        }
        return $this;
    }
    /**
     * Get BenefitElementName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitElementName()
    {
        return isset($this->BenefitElementName) ? $this->BenefitElementName : null;
    }
    /**
     * Set BenefitElementName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitElementName
     * @return \patest\StructType\AbstractProductItem
     */
    public function setBenefitElementName($benefitElementName = null)
    {
        // validation for constraint: string
        if (!is_null($benefitElementName) && !is_string($benefitElementName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitElementName, true), gettype($benefitElementName)), __LINE__);
        }
        if (is_null($benefitElementName) || (is_array($benefitElementName) && empty($benefitElementName))) {
            unset($this->BenefitElementName);
        } else {
            $this->BenefitElementName = $benefitElementName;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get PinnedToCouponItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPinnedToCouponItemId()
    {
        return isset($this->PinnedToCouponItemId) ? $this->PinnedToCouponItemId : null;
    }
    /**
     * Set PinnedToCouponItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pinnedToCouponItemId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setPinnedToCouponItemId($pinnedToCouponItemId = null)
    {
        // validation for constraint: int
        if (!is_null($pinnedToCouponItemId) && !(is_int($pinnedToCouponItemId) || ctype_digit($pinnedToCouponItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pinnedToCouponItemId, true), gettype($pinnedToCouponItemId)), __LINE__);
        }
        if (is_null($pinnedToCouponItemId) || (is_array($pinnedToCouponItemId) && empty($pinnedToCouponItemId))) {
            unset($this->PinnedToCouponItemId);
        } else {
            $this->PinnedToCouponItemId = $pinnedToCouponItemId;
        }
        return $this;
    }
    /**
     * Get IsRequiredByBasketContent value
     * @return bool|null
     */
    public function getIsRequiredByBasketContent()
    {
        return $this->IsRequiredByBasketContent;
    }
    /**
     * Set IsRequiredByBasketContent value
     * @param bool $isRequiredByBasketContent
     * @return \patest\StructType\AbstractProductItem
     */
    public function setIsRequiredByBasketContent($isRequiredByBasketContent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequiredByBasketContent) && !is_bool($isRequiredByBasketContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequiredByBasketContent, true), gettype($isRequiredByBasketContent)), __LINE__);
        }
        $this->IsRequiredByBasketContent = $isRequiredByBasketContent;
        return $this;
    }
    /**
     * Get FinancialJournalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionElementFinancialJournalInfo|null
     */
    public function getFinancialJournalInfo()
    {
        return isset($this->FinancialJournalInfo) ? $this->FinancialJournalInfo : null;
    }
    /**
     * Set FinancialJournalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo
     * @return \patest\StructType\AbstractProductItem
     */
    public function setFinancialJournalInfo(\patest\StructType\TransactionElementFinancialJournalInfo $financialJournalInfo = null)
    {
        if (is_null($financialJournalInfo) || (is_array($financialJournalInfo) && empty($financialJournalInfo))) {
            unset($this->FinancialJournalInfo);
        } else {
            $this->FinancialJournalInfo = $financialJournalInfo;
        }
        return $this;
    }
    /**
     * Get ExtraProductElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraProductElementId()
    {
        return isset($this->ExtraProductElementId) ? $this->ExtraProductElementId : null;
    }
    /**
     * Set ExtraProductElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraProductElementId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setExtraProductElementId($extraProductElementId = null)
    {
        // validation for constraint: string
        if (!is_null($extraProductElementId) && !is_string($extraProductElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraProductElementId, true), gettype($extraProductElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraProductElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraProductElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraProductElementId, true)), __LINE__);
        }
        if (is_null($extraProductElementId) || (is_array($extraProductElementId) && empty($extraProductElementId))) {
            unset($this->ExtraProductElementId);
        } else {
            $this->ExtraProductElementId = $extraProductElementId;
        }
        return $this;
    }
    /**
     * Get BenefitClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBenefitClientId()
    {
        return isset($this->BenefitClientId) ? $this->BenefitClientId : null;
    }
    /**
     * Set BenefitClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $benefitClientId
     * @return \patest\StructType\AbstractProductItem
     */
    public function setBenefitClientId($benefitClientId = null)
    {
        // validation for constraint: string
        if (!is_null($benefitClientId) && !is_string($benefitClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($benefitClientId, true), gettype($benefitClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($benefitClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $benefitClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($benefitClientId, true)), __LINE__);
        }
        if (is_null($benefitClientId) || (is_array($benefitClientId) && empty($benefitClientId))) {
            unset($this->BenefitClientId);
        } else {
            $this->BenefitClientId = $benefitClientId;
        }
        return $this;
    }
    /**
     * Get AccessCodeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeText()
    {
        return isset($this->AccessCodeText) ? $this->AccessCodeText : null;
    }
    /**
     * Set AccessCodeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeText
     * @return \patest\StructType\AbstractProductItem
     */
    public function setAccessCodeText($accessCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeText) && !is_string($accessCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeText, true), gettype($accessCodeText)), __LINE__);
        }
        if (is_null($accessCodeText) || (is_array($accessCodeText) && empty($accessCodeText))) {
            unset($this->AccessCodeText);
        } else {
            $this->AccessCodeText = $accessCodeText;
        }
        return $this;
    }
}
