<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCriteria StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AbstractCriteria
 * @subpackage Structs
 */
class AbstractCriteria extends AbstractStructBase
{
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Options;
    /**
     * The m_Properties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse
     */
    public $m_Properties;
    /**
     * Constructor method for AbstractCriteria
     * @uses AbstractCriteria::setOptions()
     * @uses AbstractCriteria::setM_Properties()
     * @param string[] $options
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse $m_Properties
     */
    public function __construct(array $options = array(), \patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse $m_Properties = null)
    {
        $this
            ->setOptions($options)
            ->setM_Properties($m_Properties);
    }
    /**
     * Get Options value
     * @return string[]|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * This method is responsible for validating the values passed to the setOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOptionsForArrayConstraintsFromSetOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abstractCriteriaOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SearchSpecialFlags::valueIsValid($abstractCriteriaOptionsItem)) {
                $invalidValues[] = is_object($abstractCriteriaOptionsItem) ? get_class($abstractCriteriaOptionsItem) : sprintf('%s(%s)', gettype($abstractCriteriaOptionsItem), var_export($abstractCriteriaOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SearchSpecialFlags', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SearchSpecialFlags::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Options value
     * @uses \patest\EnumType\SearchSpecialFlags::valueIsValid()
     * @uses \patest\EnumType\SearchSpecialFlags::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $options
     * @return \patest\StructType\AbstractCriteria
     */
    public function setOptions(array $options = array())
    {
        // validation for constraint: list
        if ('' !== ($optionsArrayErrorMessage = self::validateOptionsForArrayConstraintsFromSetOptions($options))) {
            throw new \InvalidArgumentException($optionsArrayErrorMessage, __LINE__);
        }
        $this->Options = is_array($options) ? implode(' ', $options) : null;
        return $this;
    }
    /**
     * Get m_Properties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse|null
     */
    public function getM_Properties()
    {
        return isset($this->m_Properties) ? $this->m_Properties : null;
    }
    /**
     * Set m_Properties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse $m_Properties
     * @return \patest\StructType\AbstractCriteria
     */
    public function setM_Properties(\patest\ArrayType\ArrayOfKeyValueOfstringSinglePropertyCriteriaBasevEzo7Bse $m_Properties = null)
    {
        if (is_null($m_Properties) || (is_array($m_Properties) && empty($m_Properties))) {
            unset($this->m_Properties);
        } else {
            $this->m_Properties = $m_Properties;
        }
        return $this;
    }
}
