<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UpdateExternalIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateExternalIdsRequest $iIntegrationService_UpdateExternalIds_RequestMsg
     * @return \patest\StructType\UpdateExternalIdsResponse|bool
     */
    public function UpdateExternalIds(\patest\StructType\UpdateExternalIdsRequest $iIntegrationService_UpdateExternalIds_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExternalIds($iIntegrationService_UpdateExternalIds_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateGlobalMonitors
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateGlobalMonitorsRequest $iTenantAdministrationService_UpdateGlobalMonitors_RequestMsg
     * @return \patest\StructType\UpdateGlobalMonitorsResponse|bool
     */
    public function UpdateGlobalMonitors(\patest\StructType\UpdateGlobalMonitorsRequest $iTenantAdministrationService_UpdateGlobalMonitors_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateGlobalMonitors($iTenantAdministrationService_UpdateGlobalMonitors_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSubscription
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateSubscriptionRequest $iNotificationsService_UpdateSubscription_RequestMsg
     * @return \patest\StructType\UpdateSubscriptionResponse|bool
     */
    public function UpdateSubscription(\patest\StructType\UpdateSubscriptionRequest $iNotificationsService_UpdateSubscription_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSubscription($iNotificationsService_UpdateSubscription_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Update
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Update_RequestMsg
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|bool
     */
    public function Update(\patest\StructType\EntitiesCreateOrUpdateRequest $iSoapEntityManagementFacade_Update_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Update($iSoapEntityManagementFacade_Update_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateExternalAuthenticationData
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateExternalAuthenticationData_Request $iAuthenticationFacade_UpdateExternalAuthenticationData_RequestMsg
     * @return \patest\StructType\UpdateExternalAuthenticationData_Response|bool
     */
    public function UpdateExternalAuthenticationData(\patest\StructType\UpdateExternalAuthenticationData_Request $iAuthenticationFacade_UpdateExternalAuthenticationData_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExternalAuthenticationData($iAuthenticationFacade_UpdateExternalAuthenticationData_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomer
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateCustomerRequest $iCrmFacade_UpdateCustomer_RequestMsg
     * @return \patest\StructType\UpdateCustomerResponse|bool
     */
    public function UpdateCustomer(\patest\StructType\UpdateCustomerRequest $iCrmFacade_UpdateCustomer_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomer($iCrmFacade_UpdateCustomer_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateAccountRequest $iCrmFacade_UpdateAccount_RequestMsg
     * @return \patest\StructType\UpdateAccountResponse|bool
     */
    public function UpdateAccount(\patest\StructType\UpdateAccountRequest $iCrmFacade_UpdateAccount_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAccount($iCrmFacade_UpdateAccount_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDeliveryItems
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateDeliveryItems_Request $iDeliveryFacade_UpdateDeliveryItems_RequestMsg
     * @return \patest\StructType\UpdateDeliveryItems_Response|bool
     */
    public function UpdateDeliveryItems(\patest\StructType\UpdateDeliveryItems_Request $iDeliveryFacade_UpdateDeliveryItems_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDeliveryItems($iDeliveryFacade_UpdateDeliveryItems_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDonationItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateDonationItemProperties_Request $iDonationFacade_UpdateDonationItemProperties_RequestMsg
     * @return \patest\StructType\UpdateDonationItemProperties_Response|bool
     */
    public function UpdateDonationItemProperties(\patest\StructType\UpdateDonationItemProperties_Request $iDonationFacade_UpdateDonationItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDonationItemProperties($iDonationFacade_UpdateDonationItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateClientLink
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateClientLinkRequest $iEsroFacade_UpdateClientLink_RequestMsg
     * @return \patest\StructType\UpdateClientLinkResponse|bool
     */
    public function UpdateClientLink(\patest\StructType\UpdateClientLinkRequest $iEsroFacade_UpdateClientLink_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateClientLink($iEsroFacade_UpdateClientLink_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateMembershipItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateMembershipItemProperties_Request $iMembershipFacade_UpdateMembershipItemProperties_RequestMsg
     * @return \patest\StructType\UpdateMembershipItemProperties_Response|bool
     */
    public function UpdateMembershipItemProperties(\patest\StructType\UpdateMembershipItemProperties_Request $iMembershipFacade_UpdateMembershipItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateMembershipItemProperties($iMembershipFacade_UpdateMembershipItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateCommittedMembershipItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateCommittedMembershipItemProperties_Request $iMembershipFacade_UpdateCommittedMembershipItemProperties_RequestMsg
     * @return \patest\StructType\UpdateCommittedMembershipItemProperties_Response|bool
     */
    public function UpdateCommittedMembershipItemProperties(\patest\StructType\UpdateCommittedMembershipItemProperties_Request $iMembershipFacade_UpdateCommittedMembershipItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCommittedMembershipItemProperties($iMembershipFacade_UpdateCommittedMembershipItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDirectDebitRecordStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateDirectDebitRecordStatus_Request $iPaymentFacade_UpdateDirectDebitRecordStatus_RequestMsg
     * @return \patest\StructType\UpdateDirectDebitRecordStatus_Response|bool
     */
    public function UpdateDirectDebitRecordStatus(\patest\StructType\UpdateDirectDebitRecordStatus_Request $iPaymentFacade_UpdateDirectDebitRecordStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDirectDebitRecordStatus($iPaymentFacade_UpdateDirectDebitRecordStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePaymentItemStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePaymentItems_Request $iPaymentFacade_UpdatePaymentItemStatus_RequestMsg
     * @return \patest\StructType\UpdatePaymentItems_Response|bool
     */
    public function UpdatePaymentItemStatus(\patest\StructType\UpdatePaymentItems_Request $iPaymentFacade_UpdatePaymentItemStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePaymentItemStatus($iPaymentFacade_UpdatePaymentItemStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdatePaymentItemProviderSpecificProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest $iPaymentFacade_UpdatePaymentItemProviderSpecificProperties_RequestMsg
     * @return \patest\StructType\UpdatePaymentItemProviderSpecificPropertiesResponse|bool
     */
    public function UpdatePaymentItemProviderSpecificProperties(\patest\StructType\UpdatePaymentItemProviderSpecificPropertiesRequest $iPaymentFacade_UpdatePaymentItemProviderSpecificProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePaymentItemProviderSpecificProperties($iPaymentFacade_UpdatePaymentItemProviderSpecificProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePaymentSessionState
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePaymentSessionStateRequest $iPaymentFacade_UpdatePaymentSessionState_RequestMsg
     * @return \patest\StructType\UpdatePaymentSessionStateResponse|bool
     */
    public function UpdatePaymentSessionState(\patest\StructType\UpdatePaymentSessionStateRequest $iPaymentFacade_UpdatePaymentSessionState_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePaymentSessionState($iPaymentFacade_UpdatePaymentSessionState_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePaymentPlanInstallments
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePaymentPlanInstallments_Request $iPaymentFacade_UpdatePaymentPlanInstallments_RequestMsg
     * @return \patest\StructType\UpdatePaymentPlanInstallments_Response|bool
     */
    public function UpdatePaymentPlanInstallments(\patest\StructType\UpdatePaymentPlanInstallments_Request $iPaymentFacade_UpdatePaymentPlanInstallments_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePaymentPlanInstallments($iPaymentFacade_UpdatePaymentPlanInstallments_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateDepositItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateDepositItemProperties_Request $iPaymentFacade_UpdateDepositItemProperties_RequestMsg
     * @return \patest\StructType\UpdateDepositItemProperties_Response|bool
     */
    public function UpdateDepositItemProperties(\patest\StructType\UpdateDepositItemProperties_Request $iPaymentFacade_UpdateDepositItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateDepositItemProperties($iPaymentFacade_UpdateDepositItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateUppConfiguration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateUppConfigurationRequest $iPaymentFacade_UpdateUppConfiguration_RequestMsg
     * @return \patest\StructType\UpdateUppConfigurationResponse|bool
     */
    public function UpdateUppConfiguration(\patest\StructType\UpdateUppConfigurationRequest $iPaymentFacade_UpdateUppConfiguration_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateUppConfiguration($iPaymentFacade_UpdateUppConfiguration_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTransactionProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateTransactionProperties_Request $iSaleFacade_UpdateTransactionProperties_RequestMsg
     * @return \patest\StructType\UpdateTransactionProperties_Response|bool
     */
    public function UpdateTransactionProperties(\patest\StructType\UpdateTransactionProperties_Request $iSaleFacade_UpdateTransactionProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTransactionProperties($iSaleFacade_UpdateTransactionProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateItemProperties_Request $iSaleFacade_UpdateItemProperties_RequestMsg
     * @return \patest\StructType\UpdateItemProperties_Response|bool
     */
    public function UpdateItemProperties(\patest\StructType\UpdateItemProperties_Request $iSaleFacade_UpdateItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateItemProperties($iSaleFacade_UpdateItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateCommittedTransactionProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateCommittedTransactionProperties_Request $iSaleFacade_UpdateCommittedTransactionProperties_RequestMsg
     * @return \patest\StructType\UpdateCommittedTransactionProperties_Response|bool
     */
    public function UpdateCommittedTransactionProperties(\patest\StructType\UpdateCommittedTransactionProperties_Request $iSaleFacade_UpdateCommittedTransactionProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCommittedTransactionProperties($iSaleFacade_UpdateCommittedTransactionProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCommittedItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateCommittedItemProperties_Request $iSaleFacade_UpdateCommittedItemProperties_RequestMsg
     * @return \patest\StructType\UpdateCommittedItemProperties_Response|bool
     */
    public function UpdateCommittedItemProperties(\patest\StructType\UpdateCommittedItemProperties_Request $iSaleFacade_UpdateCommittedItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCommittedItemProperties($iSaleFacade_UpdateCommittedItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSoldItemsPrice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateSoldItemsPrice_Request $iSaleFacade_UpdateSoldItemsPrice_RequestMsg
     * @return \patest\StructType\UpdateSoldItemsPrice_Response|bool
     */
    public function UpdateSoldItemsPrice(\patest\StructType\UpdateSoldItemsPrice_Request $iSaleFacade_UpdateSoldItemsPrice_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSoldItemsPrice($iSaleFacade_UpdateSoldItemsPrice_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateConnectionProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateConnectionProperties_Request $iSecurityFacade_UpdateConnectionProperties_RequestMsg
     * @return \patest\StructType\UpdateConnectionProperties_Response|bool
     */
    public function UpdateConnectionProperties(\patest\StructType\UpdateConnectionProperties_Request $iSecurityFacade_UpdateConnectionProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateConnectionProperties($iSecurityFacade_UpdateConnectionProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateParameters
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateParameters_Request $iSecurityFacade_UpdateParameters_RequestMsg
     * @return \patest\StructType\UpdateParameters_Response|bool
     */
    public function UpdateParameters(\patest\StructType\UpdateParameters_Request $iSecurityFacade_UpdateParameters_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateParameters($iSecurityFacade_UpdateParameters_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSubscriptionItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateSubscriptionItemPropertiesRequest $iSubscriptionFacade_UpdateSubscriptionItemProperties_RequestMsg
     * @return \patest\StructType\UpdateSubscriptionItemPropertiesResponse|bool
     */
    public function UpdateSubscriptionItemProperties(\patest\StructType\UpdateSubscriptionItemPropertiesRequest $iSubscriptionFacade_UpdateSubscriptionItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSubscriptionItemProperties($iSubscriptionFacade_UpdateSubscriptionItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateHallVersionStatus
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateHallVersionStatus_Request $iTicketingFacade_UpdateHallVersionStatus_RequestMsg
     * @return \patest\StructType\UpdateHallVersionStatus_Response|bool
     */
    public function UpdateHallVersionStatus(\patest\StructType\UpdateHallVersionStatus_Request $iTicketingFacade_UpdateHallVersionStatus_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateHallVersionStatus($iTicketingFacade_UpdateHallVersionStatus_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketItemProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateTicketItemProperties_Request $iTicketingFacade_UpdateTicketItemProperties_RequestMsg
     * @return \patest\StructType\UpdateTicketItemProperties_Response|bool
     */
    public function UpdateTicketItemProperties(\patest\StructType\UpdateTicketItemProperties_Request $iTicketingFacade_UpdateTicketItemProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketItemProperties($iTicketingFacade_UpdateTicketItemProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOfClientApprovalOfEnrollment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateOfClientApprovalOfEnrollment_Request $iTicketingFacade_UpdateOfClientApprovalOfEnrollment_RequestMsg
     * @return \patest\StructType\UpdateOfClientApprovalOfEnrollment_Response|bool
     */
    public function UpdateOfClientApprovalOfEnrollment(\patest\StructType\UpdateOfClientApprovalOfEnrollment_Request $iTicketingFacade_UpdateOfClientApprovalOfEnrollment_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateOfClientApprovalOfEnrollment($iTicketingFacade_UpdateOfClientApprovalOfEnrollment_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePresale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePresale_Request $iTicketingFacade_UpdatePresale_RequestMsg
     * @return \patest\StructType\UpdatePresale_Response|bool
     */
    public function UpdatePresale(\patest\StructType\UpdatePresale_Request $iTicketingFacade_UpdatePresale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePresale($iTicketingFacade_UpdatePresale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateOnsale
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateOnsale_Request $iTicketingFacade_UpdateOnsale_RequestMsg
     * @return \patest\StructType\UpdateOnsale_Response|bool
     */
    public function UpdateOnsale(\patest\StructType\UpdateOnsale_Request $iTicketingFacade_UpdateOnsale_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateOnsale($iTicketingFacade_UpdateOnsale_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateAccessCodes
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateAccessCode_Request $iTicketingFacade_UpdateAccessCodes_RequestMsg
     * @return \patest\StructType\UpdateAccessCode_Response|bool
     */
    public function UpdateAccessCodes(\patest\StructType\UpdateAccessCode_Request $iTicketingFacade_UpdateAccessCodes_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateAccessCodes($iTicketingFacade_UpdateAccessCodes_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePresalesRankWeight
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdatePresalesRankWeight_Request $iTicketingFacade_UpdatePresalesRankWeight_RequestMsg
     * @return \patest\StructType\UpdatePresalesRankWeight_Response|bool
     */
    public function UpdatePresalesRankWeight(\patest\StructType\UpdatePresalesRankWeight_Request $iTicketingFacade_UpdatePresalesRankWeight_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePresalesRankWeight($iTicketingFacade_UpdatePresalesRankWeight_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomSeatPrices
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateCustomSeatPricesRequest $iTicketingFacade_UpdateCustomSeatPrices_RequestMsg
     * @return \patest\StructType\UpdateCustomSeatPricesResponse|bool
     */
    public function UpdateCustomSeatPrices(\patest\StructType\UpdateCustomSeatPricesRequest $iTicketingFacade_UpdateCustomSeatPrices_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCustomSeatPrices($iTicketingFacade_UpdateCustomSeatPrices_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateExistingTicketProperties
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateExistingTicketProperties_Request $iTicketingFacade_UpdateExistingTicketProperties_RequestMsg
     * @return \patest\StructType\UpdateExistingTicketProperties_Response|bool
     */
    public function UpdateExistingTicketProperties(\patest\StructType\UpdateExistingTicketProperties_Request $iTicketingFacade_UpdateExistingTicketProperties_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateExistingTicketProperties($iTicketingFacade_UpdateExistingTicketProperties_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEventTicketViewConfiguration
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateEventTicketViewConfiguration_Request $iTicketingFacade_UpdateEventTicketViewConfiguration_RequestMsg
     * @return \patest\StructType\UpdateEventTicketViewConfiguration_Response|bool
     */
    public function UpdateEventTicketViewConfiguration(\patest\StructType\UpdateEventTicketViewConfiguration_Request $iTicketingFacade_UpdateEventTicketViewConfiguration_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateEventTicketViewConfiguration($iTicketingFacade_UpdateEventTicketViewConfiguration_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketViewComponentById
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\TicketViewComponentUpdate_Request $iTicketingFacade_UpdateTicketViewComponentById_RequestMsg
     * @return \patest\StructType\UpdateTicketViewComponentById_Response|bool
     */
    public function UpdateTicketViewComponentById(\patest\StructType\TicketViewComponentUpdate_Request $iTicketingFacade_UpdateTicketViewComponentById_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketViewComponentById($iTicketingFacade_UpdateTicketViewComponentById_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketViewAssociation
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateTicketViewAssociation_Request $iTicketingFacade_UpdateTicketViewAssociation_RequestMsg
     * @return \patest\StructType\UpdateTicketViewAssociation_Response|bool
     */
    public function UpdateTicketViewAssociation(\patest\StructType\UpdateTicketViewAssociation_Request $iTicketingFacade_UpdateTicketViewAssociation_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketViewAssociation($iTicketingFacade_UpdateTicketViewAssociation_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateTicketViewConfigurationImage
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateTicketViewConfigurationImageRequest $iTicketingFacade_UpdateTicketViewConfigurationImage_RequestMsg
     * @return \patest\StructType\UpdateTicketViewConfigurationImageResponse|bool
     */
    public function UpdateTicketViewConfigurationImage(\patest\StructType\UpdateTicketViewConfigurationImageRequest $iTicketingFacade_UpdateTicketViewConfigurationImage_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketViewConfigurationImage($iTicketingFacade_UpdateTicketViewConfigurationImage_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateTicketViewAssociationPrioritiesByIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequest $iTicketingFacade_UpdateTicketViewAssociationPrioritiesByIds_RequestMsg
     * @return \patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsResponse|bool
     */
    public function UpdateTicketViewAssociationPrioritiesByIds(\patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsRequest $iTicketingFacade_UpdateTicketViewAssociationPrioritiesByIds_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateTicketViewAssociationPrioritiesByIds($iTicketingFacade_UpdateTicketViewAssociationPrioritiesByIds_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * UpdateSubscriptionInstancesMaxAllowedExchanges
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Request $iTicketingFacade_UpdateSubscriptionInstancesMaxAllowedExchanges_RequestMsg
     * @return \patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Response|bool
     */
    public function UpdateSubscriptionInstancesMaxAllowedExchanges(\patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Request $iTicketingFacade_UpdateSubscriptionInstancesMaxAllowedExchanges_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateSubscriptionInstancesMaxAllowedExchanges($iTicketingFacade_UpdateSubscriptionInstancesMaxAllowedExchanges_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\EntitiesCreateOrUpdateResponse|\patest\StructType\UpdateAccessCode_Response|\patest\StructType\UpdateAccountResponse|\patest\StructType\UpdateClientLinkResponse|\patest\StructType\UpdateCommittedItemProperties_Response|\patest\StructType\UpdateCommittedMembershipItemProperties_Response|\patest\StructType\UpdateCommittedTransactionProperties_Response|\patest\StructType\UpdateConnectionProperties_Response|\patest\StructType\UpdateCustomerResponse|\patest\StructType\UpdateCustomSeatPricesResponse|\patest\StructType\UpdateDeliveryItems_Response|\patest\StructType\UpdateDepositItemProperties_Response|\patest\StructType\UpdateDirectDebitRecordStatus_Response|\patest\StructType\UpdateDonationItemProperties_Response|\patest\StructType\UpdateEventTicketViewConfiguration_Response|\patest\StructType\UpdateExistingTicketProperties_Response|\patest\StructType\UpdateExternalAuthenticationData_Response|\patest\StructType\UpdateExternalIdsResponse|\patest\StructType\UpdateGlobalMonitorsResponse|\patest\StructType\UpdateHallVersionStatus_Response|\patest\StructType\UpdateItemProperties_Response|\patest\StructType\UpdateMembershipItemProperties_Response|\patest\StructType\UpdateOfClientApprovalOfEnrollment_Response|\patest\StructType\UpdateOnsale_Response|\patest\StructType\UpdateParameters_Response|\patest\StructType\UpdatePaymentItemProviderSpecificPropertiesResponse|\patest\StructType\UpdatePaymentItems_Response|\patest\StructType\UpdatePaymentPlanInstallments_Response|\patest\StructType\UpdatePaymentSessionStateResponse|\patest\StructType\UpdatePresalesRankWeight_Response|\patest\StructType\UpdatePresale_Response|\patest\StructType\UpdateSoldItemsPrice_Response|\patest\StructType\UpdateSubscriptionInstancesMaxAllowedExchanges_Response|\patest\StructType\UpdateSubscriptionItemPropertiesResponse|\patest\StructType\UpdateSubscriptionResponse|\patest\StructType\UpdateTicketItemProperties_Response|\patest\StructType\UpdateTicketViewAssociationPrioritiesByIdsResponse|\patest\StructType\UpdateTicketViewAssociation_Response|\patest\StructType\UpdateTicketViewComponentById_Response|\patest\StructType\UpdateTicketViewConfigurationImageResponse|\patest\StructType\UpdateTransactionProperties_Response|\patest\StructType\UpdateUppConfigurationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
