<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unsubscribe ServiceType
 * @subpackage Services
 */
class Unsubscribe extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named UnsubscribeFromGlobalMonitors
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UnsubscribeFromGlobalMonitorsRequest $iTenantAdministrationService_UnsubscribeFromGlobalMonitors_RequestMsg
     * @return \patest\StructType\UnsubscribeFromGlobalMonitorsResponse|bool
     */
    public function UnsubscribeFromGlobalMonitors(\patest\StructType\UnsubscribeFromGlobalMonitorsRequest $iTenantAdministrationService_UnsubscribeFromGlobalMonitors_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UnsubscribeFromGlobalMonitors($iTenantAdministrationService_UnsubscribeFromGlobalMonitors_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UnsubscribeFromTrace
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UnsubscribeFromTraceRequest $iTracePublisherService_UnsubscribeFromTrace_RequestMsg
     * @return \patest\StructType\UnsubscribeFromTraceResponse|bool
     */
    public function UnsubscribeFromTrace(\patest\StructType\UnsubscribeFromTraceRequest $iTracePublisherService_UnsubscribeFromTrace_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->UnsubscribeFromTrace($iTracePublisherService_UnsubscribeFromTrace_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Unsubscribe
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\UnsubscribeRequest $iNotificationsService_Unsubscribe_RequestMsg
     * @return \patest\StructType\UnsubscribeResponse|bool
     */
    public function Unsubscribe(\patest\StructType\UnsubscribeRequest $iNotificationsService_Unsubscribe_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Unsubscribe($iNotificationsService_Unsubscribe_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\UnsubscribeFromGlobalMonitorsResponse|\patest\StructType\UnsubscribeFromTraceResponse|\patest\StructType\UnsubscribeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
