<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Subscribe ServiceType
 * @subpackage Services
 */
class Subscribe extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SubscribeForGlobalMonitors
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SubscribeForGlobalMonitorsRequest $iTenantAdministrationService_SubscribeForGlobalMonitors_RequestMsg
     * @return \patest\StructType\SubscribeForGlobalMonitorsResponse|bool
     */
    public function SubscribeForGlobalMonitors(\patest\StructType\SubscribeForGlobalMonitorsRequest $iTenantAdministrationService_SubscribeForGlobalMonitors_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SubscribeForGlobalMonitors($iTenantAdministrationService_SubscribeForGlobalMonitors_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SubscribeForTrace
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SubscribeForTraceRequest $iTracePublisherService_SubscribeForTrace_RequestMsg
     * @return \patest\StructType\SubscribeForTraceResponse|bool
     */
    public function SubscribeForTrace(\patest\StructType\SubscribeForTraceRequest $iTracePublisherService_SubscribeForTrace_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SubscribeForTrace($iTracePublisherService_SubscribeForTrace_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Subscribe
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SubscribeRequest $iNotificationsService_Subscribe_RequestMsg
     * @return \patest\StructType\SubscribeResponse|bool
     */
    public function Subscribe(\patest\StructType\SubscribeRequest $iNotificationsService_Subscribe_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->Subscribe($iNotificationsService_Subscribe_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\SubscribeForGlobalMonitorsResponse|\patest\StructType\SubscribeForTraceResponse|\patest\StructType\SubscribeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
